+++
author = ["authors/frank-pesci.md"]
categories = "Op-ed"
date = "2017-06-25T09:43:00-06:00"
lastmod = "2017-06-25T22:44:00-06:00"
preamble = "This is the second in a series of essays by composer and guest contributor Frank Pesci. In four installments originally published on [New Music Box](http://www.newmusicbox.org/articles/author/frank-pesci/), Pesci recounts his participation in Fort Worth Opera's [Frontiers](http://www.fwopera.org/operas/frontiers/) showcase, a major opportunity for emerging American composers. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498406034583/2017-06-24---Pitch.jpg.jpg"
publishDate = "2017-06-25T22:05:00-06:00"
related_articles = ["articles/preparing-for-performance-what-i-didnt-know-i-knew.md"]
related_companies = ["scene/companies/fort-worth-opera.md"]
short_description = "I could easily represent myself as a safe choice, saying, in effect, &quot;I&#039;m not going to be a problem for you. I’m not one of those crazy egocentric composers who is going to make ridiculous demands and make you sorry you wanted to work with me.&quot; I can assuage these preconceptions with a picture that pretty much sums me up: &quot;I&#039;m normal!  I&#039;m a nice guy! I&#039;m wearing tweed, for God&#039;s sake!&quot;"
slug = "taking-tweed-seriously-lessons-for-the-emerging-opera-composer"
title = "Taking tweed seriously: lessons for the emerging opera composer"
+++

"I am becoming a better opera composer" is my brand, to borrow a word from the marketing world. When I was in non-profit administration, we would talk about this quite a bit. We were trying to distill our "soul" — what drove us, as an organization, to do what we did — and then make that into something recognizable to the public that we could, in turn, utilize at fundraising time.  While not my favorite term, The Brand provides a compass, an overarching explanation as to why I make my decisions regarding my work and how I advance plans that will hopefully lead to collaboration. Just saying it — identifying The Brand — doesn't necessarily translate into anybody buying what I am selling, but it does remind me of my true north.

Opera is an inherently collaborative endeavor. My understanding of the inner workings of the writing and production of opera, and the collaboration required to make it all happen is the bridge that connects The Brand (which is theoretical and internal), and the reputation I want to develop in the real world: the impression I make on those around me as work proceeds.

It's a bit of a tall order to get that across with a few website tweaks and a new set of headshots, but embodying The Brand is my responsibility, as is communicating it to potential collaborators.  I could easily represent myself as a safe choice, saying, in effect, "I'm not going to be a problem for you. I’m not one of those crazy egocentric composers who is going to make ridiculous demands and make you sorry you wanted to work with me." I can assuage these preconceptions with a picture that pretty much sums me up: "I'm normal!  I'm a nice guy! I'm wearing tweed, for God's sake!" But safe is not safe when so few opportunities exist. What The Brand demands of me — and the reputation I wish to establish — is to present myself as an engaging collaborative professional with a clear artistic vision and a solid understanding of the art form, while also demonstrating the leadership skills necessary to bring it to life.

## Love in an elevator

Frontiers was my first foray into the American opera machine. I met other composers, singers, conductors, and general directors both at Fort Worth, and later at the Opera America convention, which ran concurrently in Dallas. Everybody talked, networked, and traded experiences and plans. I knew this was coming, so I quickly had to prepare for succinct conversations about myself, every aspect of my portfolio, and every opera in my portfolio.

In my admin days, the "brand" discussion was always followed by the obsessive for the perfect elevator speech — a pitch given in less than 30 seconds to someone with undivided attention. Mostly used when approaching new donors, the goal was getting a check or a pledge of future support.  I actually followed quite a few marks into literal elevators, so the name wasn’t too misleading.

The same thinking applies when prepping myself to pitch completed, current, and dreamed - about opera projects. With these pitches, I throw things against the wall in hopes that either they will stick or result in a "positive rejection" (a pass on the project at hand, but an expressed interest in a potential future collaboration).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498405930561/PesciInTweeds.jpg.jpg)
<figcaption>Frank Pesci in a tweed jacket inside Bass Hall for a performance by the Ft. Worth Opera.</figcaption>
</figure>

## Who am I, anyway?

I have a diverse background. My writing and performing experience spans rock, pop, jazz, funk-fusion, liturgical music, pit bands, musical theater shows, opera, lonely coffee house singer-songwriter stints where the only thing I was serenading was the coffee, and a smattering of orchestra gigs. On top of that, my work history includes teaching, working with special needs communities, administration, executive leadership, grant writing and fundraising, and restaurant work. I even sold women's clothes for a while. I don't exactly embody the traditional compositional pedigree. To practice talking about my musical self, I had to be able to talk to everyone about my musical self — not just other musicians, and certainly not just general directors, conductors, and dramaturges.

I developed one pitch for non-professionals, completely devoid of jargon. It was liberating! Crafting an easily understandable, yet engaging personal pitch became much less threatening. It focuses on the "what" of what I do, and less so, the "why" or "what I'm trying to accomplish." I extended that technique into my opera pitches. I initially thought that I simply needed to describe what happens in the course of a show and could leave out leitmotivs, dramaturgical nuance, or what the piece "means." I started big, by reverse-engineering a "treatment" — a scene-by-scene narrative format, complete with descriptions of arias, plot devices, and even some general staging recommendations. One size smaller is the synopsis, which is more general, focusing on what happens act to act. The show could then be distilled into the pitch, about 50 to 100 words that could be delivered verbally in 30 seconds, answering the question, "Why should I be interested in this opera?" The hardest-hitting part of the pitch is the hook—the first sentence that should set up what piqued my interest, and why I wanted to write the damn opera in the first place.

## The best laid plans…

In the months ahead of Frontiers, I wrote and rewrote my opera pitches, and practiced with colleagues and friends. The feedback quickly coalesced into a common critique: I had written myself out of my pitches. I was pitching interesting shows that in no way could be traced back to me as the creator. I had followed my own advice so meticulously that my pitches were "correct," but completely impersonal.  Also, I had somehow convinced myself that the show would be seen as more important than the work I had done to write the show. Two nail-biting weeks before I flew to Texas, I started from scratch, rewriting my pitches with myself, my skills as a composer, and what drew me to the subject as the hook. In doing so, I was now selling my craft and myself; in practice, I became The Brand, and The Brand became me.

In doing so, I averted a potentially fatal flaw in my presentation. This was made aware to me in my first meetings with conductors, singers and general directors. As I learned in my initial telephone outreach with American opera companies, the long view of a personal relationship is key to successful artistic collaboration. Leading with who I am, what I'm working on, and how (and why) I'm approaching my work is far more engaging, open and fulfilling.
