+++
author = ["authors/vanessa-chumbley.md"]
categories = "Op-ed"
date = "2017-04-18T12:56:00+01:00"
lastmod = "2017-04-19T11:12:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1492517001092/2017-04-18---Full-time.jpg.jpg"
publishDate = "2017-04-18T20:10:00+01:00"
related_articles = ["articles/giving-up-caring-too-little-and-other-taboos.md","articles/when-lost-find-roots.md"]
short_description = "Throughout my freelance life, more often than not, the workload-to-compensation ratio was astronomically out of balance, but it soon became apparent that this was more of the rule than the exception. And of course, most of us accept these conditions because this is how we get work and experience, in the hopes that it will lead to bigger and better gigs where that ratio will hopefully seem a little more civilized."
slug = "taking-the-leap-from-freelance-to-fulltime"
title = "Taking the leap from freelance to full-time"
+++

>"The future isn’t just something that happens. It’s a brutal force with a great sense of humor that will steamroll you, if you’re not watching." -- Aloha

If you're reading this, you likely have at some time, or are currently, working as a freelance artist. I know that hustle, having spent the past six years as a freelance stage manager. At first it's thrilling – the traveling, meeting endless new friends, having sinful amounts of fun, living the minimalist life in vagabond fashion.

But after a few years, the beer goggles begin to fall away and you think maybe you don't want to travel as much, or at least not have to travel as much in order to scrape by. Maybe you want to have a real home, or heaven forbid a pet, significant other, or financial stability.

You start to peruse job postings for full time positions, even if they're not exactly
in your field. You even apply for a couple of them. You're scared to leave what's familiar, you're afraid to take yourself out of the freelance race, and at the end of the day you actually really do love what you do – so is all of that security and "real life" glamour worth the risk?

If there's one thing I've tried to be more conscious of recently – it's the importance of listening to your gut, your inner voice, God – whatever you call that thing inside of you that will help guide you if you’re able to listen. People often say when they met their life partner, they just knew. Or when an opportunity came up, something clicked inside and they knew it was the right time to change paths.

My gut spoke up recently when I was offered a full time, salaried stage management position (one in my field, even!). The whole process from initial conversation, to signing a contract, to moving 1,200 miles all happened in the blink of an eye. I barely had a moment to process any of it until recently. But, my gut spoke and so I took a leap of faith. And since then, some of the things I've realized about myself and this profession have taken me a bit by surprise.

Maybe most surprising of all was the massive amount of guilt that emerged surrounding my new employment. I'll spare you the in depth psychoanalysis of my personal issues with guilt, worthiness, etc. – but as I continue to further extract myself from the trenches of that freelance battle, I’m beginning to see clearly some aspects of that life that had only nudged at my consciousness before now.

I should preface this by saying that this has not been the case with every person or every company I have worked with, and I fully appreciate the constraints within performing arts organizations that can lead to a certain kind of work environment. (Let's be honest, these constraints usually boil down to the financial parameters within which we try to create great art.)

That being said – it struck me that maybe one of the reasons I was feeling so guilty about suddenly having a full benefits package, paid time off, a legitimate retirement fund, etc., was that as a freelance artist I was never made to believe that I deserved any of those things. And/or these things did not exist in my field due to said financial constraints, and that that's just the way it is, and if I didn't like it I could leave. (I think we all quickly learn the reality that none of us are irreplaceable.)

Throughout my freelance life, more often than not, the workload-to-compensation ratio was astronomically out of balance, but it soon became apparent that this was more of the rule than the exception. And of course, most of us accept these conditions because this is how we get work and experience, in the hopes that it will lead to bigger and better gigs where that ratio will hopefully seem a little more civilized.

There were times I felt taken advantage of as an employee, where I literally did not have time to take care of some basic human needs outside of work. On some of these occasions it seemed as though the people I was working for couldn't care less about how their employees were coping, or the environment within their department. The work had to get done, and we also better be pleasant and 100% on top of everyone else's needs in the rehearsal room. But again, we accept this as a necessary evil of the job, and we take work where we can get it.

Again, this was not the case with every gig, but it also was not unique to one or two places. I do think I had some deeply rooted belief that I did not deserve these things this new job was offering me, and that my own personal feelings of inadequacy were not entirely to blame for that belief. I was taught to never expect certain perks and benefits that any average person in almost any other field would certainly expect. Over time, continuing to accept these conditions can subconsciously make you believe you're unworthy of anything more.

And so, when someone came to me and actually offered those perks and benefits, offered them like it was standard business as usual, I didn't know how to react. For awhile, my reaction consisted solely of guilt, anxiety, and fear. Do I really deserve all this? What makes me worthy of this opportunity over all of the other highly qualified people who I know applied? What if I get there and they immediately regret hiring me because they realize I'm no good? Am I ready to uproot my entire life and the next six months worth of plans to take advantage of this opportunity?

>"Yeah, well, guilt is nature's Adderall and shame is nature’s cocaine." -- Grace and Frankie

They say that in life, timing is everything, and how true that is. Although, it can be close to impossible to appreciate life's timing until you’re looking at it in hindsight. It was exactly two weeks to the day after publishing [this Schmopera article](/real-talk-the-unspoken-realities-of-a-professional-artistic-life/) that I received the initial email that soon led to this new chapter of my life, this new job that is exactly what I had in mind when I wrote – "There are, of course, the fortunate few who have landed a more permanent stage management gig, and a job like that would be my dream."

Maybe my desperation for stability and a way to fulfill other parts of my life had reached its zenith, and fate decided to throw me a bone in the form of this job. Because who knows how much longer I would've lasted in that freelance hustle, I would be lying if I said I hadn't been feeling scared about my future. It can be easy to lose faith, but another thing I believe is that when things actually work out, it's important to have an attitude of gratitude, to remember to hold onto that faith through the [valleys](/when-lost-find-roots/) of your life, and to also [send the elevator](/artistic-success-pay-it-forward/) back down for those beginning to make their way.

The guilt and anxiety have not yet fully subsided. But the hardest part is behind me, and I start this new chapter knowing that have I have summited and surpassed higher mountains and more challenging obstacles than this throughout my life, which have all given me the tools necessary to tackle this one. And that, just maybe, I am capable and worthy of this new opportunity and its perks. And if I am – then so are you.

>"Life has a funny way of sneaking up on you, when you think everything's okay and everything's going right. Life has a funny way of helping you out when you think everything's gone wrong and everything blows up in your face." -- Alanis Morissette, Ironic
