+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-04-24T18:15:00-04:00"
lastmod = "2018-04-24T21:09:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618220223/sq18-2SweeneyTodd0223r_preview.jpg.jpg"
primary_image_credit = "Photo by Joan Marcus ©2018."
publishDate = "2018-04-24T21:09:00-04:00"
related_articles = ["articles/elitism-irony-and-the-phantom-of-the-opera.md","articles/sublime-heartbreak-jesus-christ-superstar.md"]
short_description = "Audiences have been flocking to the Barrow Street Theater, which has been converted into a 135-seat pie shop, for over a year. The producers have the delicious cheek to sell meat pies, by reservation only, prior to each performance. They will be serving up those pies well into the summer."
slug = "sweeney-todd-demon-of-disguise"
title = "Sweeney Todd: Demon of Disguise"
+++

## The Disguise Comes Off

Benjamin Barker has been masquerading as more than a demon barber all these years. Beneath the grandeur of his disguise as top-drawer musical theater, *Sweeney Todd - the Demon Barber of Fleet Street* has the soul of an opera. The current revival by London's Tooting Arts Club has stripped this *Sweeney* down to its bare essentials and it is daringly operatic.

Audiences have been flocking to the Barrow Street Theater, which has been converted into a 135-seat pie shop, for over a year. The producers have the delicious cheek to sell meat pies, by reservation only, prior to each performance. They will be serving up those pies well into the summer.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618372810/18-2SweeneyTodd0064r_preview.jpg.jpg)
<figcaption>Thom Sesma as Sweeney Todd and Sally Ann Triplett as Mrs. Lovett. Photo by Joan Marcus ©2018.</figcaption>
</figure>

Sweeney Todd is too damaged to look his fellow man in the eye. As played by Thom Sesma, he is poised but tense and more on guard than in control. His anguish, stemming from years of hellish incarceration on trumped up charges, and the loss of his family, is not expressed in representational terms. He conveys it in jagged barks, sudden shouts and violent gestures that evoke Alban Berg's *Wozzeck*. Sesma's voice is penetrating, even as his acting assumes instances of questionable distance. It is when his Sweeney comes unhinged, which is a good deal of the time, that he most effective.

Then he walks into Mrs. Lovett's pie shop. "Benjamin Barker," Lovett exhales in a guttural and conspiratorial hush when she realizes who Sweeney really is. Sally Ann Triplett's Mrs. Lovett is like Elektra, determined and a little crazy, discovering that she is talking to her brother Orest whom she thought dead. This is Sweeney's recognition scene. Mrs. Lovett may at times seem more dizzy than diabolical but she operates firmly in the latter. A romantic and a conniver, she has the drive of Elektra and the wish list of her sister, Chrysothemis. Her rendition of "By the Sea," is jolly and desperate, quite a feat for a patter song. So here we have a Straussian tinged hybrid packed in a Gilbert and Sullivan persona. Triplett's Lovett is one of the funniest and most powerfully sung to come along.

## On One Hand… 

On one hand, very little separates the genres of opera and musical theater. Both employ sung music and to varying degrees, spoken word. So there has to be something else that causes the schism, if that is what it is.

Some say operas are cast with singers who can sing the parts whereas musicals are cast with singing actors who look like the parts that they play. This rigid thinking ignores the fact that opera singers are required to be more physically and intellectually convincing than ever. Also, singers from both camps increasingly glide into each other's territory with ease and much critical and popular success. 

Most noticeably there is Bryn Terfel who has sung Sweeney and Wotan and Renée Fleming, who, having recently retired the Marschallin, is currently singing *Carousel*'s Aunt Nettie on Broadway. Tony winners Kelli O'Hara and Paulo Szot sing at the Metropolitan Opera. Or is it that these two Met artists have also won Tony awards? 

On the other hand, almost everything separates opera and musical theater. Opera strives to integrate sung music with a libretto in a virtually seamless flow. Musical theater is comprised of a book of dialog that leaves places for songs, which ideally further the plot.

Nowadays, new operas, or significantly rethought existing works, emerge from cooperative ventures between opera companies or from commissions that involve private philanthropy. It is too easy to keep count of the new operas on the horizon.

The current trend in musical theater increasingly involves the adaptation of animated films and flushed out jukebox concepts that are assembled by entertainment conglomerates. There are notable exceptions and we are grateful for them.

When it comes to musical revivals and opera warhorses, the genres again converge. Generally speaking, the same operas are performed year after year. In musical theater revivals often define a season. Both genres suffer from the same lassitude. Perhaps some cross-pollination would energize them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618397663/18-2SweeneyTodd0125r_preview.jpg.jpg)
<figcaption>The company of *Sweeney Todd*. Photo by Joan Marcus ©2018.</figcaption>
</figure>

## The Dissonant Revival

The Tooting *Sweeney* is a revival, and not even New York's first, but it has turned *Sweeney* inside out to show its structure. To term it rethought is to sell it short. It looks, feels, and acts like a brand new show. 

In place of an orchestra, we have a piano, violin and clarinet accompanied by members of the eight-person cast, playing, appropriately enough, knives and forks. Under such unassuming but inspired circumstances, the dissonance in the score comes through. You hear it almost immediately.

Dissonance is also apparent in the vocal work, especially when members of this multi-tasking cast function as a chorus. We hear those atonal surges more clearly coming from a few voices than we do from a multitude of them. Though Sondheim's dissonant moments mingle with sublime and powerful melody, it is evident that *Wozzeck* and *Lulu*, Berg's other opera, are lurking in the shadows and sometimes strutting right down the center of Fleet Street.

Anthony and Johanna, the young, would-be lovers, sing two of the shows melodies, "Johanna," and "Green Finch and Linnet Bird," respectively.
The sequence begins with "Johanna," and is followed by Anthony's extremely rhythmic recitative, "Ah, Miss," and then segues into "Linnet Bird." Finally the two songs are combined in duet.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618435394/18-2SweeneyTodd0382r_preview.jpg.jpg)
<figcaption>DeLaney Westfall as Johanna and Billy Harrigan Tighe as Anthony. Photo by Joan Marcus ©2018.</figcaption>
</figure>

It is here that *Sweeney* is at its most traditionally operatic. Billy Harrigan Tighe and DeLaney Westfall have attractive voices that work pleasingly together and separately. They maintain Sondheim's musical line and keep their songs distinct yet beautifully connected. Their other duet, "Kiss Me," is rapturously sung and not entirely melodic.

Stacie Bono plays Adolfo Pirelli, a corrupt barber and hawker of miracle elixirs, in a clever bit of trouser-part casting. Pirelli, though slimy and vindictive, is superficially a buffoon out of Opera buffa. However, when Bono switches roles and plays the crazed Beggar Woman, she travels in wails, moans and chants that reference Berg. Bono's versatility is unmatched.

"Pretty Women," the duet belonging to Sweeney and Judge Tupin, won't knock "Au fond du temple saint" from Bizet's *The Pearl Fishers* off the favorite duets chart, but its mastery of harmony from opposing characters and intense feeling at cross-purposes, earn it a special place. Michael James Leslie as Turpin adds a touch of shyness to his booming voice, giving the malevolent judge an unsettling, vulnerable dimension. John Rapson's Beadle Bamford, Turpin's lackey enforcer, has a sweet tenor sound and comic timing that belies his character's creepy and brutal nature. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618490517/18-2SweeneyTodd0223r_preview.jpg.jpg)
<figcaption>Michael James Leslie as Judge Turpin and Thom Sesma as Sweeney Todd. Photo by Joan Marcus ©2018.</figcaption>
</figure>

Zachary Noah Piser is a mischievous, high-energy Tobias. His and Mrs. Lovett's not quite duet, "Not While I'm Around," is touching despite its irony. I can't think of a song or an aria that so compellingly extends the story and captures the complicated attitudes of its characters. The interplay of lyric and recitative between the two of them would be magical if the situation in which it is taking place weren't so dire.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618530624/18-2SweeneyTodd0199r_preview.jpg.jpg)
<figcaption>Sally Ann Triplett as Mrs. Lovett. Photo by Joan Marcus ©2018.</figcaption>
</figure>

If you doubt the operatic unity that is imbedded in the score, give "Epiphany," and the reprise of "Johanna," a closer listen. For that matter, give the whole recording a closer listen. It takes time to get to know *Sweeney*, one of the reasons that it is so enduring. Sondheim isn't using operatic techniques to elevate the status of musical theater. He has created his own kind of contemporary operatic piece, at times an audacious one. He mines elements of opera so deeply and integrates them so thoroughly, that they have gone largely unnoticed, until the Tooting *Sweeney* removed the disguise.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1524618546758/18-2SweeneyTodd0037r_preview.jpg.jpg)
<figcaption>Thom Sesma as Sweeney Todd. Photo by Joan Marcus ©2018.</figcaption>
</figure>

Finally, there is the Act one showstopper, "A Little Priest." This shocking tune fairly lilts as its rhymes dazzle, even after hearing it for the umpteenth time. Close your eyes and it could be a sparkling waltz right out of a production of *Die Fledermaus* that has gone terribly wrong.
