+++
author = ["authors/jenna.md"]
categories = "Review"
date = 2020-01-17T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Lynn Nottage's [_Sweat_](https://www.canadianstage.com/online/default.asp?doWork::WScontent::loadArticle=Load&BOparam::WScontent::loadArticle::article_id=B6AF1B73-8599-4F2C-9C99-0DCE81639A9A) runs at Canadian Stage through February 2."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1579285403/media/2020/01/sqSweat-1OrdenaStephensThompsonRonLeaKelliFox_y245od.jpg"
primary_image_credit = "(l-r) Ordena Stephens-Thompson, Ron Lea, and Kelly Fox in Sweat, Canadian Stage/Studio 180 Theatre, 2020. Photo: John Lauener."
related_articles = ["articles/belle-darling-klondike-queen.md", "articles/in-review-harper-regan.md"]
related_companies = []
related_people = []
short_description = "\"Their stories broke my heart and invited me to see the world from another's perspective; to be moved by people who I would not ordinarily encounter,\" writes Nottage of Sweat. \"As a Black woman from Brooklyn I hadn't expected that I would be so profoundly moved by their predicament.\""
slug = "humbling-theatre-Sweat"
title = "Humbling theatre: Sweat"
youtube_url = ""

+++
Thursday saw the Toronto premiere of Lynn Nottage's Pulitzer Prize-winning play, [_Sweat_](https://www.canadianstage.com/online/default.asp?doWork::WScontent::loadArticle=Load&BOparam::WScontent::loadArticle::article_id=B6AF1B73-8599-4F2C-9C99-0DCE81639A9A), marking the first full partnership between Canadian Stage and Studio 180 Theatre. It's a thoroughly American story, inspired and researched in the world of unionized factory workers who had been squeezed, pressured, and literally locked out of their workplace as the new millennium arrived and corporate greed spread its tendrils, noticeably unchecked.

Nottage makes a microcosm of Reading, Pennsylvania, which in 2011 was the poorest city of its size in all of the US; before that, it was a factory town, where people had one job to carry them from high school graduation to (hopefully) retirement and a generous pension. The playwright spoke with workers from the steel factory in Reading, who were 93 weeks into a lockout, essentially forced out of their jobs and watching their retirement plan - the whole plan, really - go up in a puff of smoke.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579285564/media/2020/01/Sweat3-JhonattanArdilaKelliFox_npkxxj.jpg){{% /md %}}

<figcaption>Jhonattan Ardila and Kelli Fox in Sweat, Canadian Stage/Studio 180 Theatre, 2020. Photo: John Lauener.</figcaption>  
</figure>

"Their stories broke my heart and invited me to see the world from another's perspective; to be moved by people who I would not ordinarily encounter," writes Nottage of _Sweat_. "As a Black woman from Brooklyn I hadn't expected that I would be so profoundly moved by their predicament."

There is something acutely ironic about a play that tells this story. For the most part, the people in _Sweat_ couldn't be more removed from the people who create and consume theatre. The fictional (but not really) steel factory workers of Reading, PA, live in a small world that extends from work to familiar dive bar to home, in a continuous circuit for their entire adult lives. Career risks aren't celebrated - not even post-secondary education is universally admired - and no one, really, is planning for unforeseen circumstances. They're in a union, after all.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579285633/media/2020/01/Sweat8-TimothyDowleColtmanKelliFoxJhonattanArdilaChristopherAllen_qj2i58.jpg){{% /md %}}

<figcaption>(l-r) Timothy Dowler-Coltman, Kelli Fox, Jhonattan Ardila, and Christopher Allen in Sweat, Canadian Stage/Studio 180 Theatre, 2020. Photo: John Lauener.</figcaption>  
</figure>

It's almost the opposite of the artist's life, where artistic and professional fulfillment are considered worthy of risky actions like freelance work and international travel. Job insecurity is a given, the ever-changing gig the norm. And Nottage touches on that gulf that lies between the idea of a playwright and the idea of a factory worker; it's about stereotypes, but it's also about individual, real people.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579285678/media/2020/01/Sweat9-ChristopherAllenTimothyDowlerColtmanJhonattanArdilaPeterN_xdmul8.jpg){{% /md %}}

<figcaption>(l-r) Christopher Allen, Timothy Dowler-Coltman, Jhonattan Ardila, and Peter N. Bailey in Sweat, Canadian Stage/Studio 180 Theatre, 2020. Photo: John Lauener.</figcaption>  
</figure>

_Sweat_ is riveting; every scene draws a reaction. It's real and organic, and not averse to great dramatic twists. I can tell it's a good play - and a good production by David Storch - because by the end, I felt entirely differently about the characters than I had at the start. The idiot who opted for a face tattoo - reading "SKIN-swastika symbol-HEAD" - became a real person who acted badly out of misdirected rage and a limited world view. The laughable drunk becomes a woman who, only in hindsight, regrets that she never took charge of her life decisions, and the realization comes on like a black hole.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1579285703/media/2020/01/Sweat10-KelliFoxOrdenaStephensThompsonRonLeaAllegraFulton_rqb541.jpg){{% /md %}}

<figcaption>(l-r) Kelli Fox, Ordena Stephens-Thompson, Ron Lea, and Allegra Fulton in Sweat, Canadian Stage/Studio 180 Theatre, 2020. Photo: John Lauener.</figcaption>  
</figure>

The play is certainly about a sliver of America, an exemplary story about what happened to working-class people between 2000-2008, during the time of George W. Bush and blaming poverty on minorities. But _Sweat_ is unifying in a humbling way. Everyone has pride, the kind that occasionally blinds us to wise decision-making; everyone loses against corporate greed; there's nearly always time for prejudice and ignorance. And, no matter how broke we are, we always find money to drink.