+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-03-23T10:16:00-04:00"
lastmod = "2018-03-23T21:22:00-04:00"
preamble = "**April 6-8**, [Nashville Opera](/scene/companies/nashville-opera/) presents [Carlisle Floyd's *Susannah*](http://www.nashvilleopera.org/susannah/), the 1955 opera about a young woman who, through others' jealousy and shame, is faced with hostility and ostracization from her church community. There's something about the story of *Susannah* that is at once endearing, tragic, and maddening, and it's told through an affective score that sounds organically American.\n\nWe spoke with Dean Williamson, Music Director of Nashville Opera and conductor for [*Susannah*](http://www.nashvilleopera.org/susannah/), about the unique power of presenting this opera to Tennessean audiences, the meaning of its Appalachian melodies, and the storytelling in Floyd's score."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521814010181/sq---Dean--Maria.jpg.jpg"
primary_image_credit = "Nashville Opera Music Director Dean Williamson conducting a 2017 production of Maria de Buenos Aires."
publishDate = "2018-03-23T20:39:00-04:00"
related_articles = ["articles/nashville-operas-carmen-she-dies-because-she-told-a-man-no.md","articles/new-operas-craig-bohmlers-riders-of-the-purple-sage.md"]
related_companies = ["scene/companies/nashville-opera.md"]
short_description = "&quot;I particularly love the wide open interval leaps in her first aria &#039;Ain&#039;t it a pretty night.&#039; You feel Susannah&#039;s longing to escape the small town and you see the beauty of the mountains and valleys before her. It&#039;s pure Americana in spirit and sound.&quot;"
slug = "susannah-is-the-great-original-american-opera"
title = "&quot;Susannah is THE great original American opera.&quot;"
+++

## What do you think is the significance of performing *Susannah*?
 
From a musical perspective, *Susannah* is THE great original American opera. More than 50 years later, it remains one of the most performed in the repertoire. It was groundbreaking in its time and influenced everything that followed it, encouraging American composers to find their own voice in a European art form.
 
### Seeing as this opera is set in Tennessee, what does Nashville Opera understand about this opera that other audiences may not grasp?
 
The Tennessee audience will immediately understand the cultural and religious background of the story. The language used is vernacular and colloquial, capturing the east Tennessee/Appalachian lifestyle with great respect. The collective Tennessean experience we have in the chorus and staff is ensuring a real authenticity to the pronunciation of the dialect.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1521851743524/Dean--headshot.jpg.jpg)
<figcaption>Dean Williamson, Music Director of Nashville Opera.</figcaption>
</figure>
 
## How does Carlisle Floyd use Appalachian melodies in this score?
 
The melodies and hymns in the opera are inspired by Appalachian tunes, but are not actual songs. He even writes a chorus evocative of the *Dies irae* chant of the dead in the final scene, similar to what Orff did in *Carmina Burana*. The melodies and hymns are woven throughout to create a mood and affect our emotions as in a cinematic soundtrack.
 
## Based on your close interaction with the score, how does the music tell the sensitive story of this young woman?

Floyd uses the same *leitmotif* technique as Wagner did, assigning melodies or snippets of tunes to each character or emotion. We hear many of them in the opening orchestral prelude, and they reappear throughout the score. They are developed and altered in the orchestral accompaniment, almost like a jazz musician riffs on an idea. For example, the very opening of the opera is the Elder's music: sharp, jagged rhythms in a minor key depicting the judgmental tone of the Elder men towards Susannah. This music reappears many times when Susannah is anguished. I particularly love the wide open interval leaps in her first aria "Ain't it a pretty night." You feel Susannah's longing to escape the small town and you see the beauty of the mountains and valleys before her. It's pure Americana in spirit and sound.

>Susannah runs April 6-8 at Nashville's Polk Theater. For details and tickets, [click here.](http://www.nashvilleopera.org/susannah/)
