+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = "2024-03-01T00:00:00+01:00"
lastmod = "2024-03-01T00:00:00+01:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1709298156/sqPacific_Opera_Ainadamar_0543.jpg"
primary_image_credit = "Dancers from Alma de España Flamenco Dance Company with Hannah Hipp as Federico Garcia Lorca in Ainadamar, directed by Brian Staufenbiel. Pacific Opera Victoria, 2024. David Cooper Photography."
postamble = ""
publishDate = "2024-03-01T00:00:00+01:00"
related_articles = ["articles/angel-s-bone-disturbing-the-comfortable.md", "articles/fantasy-is-for-the-birds/.md", "articles/vancouver-opera-sails-away-in-the-flying-dutchman.md"]
related_companies = ["scene/companies/pacific-opera-victoria.md"]
related_people = ["scene/people/miriam-khalil.md"]
short_description = "Akin to a photographic vignette, each 'image' is a static setting onstage with highly stylized scenery, projections, and costumes. While the imagery is visually lush and brilliant, it made the pacing extremely slow, with little on-stage action to complement the modern design."
slug = "surrealism-in-spain-pacific-opera-victoras-ainadamar"
title = "Surrealism in Spain: Pacific Opera Victoria's Ainadamar"
+++
[Pacific Opera Victoria](/scene/companies/pacific-opera-victoria/), always on the forefront of presenting new, unusual, and lesser-known works as part of their regular season offerings, presents Golijov's _Ainadamar_, a Spanish-language, 21st-century opera written by Argentinian composer Osvaldo Golijov, and librettist David Henry Hwang, author of the Tony award-winning M. Butterfly.

The story centers around the history of Federico García Lorca, a Spanish author who was assassinated by Franco's Nationalists during the Spanish Civil War, and his muse Margarita Xirgu, a Spanish actress who was forced into exile under Franco's dictatorship. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1709298155/Pacific_Opera_Ainadamar_0625.jpg){{% /md %}}

<figcaption>Hannah Hipp, Miriam Khalil, and Sarah Shafer with dancers from Alma de España Flamenco Dance Company, and members of the Pacific Opera Chorus and Victoria Children's Choir in Ainadamar. Pacific Opera Victoria, 2024. David Cooper Photography.</figcaption>
</figure>

The opera is alternately titled "An Opera in Three Images", referring to the three "scenes" in the show. Akin to a photographic vignette, each "image" is a static setting onstage with highly stylized scenery, projections, and costumes. While the imagery is visually lush and brilliant, it made the pacing extremely slow, with little on-stage action to complement the modern design.

Many Spanish elements featured strongly in the production, including classical guitar in the orchestra, several Flamenco dancers from the Alma de España Flamenco Dance Company, and a traditional Flamenco singer in the role of Ruiz Alonso (played by Alfredo Tejada), who captured and eventually killed Lorca. Tejada's voice was haunting and beautiful - stylistically completely different from traditional opera singing, the flamenco singing style is powerful and passionate, and was a perfect contrast to the bel canto of the other singers. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1709298155/Pacific_Opera_Ainadamar_0725.jpg){{% /md %}}

<figcaption>Hannah Hipp as Federico Garcia Lorca and Miriam Khalil as Margarita Xirgu with dancers from Alma de España Flamenco Dance Company, and members of the Pacific Opera Chorus and Victoria Children's Choir in Ainadamar. Pacific Opera Victoria, 2024. David Cooper Photography.</figcaption>
</figure>

The Flamenco dancers were equally powerful and compelling, from agile footwork to beautiful lines, it was a wonderful complement to the other Spanish elements of the piece.

Soprano [Miriam Khalil](/scene/people/miriam-khalil/) as Margarita, soprano Sarah Shafer as Nuria, and mezzo Hanna Hipp in the trouser role of Lorca performed the layered and musically challenging roles ably, but would have benefited from more stage direction to make the scenes less static and help the pacing. A 40-minute finale with the only action being the POV chorus moving from one layer of the stage to another made the 80-minute show seem significantly longer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1709298156/Pacific_Opera_Ainadamar_0252.jpg){{% /md %}}

<figcaption>Alfredo Tejada with dancers from Alma de España Flamenco Dance Company and members of the Pacific Opera Chorus and Victoria Children's Choir in Ainadamar. Pacific Opera Victoria, 2024. David Cooper Photography.</figcaption>
</figure>

The opera swings back and forth in time, from 1969 to 1929, to 1936 and back, and the libretto focuses more on potent imagery than storytelling. These elements together made it difficult to follow any kind of story, or put together the order of the events. With the exception of the death and reappearance of Lorca as a general display of the brutality of the fascist regime, there was little to no action or movement of story.

The POV Orchestra, under the direction of newly-appointed Principal Conductor Giuseppe Pietraroia was brilliant, navigating a dynamically layered and technically challenging score with huge skill. A mesh of Rodrigo-meets-Philip Glass, Spanish-meets-minimalist score was kept well in hand by Pietraroia. Special nods to the guitarist, trumpet soloist, and percussionists for excellent solos throughout.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1709298156/Pacific_Opera_Ainadamar_0512.jpg){{% /md %}}

<figcaption>Hannah Hipp as Federico Garcia Lorca and Miriam Khalil as Margarita Xirgu in Ainadamar, directed by Brian Staufenbiel. Pacific Opera Victoria, 2024. David Cooper Photography.</figcaption>
</figure>