+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2020-02-08T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Boston Opera Collaborative's production of [_Le nozze di Figaro_](https://www.bostonoperacollaborative.org/figaro-feb-20) runs through February 9."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1581175839/media/2020/02/sqBOCFigaro1_qcdpch.jpg"
primary_image_credit = "Mitch FitzDaniel (Figaro) and Carley DeFranco (Susanna) in Le nozze di Figaro, Boston Opera Collaborative, 2020. Photo: Dan Busler."
related_articles = ["articles/4-ways-that-opera-really-is-life.md", "articles/4-opera-scenes-that-should-have-happened.md", "articles/diegetic-music-in-opera-3-ways-to-use-it.md"]
related_companies = ["scene/companies/boston-opera-collaborative.md"]
related_people = []
short_description = "The sum of all its parts coalesced into an evening that was immensely fun for the whole audience, and even got surprisingly political in the way Beaumarchais meant. Perhaps some of the orchestral playing was shaky in spots, but otherwise this production had barely a blemish on it anywhere. It is Le nozze di Figaro at its finest, and it was a comedic romp that is one for the ages, as far as this opera goes."
slug = "surprisingly-political-marriage-of-figaro-a-bubbly-delight"
title = "Surprisingly political Marriage of Figaro a bubbly delight"
youtube_url = ""

+++
When it comes to reinventing an opera that has proven to be a tried and true mainstay of the operatic repertory, there are very few people that would ever consider adding in any content, regardless of where it came from. Thus, whenever people decide to do something along those lines, it is always interesting to me to see the results, whether they work or they don’t.

Thus, we go to Boston Opera Collaborative’s [recent production of _Le nozze di Figaro_](https://www.bostonoperacollaborative.org/figaro-feb-20), which they decided to use to showcase a new performance edition titled _The Flexible Figaro_, compiled by Miriam Ellis and Sherwood Dudley. Aside from translating Da Ponte’s original Italian libretto into English, it also takes the liberty of adding in a lot of the dialogue from Beaumarchais’ original play that Mozart and Da Ponte excised to get the work past Viennese censors.

Of course, they opt to restore much this content as spoken dialogue, which a purist might be bothered by in combination with the recitative: however, I did not mind the separation in this production, and honestly I wouldn’t have trusted anyone who was not Mozart to create logical setting of that content anyhow.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581175921/media/2020/02/BOCFigaro2_ntbhiy.jpg){{% /md %}}

<figcaption>Jennifer Soloway (Countess) and Junhan Choi (Count) in Le nozze di Figaro, Boston Opera Collaborative, 2020. Photo: Dan Busler.</figcaption>

</figure>

Considering that the opera had to be created without it, you might ask yourselves whether the addition of the cut content from the original play really adds anything. You would be quite surprised to hear that, in a way, it’s a little bit more mixed than you might expect. On the one hand, Marcellina gets a monologue midway through the third act that kind of stops the action a bit. It’s hard to fault her point in this big rant about how men judge women in a certain vein (especially not considering the shenanigans that the Count forces everyone to get into to reinforce his chauvinistic pride even without the original Beaumarchais dialogue in there), but considering it comes off the heels of the big ensemble number in which Figaro and Marcellina are reunited as mother and son it felt weirdly placed in the show.

> Stephanie Hollenberg also absolutely stole the show as Cherubino, bringing a pluck to the character that makes him even more endearing than usual.

What worked considerably better was when these changes made dramatic sense, and fortunately Marcellina had a very feminist aside in the fourth act about how women flock to each others’ aid unquestioningly when she warns Susanna about Figaro’s jealousy, as it was better placed and had more dramatic relevancy to the show. The edition also does not mind changing some of the arias up: Figaro’s first act aria gets a small reprise in Act II, as if to reinforce the point of Figaro’s cleverness, and then Figaro’s fourth act aria is aimed not at women but rather at the aristocracy in general. The result actually works in the show’s favor, since Figaro seems cleverer and a touch more level-headed than he does in Da Ponte’s original libretto.

There is also an added episode with a pregnant village girl at the end of the third act that, on the surface, doesn’t really add anything: however, it does contribute to the chaos of the proceedings in the way that it adds to the dizzying nature of what happens with each colliding plan.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581176054/media/2020/02/BOCFigaro4_znlhuq.jpg){{% /md %}}

<figcaption>Stephanie Hollenberg (Cherubino) in Le nozze di Figaro, Boston Opera Collaborative, 2020. Photo: Dan Busler.</figcaption>

</figure>

For above all, what stands out to me the most is how little the proceedings actually change otherwise. It’s surprising how much Da Ponte was able to retain in the work: the opera’s legendary slapstick is kept completely intact, and apart from Marcellina coming out as the work’s most level-headed character in the second half of the show the characters are kept intact. Thus, it still allows Mozart’s score to shine through, and after all, is that not the strength of _Nozze di Figaro_?

> Choi’s antics were played so straight it was hard not to laugh at the way the other characters maneuvered around him.

Thus, at that point, all that is left is to perform the work well, and here singing in English may have transformed the whole evening. The singer-actors that dotted the stage of Longy School of Music’s concert hall were up to singing Mozart’s frequently challenging score with an eye for dramatic detail that is often lost in performances. The recitatives were quick, snappy, and full of character, and the various arias and ensemble numbers were all sung beautifully by practically everyone in the cast.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581175993/media/2020/02/BOCFigaro5_wr6hu7.jpg){{% /md %}}

<figcaption>Emily Harmon (Marcellina) and Marcus Schenck (Bartolo) in Le nozze di Figaro, Boston Opera Collaborative, 2020. Photo: Dan Busler.</figcaption>

</figure>

And what a cast it is: I have scarcely seen Mozart so well-cast in my life, and particularly with singers who can act as well as they sing! Mitch FitzDaniel is really beginning to come into his own: while his turn as Figaro came with a few awkward inflections in the spoken dialogue, he has so much fun as the character who could probably think his way out of any situation that it rubbed off on the whole production. Carley DeFranco proved every bit his match as the equally clever Susanna, and her constant glances to the side said volumes that her crystal clear voice did not. Stephanie Hollenberg also absolutely stole the show as Cherubino, bringing a pluck to the character that makes him even more endearing than usual, and Emily Harmon also ended up stealing the show with a Marcellina that starts off rather ridiculous but ends up being the rational core of the show in a strange way. And this is to say nothing of Junhan Choi as the Count and Jennifer Soloway as the Countess: Choi’s antics were played so straight it was hard not to laugh at the way the other characters maneuvered around him, and Soloway grounded her character in the grace necessary to make her work as the moral center of the show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1581175976/media/2020/02/BOCFigaro3_iffikr.jpg){{% /md %}}

<figcaption>Jennifer Soloway (Countess), Junhan Choi (Count), and Carley DeFranco (Susanna) in Le nozze di Figaro, Boston Opera Collaborative, 2020. Photo: Dan Busler.</figcaption>

</figure>

The direction, too, was generally outstanding, and it even added a few subtle touches to the production that worked very well. In particular, I remember a moment in Act I in which Figaro’s aria usually addressed fully to Cherubino is partly addressed to the Count: the touch here worked beautifully, because it mocked the Count with incredible subtlety that it was hard not to laugh at the Count’s expense. The staging also manages to make a lot of the busier ensemble numbers incredibly clear: the staging of the Act III ensemble in which Figaro is revealed to be Marcellina’s sun moves a lot, but the acting uses the space clearly to clarify the action, letting the Count and his appointed Judge hang out towards the back with all the other relevant action happening closer to the edge of the stage. And that is to say nothing of how deftly the slapstick was pulled off throughout the whole, particularly the Act IV kerfuffle where the Count swings at Cherubino and somehow hits Figaro instead.

The sum of all its parts coalesced into an evening that was immensely fun for the whole audience, and even got surprisingly political in the way Beaumarchais meant. Perhaps some of the orchestral playing was shaky in spots, but otherwise this production had barely a blemish on it anywhere. It is _Le nozze di Figaro_ at its finest, and it was a comedic romp that is one for the ages, as far as this opera goes.