+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-07-04T19:14:00-06:00"
lastmod = "2017-07-06T22:28:00-06:00"
preamble = "When it comes to sorting out a nasty bit of coloratura, stutter-inducing patter, or rhythms that make your eyes cross, [slow practice](/the-practice-tip-you-dont-want-to-hear/) is where it's at.\n\nConversely, sometimes it's just as handy to try speeding things up. Music that's meant to be slow can come with side effects like heaviness and stagnancy, which make the singing process unnecessarily difficult. Often the easiest way to find an aria's shape - and uncover some decent phrases - is to practice it at a metronome marking that's decidedly too fast.\n\nWe've picked four examples of slow arias, and how a temporary breakneck tempo can give your practice session some much-needed perspective."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499284384296/2017-07-05---Fast.jpg.jpg"
publishDate = "2017-07-06T22:28:00-06:00"
related_articles = ["articles/the-practice-tip-you-dont-want-to-hear.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/ditch-rubato.md"]
short_description = "Music that&#039;s meant to be slow can come with side effects like heaviness and stagnancy, which make the singing process unnecessarily difficult. Often the easiest way to find an aria&#039;s shape - and uncover some decent phrases - is to practice it at a metronome marking that&#039;s decidedly too fast."
slug = "surprising-practice-tips-4-arias-to-try-too-fast"
title = "Surprising practice tips: 4 arias to try too fast"
+++

## "Dalla sua pace"

Don Ottavio's aria from *Don Giovanni* is decidedly slow, and the static orchestration at the beginning means that "Dalla sua pace" can easily grind to a halt before it even gets going. It's not an easy sing, and the potential for schlepping adds unnecessary effort. Before you get this aria too deeply in your voice, spice up your practice routine by singing it way too fast - like, twice as fast as it should reasonably go.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499217334153/Slow-aria---Dalla.jpg.jpg)
</figure>

Singing it at breakneck speed will a) remind you that the aria is in 2 and not 4, and b) show you where the musical and textual phrases go. The idea is that when you do relax the tempo, you won't lose direction.

## "Lascia ch'io pianga"

The voice and orchestra move in tandem throughout most of this aria; something about that homogenous rhythm can make this simple aria from Handel's *Rinaldo* seem like it's stuck in quicksand. The trap here is in the two-bar mini-phrases that litter the page; speeding up this aria can be a handy way to get a zoomed out look at the score, and see bigger picture.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499217341321/Slow-aria---Lascia.jpg.jpg)
</figure>

Like with "Dalla sua pace", it's wise to make the too-fast experience a part of your practice routine early on. It's easier to hear and speak the complete sentences when the aria is closer to the pace of speech; when you slow it back down, you can let the interrupting rests be moments of emotional tension without deflating the long line.

## "Porgi, amor"

These are the first notes that the Countess sings in Mozart's *Le nozze di Figaro*, and it's understandable that this first aria can feel as though the soprano is walking on eggshells. The nice thing about "Porgi, amor" is that the orchestra is in motion; yet it's still the singer's responsibility to give direction to that movement. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499217349543/Slow-aria---Porgi.jpg.jpg)
</figure>

As refined-sounding as it is, if this aria were sung twice as fast, it might be a number for the likes of Susanna or Cherubino. There's simplicity and symmetry in this aria - classic Mozart - and there are little moments of decoration (like on the word "duolo"). Singing it at a glacial pace makes it hard to see the forest for the trees, and it can make grunt work out of what could be a more satisfying exercise in sustaining sound.

## Sarastro's arias

There's something almost funny about the combination of the bass voice and slow arias; it's like a caricature of a patriarchal figure, combined with operatic stereotypes about large, low-voiced men.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499217359555/Slow-aria---Hallen.jpg.jpg)
</figure>

Sarastro has two arias in *The Magic Flute*; they're both slow, and both have the potential to fall into the trap of stagnancy. "In diesen heilgen Hallen" is dangerously square, but remember the presence of dance music that's found in so much Mozart. Each measure has a sense of tension-and-release on its strong and weak beats; for example, the word "Hallen" should be sung as it's spoken, with the stress on the first syllable, and the second syllable coming gently away. It's much easier to feel this dance-rhythm idea when the aria is sped up; so start varying the tempo before you get too used to plodding along.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499217373262/Slow-aria---Isis.jpg.jpg)
</figure>

The 3/4 meter of "O Isis und Osiris" makes Sarastro's second aria an easier task. In most cases, triple meters also lend themselves well to a big, round sense of "one", the way a waltz leaps from downbeat to downbeat. Again, speeding up this ponderous aria can remind you of how to move forward through multiple bars at a time, instead of getting hung up on every note.

>Singers, which slow arias do you find surprisingly difficult to sing? What are your tips and tricks? Let us know in the comments below!
