+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-09-04T14:14:00-04:00"
lastmod = "2015-09-05T10:26:00-04:00"
preamble = "On Sunday, September 27th, [Oshawa Opera](/scene/companies/oshawa-opera/) presents Puccini's one-act, punch-packing tragedy, *Suor Angelica*. This in-concert production features Oshawa Opera's Artistic Director, Kristine Dandavino, at the piano, with a [cast](https://www.facebook.com/events/1635452866673086/) of Canadian talent. I spoke with Kristine, and with Ukrainian-Canadian soprano Natalya Matyusheva, singing the heartbreaking title role. \"We promise to have boxes of tissues in the audience, because, it is almost impossible to watch this opera without crying.\" Oshawa Opera, always considerate. *Suor Angelica* has one performance only; tickets are $25 online or at the door, with free admission for kids. For details, visit the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1441391035543/NatalyaHeadshotSquare.jpg.jpg"
primary_image_credit = "Soprano Natalya Matyusheva sings the title role in Oshawa Opera's production of Suor Angelica."
publishDate = "2015-09-05T10:03:00-04:00"
related_articles = ["articles/kristine-dandavino-on-oshawa-opera.md","articles/opera-101-with-kristine-dandavino.md"]
related_companies = ["scene/companies/oshawa-opera.md"]
related_people = ["scene/people/natalya-matyusheva.md","scene/people/kristine-dandavino.md","scene/people/christina-campsall.md","scene/people/kira-braun.md"]
short_description = "On Sunday, September 27th, Oshawa Opera presents Puccini&#039;s one-act, punch-packing tragedy, Suor Angelica. This in-concert production features Oshawa Opera&#039;s Artistic Director, Kristine Dandavino, at the piano, with a cast of Canadian talent. I spoke with Kristine, and with Ukrainian-Canadian soprano Natalya Matyusheva, singing the heartbreaking title role. "
slug = "suor-angelica-at-oshawa-opera"
title = "Suor Angelica at Oshawa Opera"
+++

### 1. Who is Suor Angelica?

**Natalya Matyusheva**: Every time you familiarize yourself with a new character of any narrative, in the beginning you can only scratch the surface. Angelica is a young nun at a convent in the late 17th century, she was pressured into nunnery by her noble and influential family for having an illegitimate child. That's how “simple” it is. But then comes music and the story unfolds with little snippets of the past in the dialogues evolving into the most dramatic ending.

I think Angelica is very young, not older than modern day 22. We can only guess what happened to her 8 years before the scene, she never shares any details with anybody, even herself; that is, I believe, unusual for an opera, and this makes it even more life-like and terrifying. Maybe she was in love, maybe she was seduced, victimized, we won't know – she never mentions the man, her only love is pure and pious. The love of a mother. Angelica had the strength to overpower grief, love (lust?), despair of estrangement but her motherly love is the only “human” feeling she is not willing to let go of.

In a way Angelica can be compared to Mother Mary, no matter how blasphemous it may seem from the religious stand point, that is why, she sees Mary in her last moments and is forgiven.

### 2. Why is *Suor Angelica* a good pick to open Oshawa Opera's season?

**Kristine**: *Suor Angelica* was an obvious choice because it is a very short yet, intense opera. Oshawa Opera wanted to participate in Culture Days and in order to do, we will be opening our dress rehearsal to the public, on September 25, 2015, with the help of the Pineridge Arts Council. Furthermore,  members of the general public will be able to attend the dress rehearsal at no-cost. Furthermore, the Oshawa Opera chorus will be working in collaboration with two other groups Members of Ensemble TrypTych Chamber Choir and Members of University of Toronto Scarborough Concert Choir.  

### 3. Why do you think this opera is still so popular?

**Natalya**: Let's see, an under-an-hour opera for a dozen sopranos, yes please! The format is just beyond fortunate to be produced over and over again.

To be serious, however, the music is brilliant: in the beginning it reminds of a movie track – nothing overbearing, just a background to the unravelling story. Familiar chants, beautiful and simple dialogues - very realistic, it's easy on an opera newbies and is appreciated for its cleverness by the mature experts.

**Kristine**: The music. I don't know anyone that can listen to it without breaking down in tears at the end. I was practicing the other day, and our 5.5 year old daughter, Zoé, sang through it all, with me and had her own interpretive dance going! She called it "That is the Angel Opera, right maman?". Puccini has a way with music to touch the very core of your soul. 

**Natalya**: Another reason for the opera to be popular is of course the famous "Senza mamma," Angelica's aria. Because there is a little bit of Callas in it every time it is performed. It is so lyrical, melodious, and one of the most heart breaking arias ever. I believe it could be strong enough to just read the lyrics as a monologue (or a dialogue since she is taking to her son) but Puccini takes it to the level beyond the language, and we can all relate to it in the audience.

And then the instrumental intermezzi, and the heavenly beautiful choir, and the little ghost... What's not to love? 

**Kristine**: The story is also relevant in 2015. Sometimes, when I read all the hate and shame that is thrown on women, to this day, in 2015, I know that we have work to do as a society. I was explaining the story to one of our sponsors last week and I got "Oh, we don't treat young pregnant women that way, anymore!" and I just smiled.... From a pure logistic point of view, this opera is popular because it gives several young singers the opportunity to learn a role. When a young singer is trying to emerge and build a resume, a role on a resume is better than just a chorus part. I am grateful that this opera can support young emerging singers. From soprano to contralto, every female voice has an opportunity to sing!

### 4. Natalya, what does it feel like to sing this role?

**Natalya**: It is a dream role, musically but especially dramatically. It is too close to heart.

Coming from a Slavic culture, being a girl, I had if not religious but conservative morality ingrained from an early age. It makes it easier to accept to a certain extent and to relate to the depth of Angelica's drama, her religiousness.

When I first opened the libretto 3-4 years ago, I cried - that's how terrified I was of the story, especially as a mother. My son just turned 7 back then and even reading about another mother's loss was petrifying. He is my miracle child, one of those courageous survivors, and the first picture that came into my mind reading through Suor Angelica was me praying in Mother Mary's cathedral in Sevastopol, Ukraine. I believe, any mother has a moment like this in her life, it is truly a genius Puccini and Forzano's work because we can relate to it immediately.

My main focus is to stay emotionally detached from the role, because singing brings me joy but it comes with a great responsibility. If a singer indulges in their self pity party, the audience won't be able to see all the elaborate detailed work that went into the creation of the character.

### 5. How does the opera adapt to an in-concert setting?

**Kristine**: Quite easily! [Kingsview United Church](http://kingsviewunitedchurch.com/) has a great layout and Oshawa Opera intends to use the space strategically to present an opera in concert with some minor staging in it. I am not about to let the cat out of the bag! Come on.....you know me better than that!

### 6. How does Angelica compare to some of Puccini's other female characters (Tosca, Cio-Cio San, Mimì)?

**Natalya**: In my head, which might not be a scholarly opinion, Puccini's heroines are extremely realistic and can be imagined as stages of development of one Woman. 

Angelica is without a man, her love is in the past, she is in a way stronger than all of them because she had to surrender, give up on everything that was her life, she couldn't even commit suicide because she was a mother. And lived on only to hope to see her child again. All of the other heroines have an "escape," whether it be passive like Mimi's or proactive like Tosca's or Cio Cio San's; Angelica chooses to face the reality. It is a different kind of strength, emotional, intellectual power of acceptance that we can see in Angelica.
 
### 7. *Suor Angelica* can be difficult to cast - what were you looking for in your singers?

**Kristine**: I am obsessed with this opera. This is my second time producing it, my friends are convinced I am obsessed with religious sisters....maybe, I am. I lived four years in a convent, while in University. One thing I learned from living with sisters, is that they are still women. *Suor Angelica* is a story about women that happen to be religious sisters. That is how I view this opera. From this perspective, it became quite easy to cast the roles. 

I have worked with Natalya Matyusheva in *Norma*, she was our Clotilde. I was quite impressed with her dedication and preparation for a small role like Clotilde. Then, I heard her recording of this role and I knew she had performed the role. Back to your question, I was looking for singers that would be willing to sing all of these characters like woman and bring their own unique interpretation in an ensemble work opera. Most of the singers do not get an aria in this work, it is about team work and communicating this very touching story. I am very grateful to work with Catherin Carew, Zia Principessa, for a second time on this production.

### 8. What can listeners with little or no opera experience get out of this production of *Suor Angelica*?

**Kristine**: The beauty of *Suor Angelica* is that it is short and to the point. The plot is simple, the music has beautiful singable melodies and we promise to have boxes of tissues in the audience, because, it is almost impossible to watch this opera without crying. Actually, maybe, I should make a contest and give out a prize if someone can refrain from crying!

>Oshawa Opera presents *Suor Angelica* at Kingsview United Church, Oshawa, on Sunday, September 27th at 3pm. For full details and tickets, follow the box office links below.
