+++
author = ["authors/sung-jin-hong.md"]
categories = "Op-ed"
date = "2017-09-25T12:39:00-04:00"
lastmod = "2017-09-26T21:25:00-04:00"
preamble = "This is a cross-post originally published on [One World Symphony's blog](http://oneworldsymphony.org/news13BreakingBlog.shtml#Sep2517)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506434195343/2017-09-26---Hallasan_Jeju-Island.jpg.jpg"
primary_image_credit = "Hallasan, Jeju Island."
publishDate = "2017-09-26T10:11:00-04:00"
related_articles = ["articles/fannibals-in-new-york-one-world-symphony-premieres-hannibal.md","articles/one-world-symphony-gets-defiant.md"]
related_companies = ["scene/companies/one-world-symphony.md"]
short_description = "If The Rite of Spring &quot;kissed the earth&quot; through a savagely primitive lens, that temple-food-inspired table celebrated our planet&#039;s primordial bounty from a more intimate perspective. The meal was prepared using centuries-old methods and crafted with ingredients that shared their origins with the mountains themselves. Traditional Korean cooking has nurtured a patient alchemy, where delicacies, seasoned with time to develop deep undercurrents of flavor, emerge transformed."
slug = "sung-jin-hong-seoul-searching"
title = "Sung Jin Hong: Seoul searching"
+++

**Seoul-Searching Through the Mountains of Korea and Celebrating 1,700 Years of its Culinary Heritage with Buddhist Chef Beop Song and Venerable Soo Am**

For nearly 1,700 years before terms like sustainability, authenticity, mindfulness, transparency, homegrown, and locally-sourced became common vernacular in the West, Korean Buddhists were cultivating an intimate relationship with food. For these awakened sowers, it's beyond "from farm to table" — it’s from nature to the mind, from the earth to the body, from the community to the soul.

Korean Buddhism was re-introduced to me when I returned to my homeland, nearly a quarter of
a century after my family and I immigrated to America. My wife Adrienne and I hiked the mountains of Korea during its harvest festival called [Chuseok](http://english.visitkorea.or.kr/enu/ATR/SI_EN_3_6.jsp?cid=811650) (추석). Buddhism, which has deeper cultural roots than Christianity, was suppressed for centuries by Confucianists. The Buddhists’ banishment into the mountains was transformed into a gift of grace. Not only did they meditate and build temples in their re-discovered sanctuary, but they established strong bonds with the people and returned to their provenance: nature.

That sincere relationship with their community was clearly evident during our exploration of two mountains: [Seoraksan](https://www.boboandchichi.com/2014/05/day-trip-seoraksan-national-park/) in [Gangwon Province](https://www.lonelyplanet.com/south-korea/gang-won-do) and [Hallasan](https://forkandfoot.com/hiking-mt-hallasan-jeju-island-south-korea/) on [Jeju Island](https://nature.new7wonders.com/wonders/jeju-island-korea-south/). A radiant mosaic of
autumn forests vaulted above us as we ascended towards cloud-shrouded altars. Along the way, we we were met by Buddhists who offered rice balls, sweet potatoes, and half-moon-shaped rice cakes called songpyeon (송편) without expecting anything in return. This gesture reminded me of how both my grandmother and mother ceaselessly contributed with a sense of 기쁨 (*gippeum* — purity and bliss).

After the momentous climb to the summit of [Daecheongbong](https://klimbingkoreanmountains.wordpress.com/2014/06/26/daecheongbong-peak-%EB%8C%80%EC%B2%AD%EB%B4%89/) (the highest peak in Seoraksan),
Adrienne and I experienced one of our most memorable meals together in the little village
nestled in the valley below. The entirely vegetarian fare was curated using ingredients directly sourced from Seoraksan's terrain. The chef de cuisine prepared a symphony of mountain
vegetables (산 나물 *san nammeul* and 취나물 *chwinamul*), an assortment of earthy mushrooms, braised lotus roots (연근조림 *yeongeun jorim*), fermented soybean paste stew (된장찌개 *deonjang jigae*), potato pancakes (감자전 *gamjajeon*), our first taste of a most delectable grilled root (더덕 *deodeok-gui*), and, of course, kimchi (김치).

If *The Rite of Spring* "kissed the earth" through a savagely primitive lens, that temple-food-inspired table celebrated our planet's primordial bounty from a more intimate perspective. The meal was prepared using centuries-old methods and crafted with ingredients that shared their origins with the mountains themselves. Traditional Korean cooking has nurtured a patient alchemy, where delicacies, seasoned with time to develop deep undercurrents of flavor, emerge transformed.

This pilgrimage to my homeland during Chuseok — a time for giving thanks, celebrating the harvest, and honoring our ancestors — overwhelmed me with memories of my grandfather. Before he passed away, he wanted us to explore together the traditions, wisdom, and resilience of our people and our land — weathered as they were through a cultural genocide resulting from [Japanese imperialism](http://dresnerworld.edublogs.org/resources/handouts/korea-1872-1953/); World War II, the Western division of Korea with the arbitrary institution of the 38th Parallel, occupation by the Soviet Union and United States, the first phase of the Cold War and the deliberately erased slaughter of at least three million Korean civilians during the [full-scale bloodshed of the Korean War](https://theintercept.com/2017/05/03/why-do-north-koreans-hate-us-one-reason-they-remember-the-korean-war/) (euphemistically labeled a "conflict"), mass industrialization, and the fierce acceleration of the rhythm of life. My grandfather dreamed of journeying with me into the sacred mountains that not only shaped my motherland's landscape and heritage, but forged her identity.

He longed for us to be in the moment: past, present, future… time flowing eternally…

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506435017547/2017-09-25---SungJinHong_JVinsek3_SQ.jpg.jpg)
<figcaption>Sung Jin Hong. Photo: Jaka Vinsek.</figcaption>
</figure>
***
### Interview with Beop Song and Venerable Soo Am

*When Adrienne and I were invited to Opening Night of the 2017 [Korean Templestay and Temple Food Cultural Week](http://koreantemplefood.com/) in New York City, I couldn’t help but feel grateful for my pilgrimage to my homeland. Reflecting on our temple food-inspired experience made me wonder if we can build a more balanced and compassionate world by embracing some of the Korean Buddhist social values:*

*A spirit of equality: Regardless of one’s social standing, all participants sit together and share meals without class distinction. All are equal.*

*A spirit of community: All are nourished from food grown and harvested from the same garden, prepared in the same pot, in the same place, and at the same time — sowing the seeds of solidarity.*

*I offer my sincere gratitude to [Beop Song](http://koreantemplefood.com/korean-templestay-temple-food-cultural-week/beop-song-buddhist-nun-chef/), Korean Buddhist nun, chef, and author; [Venerable Soo Am](http://koreantemplefood.com/korean-templestay-temple-food-cultural-week/greetings/), Cultural Corps of Korean Buddhism director; and the Jogye Order of Korean Buddhism for hosting this generous festival. Venerable Soo Am and Beop Song graciously consented to sit for an interview:*

**SJH: Can you please tell us about Korean Templestay and Temple Food and how they actively serve the local and global communities? What is the essence of Korean Templestay and Temple Food?**

**Ven. Soo Am**: Templestay is a cultural experience centered around the heritage of Korean Buddhism and its traditional temples. However, these activities are not limited to the space of just the temple grounds. Templestay is conducted in connection with the culture, environment, and attractions of the community near where the temple is situated. In addition, the temple itself assumes the characteristics of that local community. Temple food is prepared from the native seasonal ingredients. Temple stay and temple food are the encounters of the past and the present co-existing with the community.
 
The essence of Templestay and temple food is to share in the value of spiritual impressions and community. The experience of traditional Buddhist culture in Korea embraces the diversity of country, race, gender, or beliefs. Through the experience of traditional Korean Buddhist culture, we can enrich our understanding of different cultures and exchange their ideas. Spiritual reflection through Buddhist culture experience can deepen and enrich one’s own mind and perspective.
 
The traditional Buddhist culture of Korea values the relationships between you and me, the world and me, and between all beings.
 
**SJH: What is enlightenment in Korean Buddhism?**
 
**Ven. Soo Am**: Enlightenment of the Buddha can be called "middle way (中道) and arising from causation (緣起)." Freeing the pair of polar opposites, it is the wisdom of seeing reality as it truly is that enables us to look at all phenomena and objects clearly, and the understanding that all beings in the world are interconnected to each other. Enlightenment is not merely a comprehension. The enlightenment must be awakened whether or not one is walking, staying, sitting, lying down, talking, silencing the mind, moving, or stopping. The enlightenment (awakening of consciousness) is both understanding and practice.
 
**SJH: Food that one has planted, harvested, and prepared with love, compassion, and mindfulness of our ecological footprint is believed to purify and nourish the mind, body, and soul. This ideal appears to be only a small part of one's journey in Korean Buddhism. Can temple food help one discover or achieve enlightenment?**
 
**Beop Song**: It is the spirit of temple food that encourages one to deeply think, appreciate, and meditate on the food one is eating, the whole process from the origins and existence of food. It means to free the body and the mind in order to concentrate on spiritual practice and realize enlightenment without the ego. The food itself cannot lead to enlightenment. The process of eating is a vital practice starting with how to eat which food. Enlightenment can only come from within, through the process of achieving certain state of body, mind, and awareness.

**SJH:  Can you please tell us a little about Korean Buddhism (Seon) and how it is unique? How does it continue to be relevant today?**

**Ven Soo Am**: Korean Buddhism has continued the tradition of Zen Buddhism. The Zen (Seon) of Korean Buddhism is called Ganwha Seon (看話禪), a way of practicing the quest for Hwadu (話頭), or key phrase or story. It is also referred to as Cham Seon (參禪). Traditionally, there are about 1,700 different Hwadu, so it is called "1700 Gong-an" (if the gong-an is the context of the dialogue, hwadu is a key word or a phrase of the dialogue). "What’'s this?" "Pine tree in front of the yard," and  "There is no Buddha in a dog" are some of the well known Hwadu.
 
The distinct feature of Korean Buddhism is "Tong Buddhism" (The intermediate or holistic teaching). Although Tong Buddhism has continued the tradition of Seon Buddhism, it is based on the idea of Hoitong ([會通](http://dic.tvbuddha.org/s1/view.htm?vtype=search&search_key=%ED%9A%8C%ED%86%B5&page=1&num=4767&PHPSESSID=6184b972ae23b0bfe75d7d800e376dfb); Conciliation or balance of diverse opinions). In the idea of Hoitong, one can realize enlightenment by accepting and respecting the following as the way of practice: silent reading of a sutra, Buddha chanting, the power of the earnest chanting of mantra, the belief in the Pure Land (淨土[信仰](http://dic.tvbuddha.org/s1/view.htm?vtype=search&search_key=%EC%8B%A0%EC%95%99&page=1&num=451&PHPSESSID=6184b972ae23b0bfe75d7d800e376dfb)), and so on. By these traditions, various Buddhist sects and philosophies of today are in harmony, and they are the basis for practicing to realize enlightenment for each one's potential. 

**SJH: Who or what was your inspiration to become a Buddhist and a chef? Was there a specific individual, event, or moment? Which came first, Buddhist or chef?**

**Beop Song**: I received my first opportunity to cook as a nun was when I was an apprentice. I watched and assisted in preparing the ingredients. In this way, I was able to see the techniques Buddhist nuns used to prepare food. Gradually, I learned the food culture of the temple naturally by closely observing the process. My mentor taught me the importance of the seasonal foods she made for the head nuns and how to savor them. The reason that I wanted to prepare food as a nun was to experience the sharing, warmth, gratitude, and caring that was fostered by my mentoring nun. 
 
Cooking is just a part of the spiritual practice. Buddhism comes first.

**SJH: If you had the opportunity to host a dinner summit for peace and solidarity with the respective leaders of Russia, China, the United States, Japan, and the Koreas, what would be on the menu? And why?**

**Beop Song**:

<ul class="nospace">

<li> Red bean sticky rice and shiitake mushroom seaweed (미역) soup — These two are considered as special food because monks have these on the day of shaving twice a month. These food circulate and supplement the "chi" ("gi").
<li> Grilled tofu — Nutritious food for nuns
<li> Grilled Seaweed (김) — It complements sticky rice.
<li> Stir-fried vegetables with sweet potato noodles (잡채) — This is the food using all seasonal vegetables made for special guests in temple all vegetables.
<li> Kimchi — (Temple food kimchi is rooted from the original, dated around 7th century A.D., where it's lighter in color and less spicy – SJH)
</ul>

**SJH: Through the official website of Jogye Order of Korean Buddhism, I read about the Manhae Grand Prize commemorating the life and achievements of Buddhist, activist, and resistance poet "Manhae" Han Yong-un (한용운, 1879–1944). Han fought for the Re-Independence of Korea during Imperial Japan. In 2014, The Manhae Peace Prize was granted to the "House of Sharing," a home for the surviving few of the over 200,000 women who had been systematically victimized as sexual slaves during the Japanese Imperialism of Korea and WWII (euphemistically called "comfort women"). These 할머니s (*halmonis*, grandmothers) have embraced the Jewish Holocaust mantra of "Never forget!" by continuing to fight as human rights activists in the "world's longest-running protest" that has been held every Wednesday for the last 25 years. If you had the opportunity to prepare a meal for the courageous *halmonis*, what would you serve to nourish and empower their bodies, minds, and souls? And why?**
 
**Beop Song**:

<ul class="nospace">
<li> White rice — This is the food that could only be eaten on special occasions during the Japanese imperialism, when many were starving.
<li> Miso soup with tofu and zucchini — This is the food that reminds you of home without getting tired of eating it all year round.
<li> Grilled root (더덕구이) — The aroma of root brings you nostalgia and supplements the "chi" ("gi")
<li> Steamed Potatoes — This food is empathetic with sorrow from the hunger period 
<li> Winter-cabbage water kimchi — It goes well with potatoes and the cleansing kimchi water prevents upset stomach and has a refreshing flavor.
 <li> Azalea rice pancake (진달래 화전) and radish water kimchi (동치미)  — I'd like to respect and honor our *halmonis* (grandmothers) by preparing the spring azalea pancake. I’d like to add the refreshing radish water kimchi to foster the truth and resolution of our *halmonis*.

</ul>

**SJH: What message would you like to share with all the guests who will be celebrating 1,700 years of Korea's culinary heritage?**
 
**Ven. Soo Am**: The tradition of Temple food in Korea is very old and has experienced numerous practices for centuries. All of us together here and now, eating this food, will continue the tradition for another thousand years. Looking at the food before us, I would like to express gratitude and prayers of thanksgiving, peace, and happiness to all beings in the world.
***
*The responses from Ven. Soo Am and Beop Song were originally in Korean. Translation by chemist Jae Hyoun Lee, Ph.D and Sung Jin Hong.*
  
*The fourth annual Korean Templestay and Temple Food Cultural Week will be held from September 26–28, 2017 in New York City. In honor of the [2018 Pyeongchang Winter Olympics](https://www.pyeongchang2018.com/en/index), the festival will offer a wide range of events, including tastings, cooking demonstrations and instructions, exhibitions, lectures, and guided workshops on woodblock printing, lotus lanterns, arts, and crafts via advanced registration. For more information visit [koreantemplefood.com](http://koreantemplefood.com/).*

