+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-02-02T13:21:00+00:00"
lastmod = "2017-02-27T13:15:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1486046330440/2017-02-02---No-Summer.jpg.jpg"
publishDate = "2017-02-27T12:59:00+00:00"
related_companies = ["scene/companies/cosi-centre-for-opera-studies-in-italy.md"]
short_description = "Pay-to-sing programs like the Centre for Opera Studies in Italy (COSI) have a lot to offer, and there are certainly less wise ways to spend hard-earned cash. But how does a young singer know when attending these kinds of summer programs starts to do them professional harm?"
slug = "summer-programs-when-its-time-to-stop-attending-them"
title = "Summer programs, &amp; when it&#039;s time to stop attending them"
+++

Ah, summer opera programs, full of youth and opportunity. Young singers audition for these programs to continue their technical work between school semesters, and perhaps more importantly, to gain experience singing in operas. Most summer programs have some combination of private lessons and coachings, group-format masterclasses and advice sessions, and at least one "big project" that's often a full-length operatic production. Singers with success on the audition circuit may even have their pick of a handful of programs to attend, and many of those singers make their decision based on the roles they're being offered. Who wouldn't want to sing a Musetta instead of a Barbarina?

With some notable exceptions, these summer programs cost money to attend. In the industry, these are known bluntly as "pay-to-sing" programs; those with a bit of pessimism in their blood may consider it a way to buy stage experience. In reality, pay-to-sings fall under the category of professional development, often a wise investment to make for a prospective professional singer.

Pay-to-sing programs like the [Centre for Opera Studies in Italy (COSI)](http://www.co-si.com/) have a lot to offer, and there are certainly less wise ways to spend hard-earned cash. But how does a young singer know when attending these kinds of summer programs starts to do them professional harm?

The stage experience gained at summer programs - even pay-to-sings - are by no means useless or superfluous. Singers keep those roles on their resumes for several seasons, because it helps audition panels figure out what an artist is currently singing (and by extension, what they could be hired to sing in a professional environment). Programs like COSI gather together impressive rosters of voice teachers, conductors, and directors, and they become a hub within which young artists can start to make vital professional contacts. In case we're not being crystal clear: summer programs are important, and valuable.

Audition panels are also putting the "what" in context with the "where". Singing Violetta at COSI is different than singing the same role at the Merola Opera Program; the latter isn't "better" than the former, but people looking to hire singers are aware of the level of development that attend different programs. It's another topic entirely to unpack why some summer programs require a tuition payment from the participants, and why others are paid for by donors and government funds. The important thing is knowing the kind of message that a singer sends into the professional world by showing a résumé full of roles sung at pay-to-sing programs.

Singers, to put it simply, there comes a point when you need to stop paying to sing. Or at least, to stop putting those roles on your résumé. It's not because the programs aren't beneficial or good for you, or that the role you sang at COSI doesn't count for anything. It's because you may start give audition panels the impression than you "can't" get a professional gig.

It may seem like we're likening the pay-to-sing veteran to that 22 year-old guy who still hangs out with high school kids. We're aware that the jump from apprenticeship to professional is a wide and precarious one. It can be particularly difficult for singers whose voices are destined to become a dramatic soprano or a basso profundo, or even a Verdi baritone. These singers often have to be more patient with their careers, waiting on their instrument - their biology, really - to catch up with their drive and talent. While they play the waiting game between school and a real-deal career, pay-to-sing programs are often their only opportunities to sing a major role in an opera, to flex their chops on a larger scale than one-line roles in *Madama Butterfly*.

Though it may look like a closed door for singers who are hustling their way into the professional opera world, saying no to certain summer programs is truly an opportunity. It's a push, a motivator to make your next goal something a bit more ambitious. In many cases, getting a teeny tiny role in a professional production does you more good than a leading role at a summer program. It may not be as fun, or even as challenging, but it's a strategic move for your career.

Being in charge of your career means being objective about your position within the industry. There are lots of reasons to pursue summer programs, and even to pay for them; it's a wise investment to place yourself among excellent training, or to pay tuition for the chance to build stamina with a major role. You know as well as us that pay-to-sing programs are *not* an opportunity to "buy" a role; your tuition money comes after a successful audition, which in turn comes after a lot of hard work. 

Singers, let no one tell you what roles to take, or even how much money to shell out for the chance to sing them. But be brutal with yourself when it comes to your résumé. Audition panels know how hard it is to get professional work as a young artist, which is why it's a strategic move to put that small role with that really small company on your CV before you put down that you sang Rodolfo at a summer training program.

So, back to our question: how does a young singer know when summer programs no longer do them professional good? That's the beauty/terror of being an entrepreneur: it's up to you. Singers, don't underestimate how people perceive you within the opera industry, even as a newbie. And don't stop pursuing good-quality training; if a summer in Sulmona will do you good, have at it. It turns out that summer programs have another lesson to offer, and that's knowing how much to tell the industry about your own development.
