+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2018-10-02T13:27:00-04:00"
lastmod = "2018-10-02T13:38:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538501765644/sqDSC_0083.jpg.jpg"
primary_image_credit = "Palm Beach Opera's Summer Opera Nights, September 2018. Photo courtesy of Palm Beach Opera."
publishDate = "2018-10-02T13:38:00-04:00"
related_companies = ["scene/companies/palm-beach-opera.md"]
short_description = "With PBO&#039;s Young Artists away for the summer, the September 28 event starred South Florida mainstays: bass-baritone Neil Nelson – a familiar face from past PBO productions – and soprano Robyn Marie Lamp. The duo were joined by PBO rehearsal pianist and coach Cassie Makeeff, who heroically made the most of an electric keyboard."
slug = "summer-opera-nights-in-palm-beach"
title = "Summer Opera Nights in Palm Beach"
+++

Floridians often jokingly attest that the weather in their home state offers only two seasons: summer, and hurricane. It was fitting, then, that [Palm Beach Opera](/scene/companies/palm-beach-opera/) fans and newcomers alike gathered on a hot, humid evening in late September to enjoy the final installment of the company's newest community outreach series, [Summer Opera Nights](https://pbopera.org/event/operanights/).

Starting in July, the three-concert series took place at Elizabeth Ave Station, a trendy local arts marketplace-cum-events venue situated in West Palm Beach's recently gentrified Warehouse District. Guests could peruse a hipster's paradise of vintage vinyl records and handmade jewelry while sipping a free drink (included with admission) and listening to local opera soloists take on classic arias – not to mention a show tune or two.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538501753141/DSC_0048_c.jpg.jpg)
<figcaption>Palm Beach Opera's Summer Opera Nights, September 2018. Photo courtesy of Palm Beach Opera.</figcaption>
</figure>

With PBO's Young Artists away for the summer, the September 28 event starred South Florida mainstays: bass-baritone Neil Nelson – a familiar face from past PBO productions – and soprano Robyn Marie Lamp. The duo were joined by PBO rehearsal pianist and coach Cassie Makeeff, who heroically made the most of an electric keyboard.

Repertoire ran the gamut from "Io son l'umile ancella" and the Toreador Song (of course) to selections from *Porgy and Bess*, *Showboat*, and *Carousel*. The performers won over the audience with strongly sung interpretations, but especially with their chilled-out charm. "It's so informal," Lamp told me after the show. "We have a lot of fun."

Interspersed between fifteen-minute musical sets were rounds of opera-themed trivia, led with crowd-pleasing enthusiasm by PBO's Education & Community Engagement Associate, Abbey Ward. Using a mobile app, the crowd keyed in their answers to questions ranging from tidbits about PBO's upcoming season to lighthearted musical minutiae. Did you know that Rossini once referred to truffles as "the Mozart of mushrooms"?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538501742687/GordonIMG_20180928_195910.jpg.jpg)
<figcaption>Palm Beach Opera's Summer Opera Nights, September 2018. Photo courtesy of Carly Gordon.</figcaption>
</figure>

Palm Beach Opera is hardly the first opera company to attempt dressed-down Carmen in a "non-traditional" venue as a means of wooing new audiences. But their Summer Opera Nights proved a fun, festive, and effective space where "accessibility" – an often flimsy classical music buzzword – meant more than just show tunes and free drinks. At $10 for admission ($5 for students), financial barriers were lowered, resulting in an impressive turnout of a wide-ranging age demographic – tough to achieve in the South Florida community, where snowbirds and retirees double down on the so-called "aging audience" the classical music industry purports to face. Even more impressive: while guests came and went throughout the night, a majority stuck around for the long haul to catch every single set.

Notably, PBO's on-site marketing push didn't hound attendees with season subscription sales, but rather nudged the crowd to consider purchasing single tickets – an audience retention tactic modeled with quantifiable success by the California Symphony. It was clear that the goal of the evening wasn't to meet a sales quota, nor to convert a roomful of opera first-timers into opera die-hards. Instead, the Summer Opera Nights could be enjoyed at face value – a laid-back evening of music and camaraderie on a sweltering September night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1538501730192/GordonIMG_20180928_205256.jpg.jpg)
<figcaption>Palm Beach Opera's Summer Opera Nights, September 2018. Photo courtesy of Carly Gordon.</figcaption>
</figure>

During one of the trivia rounds, Ward asked the crowd, "How many people do Palm Beach Opera's community programs reach?" The answer: 17,000. In addition to the Summer Opera Nights, PBO teaching artists guide schoolchildren to conceive and compose their own short operas, and their Apprentice Artists present a [series of concerts](https://pbopera.org/education/anima/) for audiences experiencing homelessness. As the company gears up for the 2018-19 season, their efforts to serve the local community through education and outreach (and the occasional free drink) deserve a round of applause.

>For full details about Palm Beach Opera's line-up, [visit their website.](https://pbopera.org/)
