+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-09T16:00:00-06:00"
lastmod = "2017-06-12T22:16:00-06:00"
preamble = "This summer, [Bampton Classical Opera](http://www.bamptonopera.org/events.htm) presents Salieri's *La scuola de' gelosi* (*The School of Jealousy*), an opera filled with the kind of history that opera fans love. The opera's 1783 Vienna performance featured singers Francesco Benucci and Nancy Storace, who would later become the first Figaro and Susanna in Mozart's *Le nozze di Figaro*. With similar titles and familiar themes, Salieri's piece was also a strong inspiration for Mozart and Da Ponte's *Così fan tutte*, or *La scuola degli amanti* (*The School of Lovers*).\n\nDirected by Jeremy Gray and conducted by Anthony Kraus, [*The School of Jealousy*](http://www.bamptonopera.org/events.htm) runs **July 21-22** at Bampton's Deanery Garden, Oxforshire, **August 28** at The Orangery Theatre, Westonbirt School, Glos, and **September 12** at St John's Smith Square, London. \n\nGray offers some fascinating insight on Salieri's opera, its connection to Mozart's work, and what audiences can expect from Bampton's touring production."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497046188068/2017-06-09---Bampton-Classical-Opera-The-School-of-Jealousy-image.jpg.jpg"
publishDate = "2017-06-12T21:27:00-06:00"
related_articles = ["articles/cosi-fan-tutte-misogynist-unreasonable.md"]
short_description = "&quot;It&#039;s often blithely assumed that Mozart&#039;s great works sprang solely from his personal genius, fired by his collaboration with the quirky librettist Lorenzo da Ponte. But like many great artists, Mozart was something of a thieving magpie, and Da Ponte was more used to adapting and rewriting libretti than creating new works of his own.&quot;"
slug = "summer-of-love-bampton-opera-presents-the-school-of-jealousy"
title = "Summer of love: Bampton Opera presents The School of Jealousy"
+++

## What should we know about an obscure opera like Salieri's *La scuola de' gelosi*?

*The School of Jealousy* is one of these intriguing footnote operas – a piece that is often mentioned in operatic literature and programme notes, but which very few people know about.  It was one of the greatest successes of its time, quickly spreading across Europe, from London to St Petersburg, after its first performances in Venice in December 1778.  Most importantly it was selected to inaugurate the new Italian opera troupe established by the Emperor Joseph II in Vienna in 1783, performances which introduced to Mozart a team of remarkable foreign singers such as the Anglo-Italian soprano Nancy Storace and the Irish tenor Michael Kelly, who went on to create the roles of Susanna and Don Curzio/Don Basilio in *Le nozze di Figaro*.  It's designated as a *dramma giocoso* – a comic drama – a description shared with *Don Giovanni* and *Così fan tutte*.  

And suddenly *La scuola* is no longer so obscure – an excellent new recording has been issued on the Deutsche Harmonia Mundi label, recorded from live concert performances given in Leverkusen, Germany in December 2015 by L'arte del mondo, conducted by Werner Ehrhardt.  Late in 2016 a staged production was organized by Fondazione Culturale Antonio Salieri di Legnano, and toured to several Italian theatres including Florence; currently there is a production in Vienna in the Kammeropera mounted by Theater an der Wien, and in the autumn there will be another production by Opera Joven in Uruguay.  It's hard to explain the coincidence of all this interest but it certainly suggests a vote of confidence in the merits of the piece.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497046348133/2017-06-09---Nancy-Storace-image.jpg.jpg)
<figcaption>Nancy Storace, soprano and creator of the role of Susanna in *Le nozze di Figaro*.</figcaption>
</figure>

## How do you think the opera inspires Mozart's *Così fan tutte*?

It's often blithely assumed that Mozart's great works sprang solely from his personal genius, fired by his collaboration with the quirky librettist Lorenzo da Ponte.  But like many great artists, Mozart was something of a thieving magpie, and Da Ponte was more used to adapting and rewriting libretti than creating new works of his own.  

When *La scuola de' gelosi* arrived in Vienna the libretto by Caterino Mazzolà was partly rewritten by Da Ponte, and Salieri wrote new music to match.  Several years later, when Da Ponte wrote the libretto for *Così fan tutte* he subtitled it *La scuola degli amanti* (*The School of Lovers*), obviously hoping to match the box-office success of the earlier piece, and he wrote it first for Salieri, who started composing music for it.  It was only passed to Mozart when Salieri gave up on it, seemingly unimpressed with aspects of the libretto.  

There are some relationships with *Così* in the romantic interplay and swapping of two couples, and their cynical manipulation by the Tenente (Lieutenant) who is a obvious equivalent to Don Alfonso.  But the links between *La scuola* and *Figaro* are also as clear:  the first appearance of the Countess at the opening of the second scene, with a moving aria of resignation, "Ah, non è ver che in sono", and in the Act 2 Finale the confusion and eventual resolution, with plenty of hiding and disguise, takes place in a wooded grove akin to the *Figaro* garden.

## What does *La scuola de' gelosi* say about romantic relationships and human nature?

That jealousy is as old as love!  The "school" is referenced early in Act 2 when the Count explains how, in his art collection, pastoral and mythological paintings, such as Zeus and Europa, Venus and Mars, illustrate his own sardonic and selfish views about love and attraction.  There is also the curious Act 1 finale – somewhat challenging for the 21st century – when the Count takes his latest would-be mistress Ernestina (the wife of the pathologically jealous merchant, Blasio) to laugh at the inmates in the asylum, whose jealousy has driven them mad.  The Count is bored with his wife because she is too good and loyal: as he announces,  "I plan to target the wives of jealous men: when a husband is suspicious, then the wife, in frustration, is inclined to take a lover as compensation!"  

The final reconciliation of the couples, as in *Così*, hardly suggests that they will live happily ever after.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1497046457194/2017-06-09---Bampton-Classical-Opera---Deanery-Garden-Bampton-2.jpg.jpg)
<figcaption>The Deanery Garden, Bampton, Oxfordshire.</figcaption>
</figure>

## What can audiences expect from these touring performances?

Bampton Classical Opera has become well-known over 25 years for its lively interpretations of forgotten eighteenth-century opera, and this will be our third by Salieri.  We always perform in new English translations as we want these operas, especially comedies, to speak directly to our audiences.  The scale of our productions is small, but audiences value their intimacy and the sense of immediate contact with what happens on stage.  

We perform in three very different venues: an idyllic garden setting at the Deanery in Bampton, Oxfordshire (and, yes, that's the church adjacent which is featured in Downton Abbey!) and also in the opulent Victorian mansion at Westonbirt in Gloucestershire.  In London we use the appropriately 18th-century setting of St John's, Smith Square with its glorious acoustic.  We always work with outstanding casts of young professional singers, as adept in acting as in singing: many who have graced our stage in the past have gone on to perform at the major companies in the UK and abroad.  

We show respect, I hope, for the spirit of the original work – its libretto and music – but we also aim to entertain and intrigue through lively production values.  It's a privilege to bring new life to forgotten music and the whole team and cast are determined to enjoy the process!

>*The School of Jealousy* runs July through September. For details and ticket information, [click here.](http://www.bamptonopera.org/events.htm)
