+++
author = ["authors/john-hohmann.md"]
categories = "Op-ed"
date = "2018-10-25T16:10:00-04:00"
lastmod = "2018-10-25T22:34:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540521244866/sqMacbeth_0419-s.jpg.jpg"
primary_image_credit = "Anna Netrebko as Lady Macbeth in Verdi's Macbeth, Metropolitan Opera, 2014. Photo: Marty Sohl/Metropolitan Opera."
publishDate = "2018-10-25T22:34:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/anna-netrebko.md","scene/people/lawrence-brownlee.md","scene/people/christopher-maltman.md"]
short_description = "With no lines or a prescribed opening time the Summer HD Festival has been a welcoming presence since its inception. Entering off Broadway, people first encounter a table with volunteers from the Metropolitan Opera Guild, providing information about the Guild&#039;s programs and benefits of membership as well as complementary issues of its publication, Opera News."
slug = "summer-nights-at-the-opera-an-observation"
title = "Summer Nights at the Opera: an observation"
+++

Over its ten-year history the Metropolitan Opera's Summer HD Festival opened with films that in one way or another, evoked the world of opera - or at least Lincoln Center, whose plaza it annually transforms into a 3000-seat outdoor opera house. This transformation takes place in late August and runs through the Labor Day weekend when an impressively sharp projection and sound system erected near the plaza fountain and a giant screen mounted atop the Grand Tier level of opera house take over.

The romantic comedy *Moonstruck*, showing off the cultural compound - not to mention Cher - at their glamorous best, and *West Side Story*, parts of which were filmed where it now stands, have been screened over the years along with Ingmar Bergman's charming treatment of Mozart's *The Magic Flute* and Amadeus, Miloš Forman's quasi bio of the composer.

So it seemed fitting when it was announced that the 2018 festival would open with *A Night At The Opera*, the sublime 1935 Marx Brothers comedy. Opera, in this relentlessly funny and ever fresh film, is viewed as little more than a bauble dangled before a wealthy matron whose social aspirations are as high as her checkbook is deep. With dazzling agility and dialogue that had to have been born in spontaneity, Groucho and his brothers not only settle the score as it were, but also launch the careers of two neglected young singers. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540497924851/NightattheOpera.jpg.jpg)
<figcaption>Kitty Carlisle and Groucho Marx in *A Night at the Opera*, 1935. Photo via IMDB.com.</figcaption>
</figure>

One of those singers was played by Kitty Carlisle, a young actress who went on to have a charmed career spanning several decades of film, theater, opera, television, and cabaret. But Carlisle was more than an enduring and multi-faceted entertainer. As Kitty Carlisle-Hart, widow of legendary playwright, Moss Hart, she chaired the New York State Council on the Arts and became an eloquent and effective advocate for governmental support of the arts in New York and throughout the country. So what a pleasure it was to find that this celebrated New Yorker was represented in the opening of the 10th HD Festival. Most certainly she would have applauded MET General Manager Peter Gelb's stride to make opera accessible to all. 

While the first couple of festivals were a tad top-loaded with Puccini, they also featured Britten's *Peter Grimes*, the Mark Morris production of Gluck's *Orfeo Ed Euridice*, and John Adam's *Doctor Atomic*. The 2011 Festival would include Adam's masterful *Nixon in China*, the seldom performed *Iphigénie en Tauride* and a powerful rendition of *Carmen* conducted by Yannick Nézet-Séguin, who was named the MET's Music Director earlier this year.

This year's roster isn't so much about striking balances, though it does, as it is about vast roster of available productions and the tremendous allure of HD technology. The trade-off is that we are not hearing live voices. The MET's "The Voice Must Be Heard" video spots that precede each opera do not fall on deaf ears.

*Norma*, *L'elisir d'amore*, and *Il barbiere di Siviglia* - three bel canto classics - warm what might be perceived as the chill of *Lulu* and *Elektra* and even the new production of *Der Rosenkavalier*. Classic tragedy, the kind that is widely regarded as the exclusive purview of opera, was represented by *Roméo et Juliette*, *Un ballo in maschera*, and *Madama Butterfly*. And then there was *Rusalka*, a production so visually spectacular that it literally floats on HD technology.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540498010799/ROM_0686a.jpg.jpg)
<figcaption>Ailyn Pérez as Juliette in Gounod's *Roméo et Juliette*, Metropolitan Opera, 2017. Photo by Ken Howard/Metropolitan Opera.</figcaption>
</figure>

While 2018, the heat wave not withstanding, was greeted with relatively benign weather, the outdoor setting has often mingled with the operas over the years. During the broadcast of Richard Strauss' *Salome* in 2012, a full moon, lamented by Salome's stepfather, King Herod as a threatening omen, gradually appeared, not on the screen but above it - the reflection in the MET's windows of an actual moon rising in the east over Manhattan. It was a visual coincidence, one the audience seemed to savor, that could only have happened at that moment on the plaza at Lincoln Center. 

During the same season, Philip Glass' *Satyagraha* wrought a wholly unexpected aural experience for those who choose to hang out by the reflection pool adjacent to the plaza. This writer, having enjoyed both its live and theatrical HD performances, did not plan on attending the outdoor broadcast. Relenting about two hours into its run, I approached Lincoln Center from Amsterdam Avenue, entering by the pool that is flanked by the theater complex, the opera house and David Geffen Hall. Glass' pulsating syncopations cascaded off the walls, coming from all directions as if the opera was a site-specific sound installation. Being immersed not only in the sound but also in the startling moment I remained by the pool, reveling in the last 40 minutes of this monumental work and feeling quite viscerally a part of it.

The outdoors has not always intervened with full moons and acoustical richness. Sometimes its gifts seemed more like challenges. Twice they involved Anna Netrebko, a singer for whom most audiences would gladly endure whatever twists and turns that nature had to offer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540498019684/Macbeth_0966-s.jpg.jpg)
<figcaption>Anna Netrebko as Lady Macbeth and Željko Lučić in the title role of Verdi's *Macbeth*, Metropolitan Opera, 2014. Photo: Marty Sohl/Metropolitan Opera.</figcaption>
</figure>

In 2015 the broadcast of Verdi's *Macbeth* featuring Željko Lučić and Netrebko as the power-crazed couple wasn't rained out, but there was enough precipitation to cause a flushing of the audience. Living within walking distance of Lincoln Center, I did the not-unheard-of thing and brought my dog that evening. He quickly settled beneath my seat on an outer aisle. But when the rain came and the audience began running for cover, it seemed prudent to get out of the fray so we settled atop one of the concrete blocks flanking the opera house. With umbrella overhead we watched from a tolerable angle as the Macbeths met their fate. In retrospect, the turbulent weather was, indeed an atmospheric gift.

2017's *Eugene Onegin*, again featuring Netrebko, wasn't so fortunate. Only those equipped for a driving rainstorm, the kind in which umbrellas and summer rainwear are pointless, remained after the first act. With a cold and damp tinge of guilt I descended into the subway for the journey home to discover that my DVR had captured the PBS broadcast where the second act awaited.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540498028119/BARB14_0480a.jpg.jpg)
<figcaption>Christopher Maltman as Figaro and Lawrence Brownlee as Count Almaviva in Rossini's *Il Barbiere di Siviglia*, Metropolitan Opera, 2014. Photo: Ken Howard/Metropolitan Opera.</figcaption>
</figure>

With no lines or a prescribed opening time the Summer HD Festival has been a welcoming presence since its inception. Entering off Broadway, people first encounter a table with volunteers from the Metropolitan Opera Guild, providing information about the Guild's programs and benefits of membership as well as complementary issues of its publication, *Opera News*. For those new to opera, a cursory glace at this lively magazine evokes the richness of the genre and the vast reach of its community.

MET volunteers staff a sales table offering recordings and DVDs of the evening's opera, while others roam the audience selling MET rain ponchos and stadium cushions. A comprehensive program book, including HD Festival cast lists and story summaries, is distributed throughout the plaza. In short, the atmosphere is friendly and the audience, ranging from opera lovers to curious passers-by and picnickers, seems to find their like-minded places. 

The only aspect of this blissfully unregulated environment that has the potential to cause a stir is the practice of excessive seat saving. Seat savers arrive early, often with a bag of clothing, usually old sport coats, to claim, by this observer's count, up to ten seats. Others are less obvious, utilizing the program books or, most brazenly, those free issues of *Opera News*.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540498034984/RUS_7977a.jpg.jpg)
<figcaption>Jamie Barton as Ježibaba in Dvořák's *Rusalka*, Metropolitan Opera, 2017. Photo by Ken Howard/ Metropolitan Opera.</figcaption>
</figure>

The MET has no policy on seat saving, so some audience members have instituted policies of their own. I was encouraged when one evening a few sport coats were removed after a brief exchange for which I was out of earshot and hoped that similar exchanges were taking place throughout the plaza.

That being said, a friend and I were positioned on the other side of the issue during last year's Act One broadcast of *Tristan und Isolde*. Prior to the broadcast we chatted with three interesting people from Holland who hadn't realized Acts Two and Three were being broadcast the next night. They had been in Carbondale, Illinois one of the hot spots for viewing the lunar eclipse, had a post-eclipse event to attend the next evening and worried that arriving late to Lincoln Center they would have to sit in the back where they had discovered people were less attentive. So we offered to save them seats. The next night we sat with the empty seats between us and in a few minutes a courteous but assertive woman inquired as to our use of the three seats. We explained the situation, told her we appreciated her vigilance and she seemed satisfied but watchful. Happily the Holland trio arrived on time and our evening turned out to be a smoother ride than that of *Tristan and Isolde*.

This year, amidst that stifling heat wave, opera and tennis buffs had a choice to make. Yes, the Summer HD Festival has the audacity to compete with the U.S. Open. Should they watch Venus and Serena Williams do battle in Flushing, or follow the battle of wits between Figaro and Count Almaviva at Lincoln Center? Such are the hardships of New York in late summer. Those who went with Figaro would be forgiven for checking their devices in order to learn the results in Flushing as Rossini's opera effervesced, a example of the congenial attitude of the Summer HD Festival. 

And by the way, the operas are presented without intermission.
