+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-05-06T23:02:00-04:00"
lastmod = "2017-05-07T13:42:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494125968154/2017-05-04---Opera-Pub-Square.jpg.jpg"
primary_image_credit = "Joel Ivany, Artistic Director of Against the Grain Theatre, at an Opera Pub. Photo: Darryl Block, courtesy AtG."
publishDate = "2017-05-07T11:09:00-04:00"
related_articles = ["articles/atgs-opera-pubs-it-can-all-get-a-bit-wild.md","articles/the-future-of-opera-is-indie.md","articles/i-think-it-takes-a-brave-artist-to-do-something-like-an-opera-pub.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/christopher-mokrzewski.md","scene/people/adam-fisher.md","scene/people/jonathan-macarthur.md","scene/people/alexander-dobson.md","scene/people/andrew-love.md"]
short_description = "The success of the Opera Pubs brings to light something that is - and should be - considered seriously among operatic circles across the globe: the potential for circular gratification among those on the inside. In Toronto, the audiences of most operatic events include familiar faces - fans, colleagues, and friends of those involved in the show; these are a beautiful group of folks, full of support and delight for the work done in their city. But any opera company worth the hype is constantly seeking audiences full of new faces, an ever-widening pool of interested listeners."
slug = "success-hype-the-first-season-of-opera-pubs-in-toronto"
title = "Success &amp; hype: the first season of Opera Pubs in Toronto"
+++

There are few events in the Canadian opera scene that have garnered as much hype as the Opera Pubs presented by Toronto's [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/). Like most good things, the premise is simple: a mixture of the opera-savvy and the opera-curious gather at the Amsterdam Bicycle Club, and a handful of opera singers share the work of performing a few sets' worth of arias and duets.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494126061425/2017-05-04---Opera-Pub-5.jpg.jpg)
<figcaption>Adam Fisher, tenor, and pianist David Eliakis performing at the May 4th Opera Pub. Photo courtesy of Against the Grain Theatre.</figcaption>
</figure>

These monthly Opera Pubs have ancestry in the humble bars of Banff, Alberta, and even more strongly in Norway, where AtG Artistic Director [Joel Ivany](/atgs-opera-pubs-it-can-all-get-a-bit-wild/) heard the singers of the Norwegian National Opera entertain crowds at Oslo's Underwater Pub. Now that they've come to Toronto, AtG's Opera Pubs have become synonymous with fun nights out, and line-ups out the door. May 4, 2017, marked the final Opera Pub of the season, and they're set to return on October 5, 2017.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494126117721/2017-05-04---Opera-Pub-2.jpg.jpg)
<figcaption>Alex Dobson, baritone, performing at the May 4th Opera Pub. Photo: Darryl Block, courtesy of Against the Grain Theatre.</figcaption>
</figure>

It's not hard to see why the events are so popular. For the newcomer to opera, the idea of an Opera Pub strikes a great balance between satisfying one's curiosity about the art form, and offering an environment that's familiar and not intimidating. With the singing broken up into easily digested sets, listeners feel free to come and go as they please, and the night is easy on those with shorter attention spans.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494126072729/2017-05-04---Opera-Pub-4.jpg.jpg)
<figcaption>Jonathan MacArthur, tenor, performing at the May 4th Opera Pub. Photo: Darryl Block, courtesy of Against the Grain Theatre.</figcaption>
</figure>

For those who are decidedly "in" Toronto's operatic circles - the singers, directors, conductors, and other opera-creators - the night means all of the above, and much more. It can be a jackpot of one-stop socialising; it's tough to make it from one's table to the bar (much less the bathroom) without spotting a familiar face. It's a chance for colleagues to hear each other at work, likely in an environment that's novel compared to the usual rehearsal-room routine. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494126083727/2017-05-04---Opera-Pub-3.jpg.jpg)
<figcaption>Andrew Love, baritone (and Julie Ludwig, soprano), performing in the May 4th Opera Pub. Photo: Darryl Block, courtesy of Against the Grain Theatre.</figcaption>
</figure>

The success of the Opera Pubs brings to light something that is - and should be - considered seriously among operatic circles across the globe: the dangerous potential for circular gratification among those on the inside (and the resulting sense of exclusivity to newcomers). In Toronto, the audiences of most operatic events include familiar faces - fans, colleagues, and friends of those involved in the show; these are a beautiful group of folks, full of support and delight for the work done in their city. But any opera company worth the hype is constantly seeking audiences full of new faces, an ever-widening pool of interested listeners. 

The *bona fide* opera fans are an easy bet who will certainly put their butts in the seats. It's the presence of opera newbies that signals real success.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1494126106828/2017-05-04---Opera-Pub-1.jpg.jpg)
<figcaption>Topher Mokrzewski, Music Director of Against the Grain Theatre and host of the May 4th Opera Pub. Photo: Darryl Block, courtesy of Against the Grain Theatre.</figcaption>
</figure>

So, it's exciting to see the hands raise when AtG asks its audience who among them are brand new to opera. The packed house bodes well for enthusiasm and a sense of high demand for the monthly events; plus, it suggests that a larger venue, or more frequent Opera Pubs could make room for more first-timers. From day one, a major goal for Ivany and his AtG team has been to prove that opera isn't intimidating or inaccessible; these Toronto-based Opera Pubs just might serve as an operatic point of entry for newcomers, that benefits companies across the country.

Stay in the loop about Opera Pubs, & all things AtG: follow them on [Twitter](https://twitter.com/AtGtheatre), [Facebook](https://www.facebook.com/AtGtheatre), and [Instagram](https://www.instagram.com/AtGtheatre/).
