+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-09-06T12:26:00-04:00"
lastmod = "2017-11-11T14:17:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510427852011/2017-11-11---tablets-cocktail-cocktail-tablets-drugs.jpg.jpg"
publishDate = "2014-09-06T12:26:00-04:00"
related_articles = ["articles/musicians-sexual-harassment-blurred-lines.md"]
short_description = "A few articles popped up recently about the problem of anxiety and depression amongst classical musicians. A survey done by Help Musicians UK sampled after 500 working musicians (about 20% of them singers), and found that 60% claimed to have suffered from a psychological concern such as depression and/or debilitating anxiety. "
slug = "substance-abuse-in-the-opera-industry-yup-but-why"
title = "Substance abuse in the opera industry, yup. But why?"
+++

A few articles popped up recently about the problem of anxiety and depression amongst classical musicians. A survey done by [Help Musicians UK](https://www.helpmusicians.org.uk/news/latest-news/health-and-wellbeing-see-the-results-of-our-survey) sampled after 500 working musicians (about 20% of them singers), and found that 60% claimed to have suffered from a psychological concern such as depression and/or debilitating anxiety. A study by Health.com showed that artists are [ranked fifth](http://www.health.com/health/gallery/0,,20428990_6,00.html) in the top 10 careers with the highest rate of depression. Not surprisingly for artists, the biggest sources of stress are anti-social work hours, money problems and work insecurity; following closely behind are relationship problems, travelling and lack of proper exercise/nutrition.

And it's not limited to issues of mental health; plenty of musicians turn to prescription drugs and alcohol so that they can handle their nerves onstage and off. Cellist [Rachael Lander ](http://www.telegraph.co.uk/culture/tvandradio/11041804/Addicts-Symphony-drink-and-drugs-widespread-in-classical-world-says-cellist.html)explains, "There is the lifestyle, the odd hours, working weekends, post-concert socialising. Many players use alcohol and beta-blockers to control their performance anxiety and then, after the 'high' of a performance, musicians can struggle to 'come down' and therefore drink to relax – which becomes habitual."

It's of course a problem in the opera world, which is a place where the troubles of classical musicians can become amplified. Like any working musician, opera singers struggle to achieve and maintain an impeccable technique, all while being constantly at risk of losing work with a poorly-timed illness or off-day. But even aside from musical demands, singers face many of the same mental hurdles as do professional actors. They have to think about their looks, and the more successful a singer is, the more they have to maintain a public image that is unsullied and scandal-free. The demand for perfection isn't necessarily higher for opera singers than other musicians, but that demand definitely comes from more types of people. According to German tenor [Endrik Wottrich](http://www.theguardian.com/world/2007/aug/19/germany.classicalmusic), "The real pressure is no longer good old stage fright but comes from a new dimension that has penetrated opera - it now lives from glamour, and normal human mistakes are a disruption in such an environment." And when it comes to those of us prone to seeking the potentially harmful "quick fixes" for all this stress, there's a perfect storm surrounding those who seek the operatic spotlight.

People have been trying to figure out why artists are so prone to issues concerning mental health and substance abuse for centuries, and I'm not going to claim to have a new answer. [This article](http://creativesomething.net/post/55508909341/the-link-between-depression-and-creativity-and-how-it) suggests that naturally creative people who are drawn to the arts are very contemplative, spending lots of time thinking about their own thoughts. Major depression is found to be exacerbated when one [ruminates](http://psychcentral.com/blog/archives/2011/01/20/why-ruminating-is-unhealthy-and-how-to-stop/) on an idea or experience, and overthinking things is something artists do really well.

A couple of cool things to come out of this hard topic: this summer at the [Edinburgh Fringe Festival](https://www.edfringe.com/), the new [Arts and Minds](http://www.thestage.co.uk/news/2014/08/industry-wide-initiative-protect-actors-mental-health-problems/) initiative was set up to raise awareness about the difficulties that those working in the theatre arts can face. As part of the initiative, the festival this year featured the new Sanctuary, a space designed specifically for Fringe performers to be "a calm, quiet place within Fringe Central, where participants can get away from things".

And, back on the musical side of things, there's the really amazing [Addicts' Symphony](https://twitter.com/AddictsSymphony). It was started by composer James McConnel, who is a recovering alcoholic and who tragically lost his 18-year-old son to a drug overdose in 2011\. James started the Addicts' Symphony project in order to help others avoid a similar fate, and to seek the help that's available simply in the act of making music communally. He recruited a group of 10 recovering addict musicians to play and write music together, coaching it alongside the London Symphony Orchestra. Read about the project [here](http://blog.lso.co.uk/lso-discovery/addicts-symphony/), and watch the Channel 4 [documentary about it here](http://www.channel4.com/programmes/addicts-symphony/4od#3748522), if geography is on your side.

I wonder if stats like the above have ever been brought up in discussions about funding the arts? There may indeed be a veritable link between creative personalities and tendency towards psychological issues, but two of the top reasons these musicians gave for why they're so strained to begin with are related to job security and adequate pay. It's a simple as this: with better funding for orchestras, choirs, concert halls, opera houses, arts education, etc., more art could be produced by more working artists. Maybe the chance to ease some of the work and financial stress in the lives of artists is enough of a bonus to convince more people of the value of the arts.

Naïve as it may sound, I think it's fortunate that these creative people suffering from depression have their creative outlet. For musicians, their craft might not be working as a cure for their lowest days; but it's at the very least a way to make something good come out of what seems bad.
