+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2018-05-03T13:31:00-04:00"
lastmod = "2018-05-03T13:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368185769/sqJESUSCHRISTSUPERSTAR_LYR180422_151_c.jpg.jpg"
primary_image_credit = "Jesus Christ Superstar, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg."
publishDate = "2018-05-03T13:31:00-04:00"
related_articles = ["articles/sweeney-todd-demon-of-disguise.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
short_description = "&quot;He&#039;s a man. He&#039;s just a man.&quot; These lyrics, so central to Mary&#039;s song, seemed to me the springboard for Heath Saunders&#039; portrayal of Jesus. In Saunders&#039; performance we saw Jesus as a victim-of-circumstance, but in the most dire way. It wouldn&#039;t be enough to say that the vulnerability Saunders brought to the role was &quot;relatable&quot; or even &quot;human&quot;; it was sublime (or sublimated?) heartbreak."
slug = "sublime-heartbreak-jesus-christ-superstar"
title = "Sublime heartbreak: Jesus Christ Superstar"
+++

I have a confession to make: before opening-night performance of *Jesus Christ Superstar* at [Lyric Opera of Chicago](/scene/companies/lyric-opera-of-chicago/), I had never seen a live musical-theater production. Though I may be a neophyte when it comes to musical theater, I can only hope that you, dear reader, will embrace the impressions of an enthusiastic newcomer to the genre because…I loved this show and I want to tell you why!
 
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368322737/JESUSCHRISTSUPERSTAR_LYR180422_015_c.jpg.jpg)
<figcaption>*Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

First of all, there was the singing. Director Timothy Sheader and his team cast this production with great care and deliberation. In an interview with LOC dramaturg Roger Pines (March 2018, printed in the program book), Sheader explains: "The casting took so long because throughout the auditions, we were looking for individuality and authenticity." Individual and authentic are, indeed, the best ways to describe this production's stellar cast.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368369474/JoLampert_JESUSCHRISTSUPERSTAR_LYR180426_065_c.jpg.jpg)
<figcaption>Jo Lampert (Mary Magdalene) in *Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
Jo Lampert, in the role of Mary Magdalene, was a particular standout for her soulfully lyrical voice and layered stage expressivity. In her character-defining torch ballad, "I Don't Know How to Love Him," Lampert struck a remarkable balance between virtuous innocence and worldly affection. I listened to several renditions of this number before attending Friday's performance and, to my ears, Lampert's seemed to combine the best qualities of Yvonne Elliman's cutting vocality on the original 1970 recording with Sara Bareilles' mellifluous interpretation on NBC's recent broadcast *Jesus Christ Superstar Live in Concert*. 
 
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368335612/HeathSaunders_JESUSCHRISTSUPERSTAR_LYR180422_366_c.jpg.jpg)
<figcaption>Heath Saunders (Jesus) in *Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

"He's a man. He's just a man." These lyrics, so central to Mary's song, seemed to me the springboard for Heath Saunders' portrayal of Jesus. In Saunders' performance we saw Jesus as a victim-of-circumstance, but in the most dire way. It wouldn't be enough to say that the vulnerability Saunders brought to the role was "relatable" or even "human"; it was sublime (or sublimated?) heartbreak. And visceral to the extreme – writhing hither and thither, being carried, pushed, or coaxed across the stage by the crowds, grasping at the heavens in violent exasperation. Again, having done my homework before the show, I knew to anticipate "Gethsemane," Jesus' powerhouse passion song in Act 2. I listened excitedly for the climactic high G, which Saunders nailed as a kind of pitched primal scream on the words, "why should I die?" As a singer-actor, Saunders displayed a breathtaking range.
 
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368568888/RyanShaw_JESUSCHRISTSUPERSTAR_LYR180422_326_c.jpg.jpg)
<figcaption>Ryan Shaw (Judas) in *Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>

Equally powerful was Ryan Shaw in the role of Judas. More than just a mere plot-mover, as in the Biblical accounts, the Judas of Webber-Rice's imagining is a complex figure with larger concerns on his mind. It is mostly from Judas' perspective that we witness the action unfold and experience his sense of responsibility toward his friend as well as his community. I thought Shaw paced the inherent tension of his role superbly. In the scene of his death,  it was impossible not to be swept along with Shaw as he sang his soul's anguish, abetted by the sound of frenzied electric guitars and organ. Shaw received a momentous ovation for his artful performance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368347342/CavinCornwall_JESUSCHRISTSUPERSTAR_LYR180426_329_c_.jpg.jpg)
<figcaption>Cavin Cornwall (Caiaphas) in *Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
In the trio of antagonists, we heard Michael Cunio as Pilate, Shaun Fleming as Herod, and Cavin Cornwall as Caiaphas. Each brought a distinct flavor of evil to his respective part both vocally and acting wise. No flower-child villainy here, as in the 1973 film of *JCS*; this was modern-day, edgy viciousness. There was a sinister quality to Cunio's voice, which was at once captivating and cringe-worthy, especially as he counted off 39 lashes. Cornwall delivered a grandiloquent Caiaphas with his booming bass. And Fleming blew the roof off the house with his rendition of "Herod's Song." In full-out glam rock fashion, Fleming appeared in a fabulous gold outfit with a seemingly endless gold train. Fleming's interpretation of this number was more KISS-macabre than honky-tonk-playful, but perhaps for that very reason his was one of the highlights of the whole show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368393453/ShaunFleming_JESUSCHRISTSUPERSTAR_LYR180422_435_c.jpg.jpg)
<figcaption>Shaun Fleming (Herod) in *Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
Supporting the roster of leads was an incredible ensemble comprised of native Chicagoans, veterans of the LOC chorus, musicians from the LOC orchestra, and an awesome rhythm section all lead adroitly by conductor Tom Deering. Though the singing made our hearts soar, the dancing made our hearts leap. Choreographer Drew McOnie has won several awards for his work and in 2017 was nominated for an Olivier Award for Best Theater Choreography for this same production of *JCS* at Regent's Park Open Air Theatre in London. Just as Lloyd Webber drew on diverse styles of music for this score, McOnie complements with a diverse choreography executed with electrifying precision and intent by his troupe. A generous fellow audience member next to me lent me his opera glasses, so while my ears followed the singers, my eyes were glued to the dancers for most of the show.        

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525368359303/JESUSCHRISTSUPERSTAR_LYR180426_272_c.jpg.jpg)
<figcaption>*Jesus Christ Superstar*, Lyric Opera of Chicago, 2018. Photo: Todd Rosenberg.</figcaption>
</figure>
 
It quickly became apparent to me that this production was, at its heart, a grand fête honoring song, lyricism, and spectacle. What better way to cap a season at a major theater? Seeing it on the stage of the Lyric Opera House — this storied Temple to the voice and drama — made all the sense in the world. This being the sixth season of Broadway at Lyric, all I can say is that I cannot wait for season seven with Bernstein's classic *West Side Story*!

If you want to know "what the buzz" is about in Chicago this month, rush to the Lyric Opera House for an unforgettable *Jesus Christ Superstar*. The production runs until May 20. 
