+++
author = ["authors/oliver-munar.md"]
categories = "Review"
date = "2018-10-22T12:32:00-04:00"
lastmod = "2018-10-22T19:40:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540225858795/sq01MITCHELL_Violetta.jpg.jpg"
primary_image_credit = "Laquita Mitchell as Violetta in La traviata, Edmonton Opera, 2018. Photo: Nanc Price."
publishDate = "2018-10-22T19:40:00-04:00"
related_articles = ["articles/heartfelt-and-intimate-manitoba-operas-la-traviata.md","articles/la-traviata-shows-houston-how-to-arise.md"]
related_companies = ["scene/companies/edmonton-opera.md"]
related_people = ["scene/people/laquita-mitchell.md","scene/people/jason-bridges.md","scene/people/james-westman.md"]
short_description = "The night, however, belonged to baritone James Westman and his standout performance of Giorgio Germont, Alfredo&#039;s father. Westman has considerable longevity with this role; he will play Germont for the 200th time in the spring of 2019 in a celebrated career that has spanned two decades."
slug = "strong-ensemble-lifts-edmonton-opera-production-of-la-traviata"
title = "Strong ensemble lifts Edmonton Opera production of La traviata"
+++

Giuseppe Verdi got a lot of things right with *La traviata*: lush music for a story with universal themes such as love, sacrifice and redemption, and beautiful music for the larger-than-life characters. Walking into the opening-night performance of [*La traviata*](https://www.edmontonopera.com/2018-19/la-traviata/) with [Edmonton Opera](/scene/companies/edmonton-opera/), you could feel the energy of both excitement and expectation.

On this night, Edmonton Opera was up to the task, having assembled one of the strongest ensemble casts in recent memory.

Anchoring the cast was soprano [Laquita Mitchell](/scene/people/laquita-mitchell/), in her Canadian debut as the tragic heroine Violetta Valéry. Mitchell comes to Edmonton with heavy performance credentials in the role and offers a poised, noble yet vulnerable of the famed courtesan. Her round, colourful tone shimmers with vivacity, character and depth as she takes us on Violetta's emotional journey. On this night, Mitchell handled the acrobatics of Violetta's signature aria "Sempre libera" with aplomb, but it was in her dramatic interactions with her costars that brought the audience to its feet. Her decision to leave Alfredo is especially heart-wrenching; kudos to clarinettist Julianne Scott for making the letter scene all the more poignant.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540225881477/02BRIDGESandMITCHELL_AlfredoandVioletta.jpg.jpg)
<figcaption>Jason Bridges (Alfredo) and Laquita Mitchell (Violetta) in *La traviata*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

Tenor [Jason Bridges](/scene/people/jason-bridges/) impresses in his portrayal of the romantic leading man, Alfredo. The US-born, Europe-based Bridges also makes his Canadian debut with this production of *La traviata* and it is a debut to be celebrated. Bridges' velvety tone is a sonorous match for Mitchell's Violetta; he brings a simplicity and honesty that plays to the relative naïveté and innocence of his character. And while the passion Bridges portrays is palpable, it is measured and controlled, befitting of a well-to-do gentleman. However, I would have liked for the confrontation with his character's father to be even more visceral and raw, which would make for Alfredo's redemptive moment at the end of the act even more effective. On this night, Bridges led the well-known "Brindisi" chorus with energy, but the chemistry he had with Mitchell in the more tender moments showed off his gorgeous, lyric voice.

The chorus, expertly prepared by chorusmaster Peter Dala, was definitely a highlight of this production. At the parties thrown by first Violetta and then Flora, the chorus looked like they were having fun on stage, while spitting out challenging lyrics at lightning speed. The gypsy and matador choruses, which included [Beste Kalender](/scene/people/beste-kalender/)'s Flora and [James McLennan](/scene/people/james-mclennan/)'s Gastone, showed off solid diction and clean, balanced harmonies. For their supporting roles, both Kalender and McLennan made the most of their stage time, with both artists showing off their showmanship and acting abilities in bringing the main characters together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540225893074/03WESTMANandMITCHELL_GermontandVioletta.jpg.jpg)
<figcaption>James Westman (Germont) and Laquita Mitchell (Violetta) in *La traviata*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

Soprano Cara McLeod gets a bit more to sing as the dutiful servant Annina and offers a reliable, clean performance. Annina's interactions are primarily recitative and McLeod navigates it cleanly and confidently to ensure the conversational banter remains natural.

The night, however, belonged to baritone [James Westman](/scene/people/james-westman/) and his standout performance of Giorgio Germont, Alfredo's father. Westman has considerable longevity with this role; he will play Germont for the 200th time in the spring of 2019 in a celebrated career that has spanned two decades. Westman's familiarity with the role results in a multi-layered portrayal of a man whose concern for his family's reputation upends the romance at the heart of *La traviata*; this was a man who simply wanted the best for his family, only to realize his actions robbed Violetta and Alfredo of valuable time together. At the heart of his portrayal is a round, clear voice that navigates the challenging tessitura effortlessly. Of note, the veteran baritone's performance of the aria "Di Provenza il mar, il suol", in which he tries to convince his son to return to his family instead of carrying on with a courtesan, was simply exquisite. On this night, the sentimentality Westman brought to the aria was tinged with both sadness and frustration. I definitely shed a few tears as he pleaded with first Violetta, then Alfredo, to end their relationship, and then begs forgiveness from them both before (spoiler alert!) Violetta dies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540225900538/04-WESTMAN_Germont.jpg.jpg)
<figcaption>James Westman (Germont) in *La traviata*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

Honourable mention should be made of the set design, the result of Edmonton Opera’s collaboration with four other Canadian opera companies. As the opening curtain lifted, patrons applauded this new set, which is anchored by a long, curved staircase that allows the singers to perform on two levels. Director Alain Gauthier uses the set to great potential; the "Brindisi" chorus features Alfredo and Violetta singing from a higher balcony, above and over the party guests, and party-goers used entrance points on the upper levels to interact in three dimensions instead of being confined to the stage floor. Production designer Christina Poddubiuk dresses the stationary set effectively to differentiate three locales: horizontal blinds for Violetta's party, clear windows opening to a clear blue sky at a country villa, and crimson curtains for Flora's party. The lighting design by Kevin Lamotte was especially effective in Acts II and III, in which the action shows a passage of time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1540225908348/05-KALENDER_FloraleadsGypsyChorus.jpg.jpg)
<figcaption>Beste Kalender (Flora) in *La traviata*, Edmonton Opera, 2018. Photo: Nanc Price.</figcaption>
</figure>

With *La traviata*, Edmonton Opera offers a colourful production led by a trio of strong principals and a stunning set, and backs it up with a strong ensemble cast and chorus.

>Edmonton Opera's production of *La traviata* by Giuseppe Verdi has two remaining performances on October 23 and 26. For details and ticket information, [click here](https://www.edmontonopera.com/2018-19/la-traviata/).
