+++
author = ["authors/callie-cooper.md"]
categories = "Review"
date = "2018-03-25T20:24:00-04:00"
lastmod = "2018-03-25T20:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023306508/sq---_37A3402.jpg.jpg"
primary_image_credit = "Olafur Sigurdarson as Rigoletto in Minnesota Opera's new production of Rigoletto, 2018. Photo: Cory Weaver."
publishDate = "2018-03-25T20:24:00-04:00"
related_articles = ["articles/in-review-rigoletto-at-eno.md"]
related_companies = ["scene/companies/minnesota-opera.md"]
related_people = ["scene/people/michael-christie.md"]
short_description = "The musicality and the drama reached its peak with the final scene. The electricity coming up from the pit was so palpable, I felt physically ill when Rigoletto held his daughter for one last time. Despite a few issues with the production itself, the power of the story came through."
slug = "strong-despite-the-details-rigoletto-in-minnesota"
title = "Strong despite the details: Rigoletto in Minnesota"
+++

Minnesota's Opera production of *Rigoletto* was an unforgettable evening. The curtain opened on a striking party scene; the Duke sat high upon a throne perched on his treasures. The lighting was red and the observatory window that was used in *Dead Man Walking*, was in place high above the stage where stormtrooper-like guards patrolled.  The transition set that backed the first meeting between Rigoletto and the assassin Sparafucile was shiny black tarp and a bunch of lasers. The second scene highlighted Gilda's child-like innocence. Next to Gilda's bed there was a wall full of angel figurines and candles. This set really came alive with the first duet between Rigoletto and Gilda. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023363103/_37A3504.jpg.jpg)
<figcaption>Olafur Sigurdarson as Rigoletto and Matt Boehler as Sparafucile in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

Rigoletto was sung by Icelandic baritone [Olafur Sigurdarson](https://mnopera.org/biography/olafur-sigurdarson/). His rich voice cascaded through the hall, and he gave a very sympathetic performance. He clearly showed a man who had been abused his whole life, and had deep love and affection for his daughter. I wish there had been more visceral anger and bloodlust in his portrayal though.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023414545/_37A2798.jpg.jpg)
<figcaption>Marie-Eve Munger as Gilda and Joshua Dennis as the Duke in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

[Marie-Eve Munger](https://mnopera.org/biography/marie-eve-munger/), singing the role of Gilda, presenting an exquisite rendition of "Caro nome". Munger's characterization of this young girl in her final days of living was extraordinary. Tenor [Joshua Dennis ](https://mnopera.org/biography/joshua-dennis/) sang the famous "La donna è mobile" with a sombre touch. While an interesting choice, I felt confused on his motivations. But perhaps the real problem lies with the overarching concept of the production.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023377397/_37A2940.jpg.jpg)
<figcaption>Olafur Sigurdarson as Rigoletto in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

The walls were covered with very strong Nazi imagery. Each character had a swastika-like patch on their arm. Throughout the show, the men in the chorus reverted into eerie collective hand motions toward their Duke. Personally, I found the bombardment of Nazi allusions a bit much. In two of the sets there were massive portraits of the Duke, and the purpose of this may have been to show how he has inspired his noblemen to act cultishly. It seemed that some behind the scenes creators were conflicted on which way to take the Duke, and by the final scene, I was left wanting more answers.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023394716/_37A3796.jpg.jpg)
<figcaption>Olafur Sigurdarson as Rigoletto in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

Among the secondary characters, there were some stand-outs. Though in the small role of Matteo Borsa, [Andres Acosta](/scene/people/andres-acosta/andres-acosta/)was absolutely magnetic on stage. [Kenneth Kellogg](/scene/people//kenneth-kellogg/) played Monterone, the man who plants the paranoia in Rigoletto. Whenever Kellogg stepped on stage, though very briefly, he commanded it with his presence. Sparafucile was sung by [Matt Boehler](https://mnopera.org/biography/matt-boehler/). His towering build full bodied bass was perfect for the ominous assassin. His "assistant" sister, Maddalena, was sung wonderfully sung by [Nadia Fayad](https://mnopera.org/biography/10549-2/). Both showed full commitment to their characters.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023430050/_T8A3501.jpg.jpg)
<figcaption>Joshua Dennis as the Duke in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

Costuming was done by [Valérie Thérèse Bart](https://mnopera.org/biography/valerie-therese-bart/). The chorus were dressed in splashy pastel colored evening wear in the first act, then in black cloaks (although some of the choristers looked like they were clergy in cassocks instead of seedy noblemen playing tricks on the hunchback). There were odd light up animal masks that the male chorus wore while kidnapping Gilda. They were an unexpected addition to the night, but were striking in showing how the mob enjoyed their anonymity as they abducted Rigoletto's daughter. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023449652/_37A3807.jpg.jpg)
<figcaption>Olafur Sigurdarson as Rigoletto and Marie-Eve Munger as Gilda in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

An unnecessary moment of the night was during the Duke's "Parmi veder le lagrime", when an unknown woman came out and performed an incredibly awkward striptease for the Duke. The Duke was uninterested. It seemed a very pointless and gratuitous addition to the production. The actress who stripped looked very uncomfortable, and that energy reached the audience. Once the aria had ended, the Duke dismissed the woman with a wave of his hand. Was this display used to show the Duke's true love for Gilda? But how can a man who would turn down a stripper, go deflower a maiden and then be easily lured by the salacious Maddalena? There was a lack of animation and choices portrayal of the infamous Duke of Mantua. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522023461307/_T8A3918.jpg.jpg)
<figcaption>Marie-Eve Munger as Gilda in Minnesota Opera's new production of *Rigoletto*, 2018. Photo: Cory Weaver.</figcaption>
</figure>

The orchestra was very good, with [Michael Christie](https://mnopera.org/biography/michael-christie/) doing justice to Verdi's dramatic score. The musicality and the drama reached its peak with the final scene. The electricity coming up from the pit was so palpable, I felt physically ill when Rigoletto held his daughter for one last time. Despite a few issues with the production itself, the power of the story came through. Musically, this show was the strongest in the season thus far, and I can’t wait to see what MN Opera is going to cook up for the rarely performed [*Thaïs*](https://mnopera.org/season/2017-2018/thais/) in May.

>[Rigoletto](https://mnopera.org/season/2017-2018/rigoletto/) is onstage at Minnesota Opera through March 31. For details and tickets, [click here.](https://mnopera.org/season/2017-2018/rigoletto/)
