+++
author = ["authors/meghan-klinkenborg.md"]
categories = "Review"
date = "2018-07-09T21:05:00-04:00"
lastmod = "2018-07-09T21:05:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531183351774/sqDSC_6100.jpg.jpg"
primary_image_credit = "The Tender Land, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera."
publishDate = "2018-07-09T21:05:00-04:00"
related_companies = ["scene/companies/des-moines-metro-opera.md"]
short_description = "The Maytag hosts clearly took the term &quot;Iowa Nice&quot; to heart. Free snacks and beverages were supplied prior to the performance, as well as pie and ice cream afterwards. The atmosphere was welcoming and friendly, and I could sense that the Newton community had enthusiastically embraced their first opportunity to host the opera."
slug = "strange-inside-the-tender-land"
title = "Strange inside: The Tender Land"
+++

American opera set against a beautiful Iowan backdrop. [Des Moines Metro Opera](/scene/companies/des-moines-metro-opera/)'s picturesque production of Aaron Copland's *The Tender Land* provided a welcoming and intimate opera experience that felt truly Midwestern.

Considering all the storms and flooding in Iowa over the past few weeks, the weather on opening night of Des Moines Metro Opera's outdoor production was fortuitously serene. The freestanding set, designed by Adam Crinson, consisted of a farmhouse and barn, and the idyllic landscape of the [Maytag Dairy Farms](http://www.maytagdairyfarms.com/) served as natural scenery, complete with horses whinnying in the distance and a well timed sunset for ambiance.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531183468728/DSC_5217.jpg.jpg)
<figcaption>*The Tender Land*, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The Maytag hosts clearly took the term "Iowa Nice" to heart. Free snacks and beverages were supplied prior to the performance, as well as pie and ice cream afterwards. The atmosphere was welcoming and friendly, and I could sense that the Newton community had enthusiastically embraced their first opportunity to host the opera.

The main downfall of the outdoor venue was the sound. The orchestra, led by Joshua Horsch, was off to the side, and although monitors were placed around the stage, there were several musical passages that lacked cohesion between the singers and the pit. This was most notable in one of better known pieces from the opera, "The Promise of Living."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531184551810/DSC_5935.jpg.jpg)
<figcaption>*The Tender Land*, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

I must commend the musicians on their persistence in the face of these technical problems. Many of the singers' microphones would cut in and out during the opera, and while this issue undermined some otherwise great vocal deliveries, none of the singers let their inner frustration affect their performances. The use of microphones also provided a level of vulnerability that is abnormal to most opera singers. The amplification (when functioning correctly) exposed the voices more than usual, and while this led to some impressive moments, there was no hiding any technical flaws.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531184563128/DSC_6084.jpg.jpg)
<figcaption>*The Tender Land*, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

Soprano Grace Kahl and tenor Remy Martin were perfectly matched as the wholesome lovers, Laurie and Martin. In typical operatic fashion, these two dreamers go from "Nice to meet you" to "Let's get married" in the span of one evening, and while their love for each other is genuine, their dreams of the future are not in sync. Laurie is still naive, optimistic, and above all, restless. She is on the cusp of adulthood, and she longs to see the world and assert her independence. Martin seems like the kind of person Laurie might become. He is still a positive soul, but you can tell that reality has worn him down a little. His dream is to settle down and find stability with Laurie, but that possibility is squashed when he is forced to leave town. In the end, even though Laurie is convinced that she wants to elope and live on the road with him, Martin cannot bear the idea of putting her through that kind of hardship and leaves without her.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531184574202/DSC_6013.jpg.jpg)
<figcaption>*The Tender Land*, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

Remy Martin brought natural likability and charm to the role of Martin, and I was so disappointed that he seemed to suffer from the microphone issues more than others. This was especially unfortunate during his aria, "I'm gettin' tired of travelin' through," which sounded lyrical and tender during the short snippets that I could hear properly.

All my favorite music in *The Tender Land* belonged to Laurie, and Grace Kahl's voice had a smooth clarity that highlighted the innocence and optimism of the character even in the trickiest passages. Kahl was a breath of fresh air as she strolled onto the stage, and thankfully, her microphone was the most consistent of the night.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531184616525/DSC_6015.jpg.jpg)
<figcaption>*The Tender Land*, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

The rest of the cast supplied the more down to earth and humorous sentiments of the opera. Harry Greenleaf brought infectious energy to the stage in his portrayal of Martin's companion, Top. Lindsay Kate Brown sang the part of Ma Moss, a woman who is struggling between the conflicting forces of her daughter and father. Rhys Lloyd Talbot brought a rich bass tone to the role of Grandpa Moss, a controlling and protective patriarch. Camryn Overton rounded out the family in the spoken role of Beth, Laurie's younger sister, running around the farm with her adorable canine companion.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1531184592395/DSC_6193.jpg.jpg)
<figcaption>*The Tender Land*, Des Moines Metro Opera, 2018. (c) Duane Tinkey for Des Moines Metro Opera.</figcaption>
</figure>

Above all else, *The Tender Land* seemed to be about the fears and excitement of leaving childhood behind. Laurie's family is unable to let her grow into a full fledged adult, and she feels that her only chance to do so is to move on. Martin ditched her, but Laurie doesn't need a man to pursue her destiny. Sure she has absolutely no plan or money...but the emphasis is on the idealism. Laurie decides to peace out just hours before her graduation with little remorse, and although her mom is distressed by her decision, just moments after her departure normal life resumes. It was as if Laurie was never crucial to their existence. She was always separate and "strange inside."
