+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-03-14T12:29:00+00:00"
lastmod = "2017-03-15T13:12:00+00:00"
preamble = "Storms are a show unto themselves. The lightning, the horizontal rain, the howling winds; it's no wonder that opera is among the many art forms that capitalize on the inherent tension in a tempest to boost the drama in their stories. Composers seems to relish the opportunity to capture the power of a storm, and the fear and uncertainty they can instill in us mere mortals.\n\nWith all the talk about nasty weather on the horizon, we figured it might be timely (if a little masochistic) to celebrate some of opera's best storm scenes. We chose our top six; if you've got favourites that aren't on this list, [let us know!](mailto:hello@schmopera.com)"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489496704416/2017-03-14---Storm.jpg.jpg"
publishDate = "2017-03-15T12:58:00+00:00"
short_description = "Storms are a show unto themselves. The lightning, the horizontal rain, the howling winds; it&#039;s no wonder that opera is among the many art forms that capitalize on the inherent tension in a tempest to boost the drama in their stories. Composers seems to relish the opportunity to capture the power of a storm, and the fear and uncertainty they can instill in us mere mortals."
slug = "stormy-weather-6-nasty-opera-tempests"
title = "Stormy weather: 6 nasty opera tempests"
+++

## *Il barbiere di Siviglia*

If you're a Rossini fan, you know the composer made great use of storms in his operas. One of the more famous ones is from his comedy, *Il barbiere di Siviglia*. It's almost eerie how accurate it depicts the stages of a storm, starting with the silent flashes of lightning, and easing in the rainfall from a mild drizzle to a torrential deluge. Of course, it's no gratuitous tempest; Rossini places the storm right after Rosina thinks that she's been screwed over by her lover, and just as all the tension and conflict of the opera seem to come to a head. It's a cool instrumental-only moment of the opera, one where directors love to play.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/oSjyDH4MJCc?start=7526" frameborder="0" allowfullscreen></iframe>
</figure>

## *Rigoletto*

Verdi takes a cue of sorts from Rossini in this storm scene from the final act of *Rigoletto*. Similar flute licks signal the start of the storm, with nauseating string tremolos and creepy offstage chorus sounds to imitate the howling winds. The dramatic master that he is, Verdi continues the densest action of the show, right through this extended storm scene. The assassins are at work, Gilda is in disguise, and the Duke is being his general asshole self; all these stories collide with the help of the dark obscurity of a stormy night. As the whole thing reaches a peak, you can't help but be on the edge of your seat.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/9v4XeZIBOdw?start=6341" frameborder="0" allowfullscreen></iframe>
</figure>

## *Otello*

Another Verdi storm, but this one gives a great shot of electricity to the story of *Otello*, right from the first bar of the opera. It's a hell of a way to kick off a show, and you can hear the adrenaline pumping through the chorus and that fantastic orchestral writing. It all culminates in the arrival of Otello himself, holding back no less than the storm that just ravaged the opening scene.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/EQYed8oRxwA?start=174" frameborder="0" allowfullscreen></iframe>
</figure>

## *Peter Grimes*

In true Britten fashion, the storm of *Peter Grimes* happens both in real life, and inside the mind of Grimes himself. It's not the only storm-like scene in the show, but it's the first one. Britten uses one of his thrilling orchestral interludes to carry Grimes' desperation into the dangerous, heaving weather that pummels the coastal village in Suffolk. The genius part is that once the action picks back up in the next scene, the storm continues to rage outside; it's what all the townsfolk have in common, at least for today, but it doesn't help the ostracised Grimes fit in any better with his community.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/3MyBUetbE38?start=2019" frameborder="0" allowfullscreen></iframe>
</figure>

## *Filumena*

A favourite among 21st-century Canadian opera, Estacio and Murrell's *Filumena* features a pretty darn thrilling aria, commonly called "The Storm Aria". The opera tells the story of Filumena, the Italian immigrant to Canada who's trapped in a life she doesn't want, and whose circumstances seem to grow more and more dire. Her love of storms is a connective element in the opera, and this aria is a hit from Act I; there's something about it that recalls a combination of "Ain't it a pretty night?" from *Susannah* and "Sempre libera" from *La traviata*, but those sweeping lines are all Estacio.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/T88GGQdss7Q" frameborder="0" allowfullscreen></iframe>
</figure>

## *The Tempest*

When an opera is called *The Tempest*, it's only fair to give the audience what they expect. The overture to Thomas Adès' opera, based on the Shakespeare play, is a dizzying display of the storm conjured up by Prospero. It's relentless and assaulting, enough to convince us of the vengeful shipwreck that kicks off the action. Adès seems to hurl us right into the eye of the storm, eventually calming the waves and wind, leading organically into the aftermath.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/Yyud1KJBBWg?start=21" frameborder="0" allowfullscreen></iframe>
</figure>

>Readers, what are your favourite opera storms? Let us know in the comments below!
