+++
author = ["authors/paul-e-kwak-md.md"]
categories = "Op-Ed"
date = "2017-07-05T13:36:00-06:00"
lastmod = "2017-07-05T21:17:00-06:00"
preamble = "This is a guest contribution by [Paul E. Kwak, MD](http://nyulangone.org/doctors/1184937914/paul-e-kwak), laryngologist and laryngeal surgeon at the NYU Voice Center, and Assistant Professor in the NYU Department of Otolaryngology - Head and Neck Surgery. "
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1499289496191/2017-07-05---Adele.jpg.jpg"
primary_image_credit = "Photo: Kevork Djansezian/Getty Images"
publishDate = "2017-07-05T21:12:00-06:00"
related_articles = ["articles/10-pop-singers-with-pipes.md", "articles/hot-topics-singers-who-scoop.md", "articles/audition-season-or-the-annual-festival-of-shattered-dreams.md", "articles/talking-with-voice-docs-dr-paul-e-kwak.md", "articles/using-your-voice-again-a-plan-of-action.md", "articles/greg-jennas-roundup2017.md"]
short_description = "We can do better. We can espouse and proclaim the value of vocal health, technique, and efficiency, while recognizing with great respect and awe the beauty in non-traditional voices, and overcoming the professional and territorial myopia that threatens to rob us of our innate desire to hear the gift of a great voice raised in song."
slug = "stop-shaming-adele"
title = "Stop shaming Adele"

+++
Long after she is gone, Adele's greatest legacy will unquestionably be her music.

Even if she were indeed to stop touring imminently, as she has hinted she might, she will have given us a unique music of yearning, loss, grief, hope, and love; our ears may never again hear a voice that so achingly embodies heartbreak. This is a substantial legacy, for which we should be grateful. In recent days, however, some of us have watched the reactions to her performance cancellations, and hope unexpectedly that her second-most important legacy will be the way that she, her music, and her voice, have stimulated us to think more carefully about singing, vocal health, and injury.

>We who care for singers are certainly not unused to the chatter, the gossip, the verbal bile that can flow so freely and unbidden in these circles.

In the hours following the posting of her beautifully candid, heartfelt [announcement on Instagram](https://www.instagram.com/p/BV-4S86lbHV/?taken-by=adele&hl=en), legions of torch-wielding villagers who identify as voice experts could not wait to validate their negative prophecies as having come true. "I've heard Adele in concert," writes one, "and I have cringed every time because of the way she uses her voice. It is a recipe for problems. I hope she studies a little bit more and gets a better technique…." Another pipes up: "6 months of dramatic vocal technique boot camp would have her singing free from vocal nodes." Yet another: "My bigger concern would be all the young fans who would emulate her vocalisms and then mess up their own voices." Still another: "The two biggest issues are her smoking and her lack of hydration." One marvels at the levels of access to Adele these experts must have, to presume to know the findings from her most recent laryngoscopic examination, her daily fluid intake, and her smoking habits.

We who care for singers are certainly not unused to the chatter, the gossip, the verbal bile that can flow so freely and unbidden in these circles. But at a moment of a singer's self-professed greatest vulnerability, this kind of backlash is insulting and disgraceful, and blemishes the stone-throwers far more tellingly than it tarnishes Adele's contributions. This kind of commentary seeks to divide rather than unite those who should work collaboratively to care for and support singers. I constantly reiterate in seminars and conversations with young singers-in- training the importance of multidisciplinary care – as I like to say, the importance of having a voice "squad." I respect the wisdom of so many voice teachers and coaches, who have built methodologies based on years of experience and training. One of the forefathers of academic laryngology, Manuel Garcia, was himself first a great singing teacher, and indeed, also a forefather of vocal pedagogy. It is right that medical and artistic practitioners should be partners in the education and cultivation of a singing voice. However, what I am addressing here is rather the danger of opinion offered without knowledge of the specific case, or indeed in the absence and disregard of vocal science. This amounts to an insidious vocal fear-mongering that seems to arise out of antiquated anecdotalism, centering on the following myths:

>Singers, across genre and level of experience, bear all manner of structural abnormality on their vocal folds: polyps, cysts, nodules, and even scar.

### Myth #1: "Good singing" is equivalent to or emerges only from "good technique" or "healthy singing."

What a listener finds to be good – affecting, moving, challenging, cathartic, amusing – is the sum of any number of factors including but not limited to taste, personality, emotion, experience, mood. Since humans first began singing, we have thrilled to an exhilarating variety of voices, yet for at least 200 years, we have not come to agree consistently across genres about what constitutes ideal technique, nor do we always agree on what constitutes healthy singing. We can have profound experiences when listening to Maria Callas, Bob Dylan, Whitney Houston, Frank Sinatra, Patti LuPone, Renee Fleming, Joni Mitchell, Steven Tyler, Aretha Franklin, Luciano Pavarotti, and, yes, Adele. The point is that we who purport to be guardians of vocal health have little business admonishing our fellow listeners about the health of a singer's voice when deciding how to feel about her songs.

Indeed, we who take care of singers hold measured views, many of which are undergirded by data, about what constitutes healthy use of the voice, by which we generally mean a voice that enables a singer to meet her vocal demands, and to create his art sustainably over a long period of time. That does not inherently or automatically have any bearing over what makes a voice, or a performance, compelling or transformative. To quip that Adele has "bad technique" is often to miss the substance of her power entirely. If you are listening with the intent to scrutinize her vocal mechanics, you will surely wince at passages when the voice breaks, and strains in a tessitura above that which sounds most comfortable to her. But if your broken heart listens with open ears to the lyrics, melody – the music of what happens – very quickly, questions about efficient vocal fold oscillation seem tedious. Adele's music has provided comfort, healing, joy, to broken souls around the world; if in the creation of that, her sacrifice manifests in the form of an injury to her vocal folds, who are we but to thank her for that gift, and furthermore, who are we to disparage this effect she has had on millions of music lovers?

### Myth #2: Healthy singing can only happen when a singer has perfect vocal folds.

Spend a day in the office of any busy laryngologist who takes care of singers, and you will see example after example of elite, famed singers who slay on stage, every day, often eight times a week; and they do it with "imperfect" vocal folds. Indeed, in our offices, one quickly realizes what a flawed and treacherous concept that is – "perfect vocal folds." Singers, across genre and level of experience, bear all manner of structural abnormality on their vocal folds: polyps, cysts, nodules, and even scar. A better way to think about this is to invert the issue: many singers have no structural abnormalities on their vocal folds, but they struggle mightily to sing consistently and freely. The voice, in toto, is about far more than the anatomic configuration of the two vocal folds. Therefore, practitioners who perpetuate the false dichotomy of "nodules bad, no nodules good" only highlight their limited grasp of vocal physiology, and worse, perpetuate a baseless fear that frequently prevents singers from seeking care early in the course of an injury when they should, to improve the prognosis for rehabilitation.

>Armchair vocal coaching is as useful and welcome in singing as armchair quarterbacking is in football.

### Myth #3: When you sustain an injury to the vocal folds, it means you did something wrong, have bad technique, are a bad singer, or all of the above. The injury is your fault. You deserved it.

Only in our perversely enshrouded circles of singing do we stigmatize athletes who become injured. Anyone with an even basic understanding of vocal physiology understands what a profoundly athletic endeavor singing is. It is the height of hypocrisy, then, that when a football player tears his ACL, we celebrate his heroism and effort (or, at minimum, we do not consider that this is a result of bad form or technique), but when Adele announces an injury to her vocal folds, we heap aspersions on her. Consider that in Major League Baseball, there has been since its inception, a disabled list – the DL – which has at its core the notion that athletes naturally and routinely sustain injury because of the unnatural impact of the athletic endeavor on the tissues of the body. It is remarkable the extent to which this understanding of athleticism has failed to penetrate many reaches of the singing community.

Indeed, the chasm between physicians and voice coaches often seems widest when trying to navigate the vast mythology of vocal injury that has been perpetuated over decades. We are our best when our efforts, expertise, and training sum collaboratively toward the support and empowerment of a singer; we are our worst when we make silos of knowledge from cults of personality, and use falsehood to engender fear.

### Myth #4: The most important measure of success is the length of a career.

We who devote our lives to keeping singers healthy and singing as long as possible can talk ourselves into believing that ours is the most important input, and that length of career is an artist's most important value, a priori. But we might do well to have some humility and perspective about health and the ways it can at times be at odds with the creation of art, and the truth within an artist. Ultimately, those who ascend soapboxes about health in singing can in fact expose their limited view of artistic expression through a voice; indeed, what is curious in Adele's case is the way the criticisms have turned on opinions about the health of her larynx.

>Opinions unrooted in fact which seek only to bring low an artist are expressions of ignorance, abuse, and regression. We can do better.

Armchair vocal coaching is as useful and welcome in singing as armchair quarterbacking is in football. The peanut gallery neglects to appreciate the singularity of Adele's voice, but worse, it fails to acknowledge the singular enormity of her circumstances. Assuming that her goals and values are the same as ours, and that her struggles are the same as ours, suggests a presumptuous narrowness of thought and perspective. Singers in training might perform recitals for groups of 20-50; stars at The Metropolitan Opera will often sing to a full house of 3,000. Adele walks out and looks at 20,000 strangers, who know every lyric and note she is about to sing, hang on each one, and are recording her performance on their iPhones. This pressure likely sends adrenaline and cortisol through her blood at levels greater than most of us will ever experience routinely; it may make her pharynx tenser, her neck tighter, her breathing occasionally shallower. Less busy singers can enjoy several days of rest between shows; she has a show every third night, for a grueling total of 120 shows in the past year. After each of those 120 shows, she signs autographs, poses for selfies with fans who want to have a chat with her, then maybe she kisses her sleeping child goodnight before eating a late-night dinner right before collapsing into a different bed each night that is not her own. None of us will ever understand, experientially, the path she walks to that microphone, nor will she ever understand what it's like to be us – but instead of judging us, she stands at the front of that stage and delivers her soul to us, and all of that force and energy is funneled through two tiny, often fatigued, folds of muscle, connective tissue, and mucous membrane.

Singing is about far more than the act of walking onto a stage, opening one's mouth, and taking a breath to move air through two small pieces of tissue to create sound. It is our most primal and human act of expression and connection. Functionally, it is athletic; culturally, it is spiritual.

Reactions to singing and to a voice are therefore as integral to the experience as the voice itself; but opinions unrooted in fact which seek only to bring low an artist are expressions of ignorance, abuse, and regression. We can do better. We can espouse and proclaim the value of vocal health, technique, and efficiency, while recognizing with great respect and awe the beauty in non-traditional voices, and overcoming the professional and territorial myopia that threatens to rob us of our innate desire to hear the gift of a great voice raised in song.