+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-03-20T13:19:00+00:00"
lastmod = "2016-03-20T15:08:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458485674293/2016-03-20---Benjamin-Matthew-Lloyd.jpg.jpg"
primary_image_credit = "Composer George Benjamin. Photo by Matthew Lloyd."
publishDate = "2016-03-20T14:55:00+00:00"
related_articles = ["articles/in-review-written-on-skin.md","articles/in-review-jenufa-czech-philharmonic.md","articles/great-nights-the-dream-of-gerontius.md","articles/in-review-written-on-skin-at-roh.md","articles/fuelled-by-female-oppression-written-on-skin.md"]
related_people = ["scene/people/barbara-hannigan.md","scene/people/christopher-purves.md","scene/people/victoria-simmonds.md","scene/people/tim-mead.md","scene/people/robert-murray.md"]
short_description = "As one hopes, there were new layers uncovered with our second hearing of Written on Skin. Martin Crimp&#039;s libretto juxtaposes a story set in the 12th century, where a woman feels stifled in her marriage, and a man responds with a tightened grip on his wife, with images of the 21st century. Car-parks, airports, and concrete buildings pull against everything we know about Agnès: a woman married at 14, never taught to read or write, with a husband that confidently and explicitly declares her his property."
slug = "still-stunning-written-on-skin"
title = "Still stunning: Written on Skin"
+++

The Barbican Centre closed its *Benjamin at the Barbican* series last night, with a semi-staged performance of George Benjamin's opera with Martin Crimp, *Written on Skin*. Since its premiere at Aix-en-Provence in 2012, *Written on Skin* seems to pop up everywhere, nestling itself firmly among the gems of contemporary English opera. We had the chance to hear an in-concert performance of the work [last year with the Toronto Symphony Orchestra](/in-review-written-on-skin/), conducted by Benjamin, and featuring the cornerstone pair of singers from the world-premiere cast, baritone [Christopher Purves](/scene/people/christopher-purves/) as The Protector, and in the role of Agnès, soprano/conductor/übermensch, [Barbara Hannigan](/scene/people/barbara-hannigan/).

As one hopes, there were new layers uncovered with our second hearing of *Written on Skin*. Martin Crimp's libretto juxtaposes a story set in the 12th century, where a woman feels stifled in her marriage, and a man responds with a tightened grip on his wife, with images of the 21st century. Car-parks, airports, and concrete buildings pull against everything we know about Agnès: a woman married at 14, never taught to read or write, with a husband that confidently and explicitly declares her his property. The modern versus the ancient, but *not really*.

The Boy, sung spectacularly by countertenor [Tim Mead](/scene/people/tim-mead/), is an illuminator of books, and The Protector hires him to make a book that will describe him and his family as "the just", worthy of record for posterity. The book-illuminator is an archaic profession that's practically extinct, but the role of a young man, brought close to a family under trusting circumstances, and who breaks that trust, will always be a contemporary story.

Three Angels speak of the future (the present, really), and they speak of wiping out sinful humanity, exposing bad behaviour and admiring "the just"; in the same thought, they speak of making a woman "curious", making us flush with anger, and remember the story of Eve and the serpent. It took a second hearing to understand that these "Angels" are The Protector's projections; they're whom he prays to, but they're likely not the same Angels of his wife. Along with Tim Mead, last night's Angels were excitingly sung by mezzo-soprano [Victoria Simmonds](/scene/people/victoria-simmonds/) and tenor [Robert Murray](/scene/people/robert-murray/). All three have two characters; the first Angel becomes The Boy, and the second and third become Marie and John, an everyday, exemplary married couple who gossips and infects The Protector with doubts and ideas.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458485869356/2016-03-20---Hannigan-credit-Elmer-de-Haas.jpg.jpg)<figcaption>Soprano Barbara Hannigan. Photo by Elmer de Haas.</figcaption>
</figure>

The opera is an extraordinary piece, no doubt. The players of the Mahler Chamber Orchestra gave a stellar performance of Benjamin's score, which at once sounds magical, ancient, hateful, sexy, and mortally dangerous. Sickening percussion effects and the "hysterical" sounds of the glass armonica, voices indistinguishable from intruments, and enormous, suffocating chords all drag feeling from the listeners; without yet seeing a fully staged performance of *Written on Skin* (though we loved director Benjamin Davis' smart, subtle work with the cast), it's a thrilling thought to note that the work itself, with an unreal cast of singers, does all the expressive work on its own.

Christopher Purves and Barbara Hannigan are a stunning pair in this work. They're both beautiful actors, and after multiple tours and productions of Benjamin's work, the music and text are inside them in a way that's rare to hear. Purves had an amazing way of depicting a patriarchal, judgmental man, "addicted to purity and violence", as a sorry tragic figure, one who's more ignorant than malevolent, even if the end results are the same. He spits insults at his wife, growls terrifying phrases at her, and uses his friendly-sounding baritone to show The Protector's pride, idealism, and insecurities. 

Hannigan dives into this character (as she does with every role she takes on), and embodies Agnès as the unfortunate, uneducated, trapped woman that she is; yet there's an eerie, child-like desire to cross lines (even if the lines are unfairly placed to begin with), to antagonize, to make a bad situation hurt even more than it needs to. All this, plus extraordinary singing make Hannigan's Agnès a perfect complement to Purves' Protector; both parties in the failing marriage are innocent, both are at fault, both dig in their heels unnecessarily. Now, *that's* timeless.

Rarely are we held rapt for an entire performance of anything, yet it happened, twice now, with *Written on Skin*. The Royal Opera House is commissioning a new full-length opera by George Benjamin and Martin Crimp, to have its premiere in 2018. The details are still unknown, but our curiosity is real (even if it's a woman's curiosity).

<figure data-type="video">
<iframe width="514" height="305" src="https://www.youtube.com/embed/WsuTSOKYEF4" frameborder="0" allowfullscreen></iframe>
</figure>
