+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2018-01-27T21:23:00-05:00"
lastmod = "2018-01-27T21:23:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517105417942/1tosca_Bruce_Bennett%5B1%5D.jpg.jpg"
primary_image_credit = "Photo: Bruce Bennett."
publishDate = "2018-01-27T21:23:00-05:00"
related_articles = ["articles/talking-with-singers-jennifer-rowley.md","articles/talking-with-singers-riccardo-massi.md","articles/talking-with-singers-keri-alkema.md","articles/just-plain-great-pbos-le-nozze-di-figaro.md"]
related_companies = ["scene/companies/palm-beach-opera.md"]
related_people = ["scene/people/riccardo-massi.md","scene/people/keri-alkema.md","scene/people/michael-chioldi.md"]
short_description = "In a world where consent is so often coerced – Tosca&#039;s world, and ours – it&#039;s impossible not to draw comparisons to stories of #MeToo, #TimesUp, and a slew of fallen titans. It&#039;s easy to imagine Scarpia as a man who might have a button hidden beneath his desk to lock his office door."
slug = "steps-forward-for-operas-women-tosca-at-pbo"
title = "Steps forward for opera&#039;s women: Tosca at PBO"
+++

When Tosca falls to her death from atop the Castel Sant'Angelo, the soldiers standing guard look on in shock – all but one, hovering in the background at stage right, who slowly removes his cap. It's a small motion, barely noticable amid the high-flying drama of the opera's final scene – but there's meaning in it, too – sadness, horror, and respect – as though to say, If only things had turned out differently.

Stage director Fenlon Lamb and conductor David Stern led a riveting *Tosca* at [Palm Beach Opera](/scene/companies/palm-beach-opera/), bolstered by rockstar performances from a strong cast and orchestra. Breathtakingly detailed scenic design by Jean-Pierre Ponnelle drew loud applause every time the curtain rose, setting the stage for a production that was cinematic in scope – vivid, intense – and that left the audience on the edge of their seats, along the way striking some timely chords apropos of recent headlines.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517105879938/2tosca_Bruce_Bennett%5B1%5D.jpg.jpg)
<figcaption>Riccardo Massi (Cavaradossi) and Keri Alkema (Tosca) in *Tosca*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

As escaped political prisoner Angelotti, bass Scott Conner sang with urgency and resonance, making his offstage death pack an extra punch. Bass-baritone Thomas Hammons, known for originating the role of Henry Kissinger in *Nixon in China*, caught lots of laughs as the grumbling Sacristan. Emerging artists shone as well: mezzo-soprano Kelsey Robertson's offstage shepherd's song set the mood for the ominous third act, and tenor Brian Wallin alongside baritone Joshua Conyers were convincingly malevolent as police chief Scarpia's henchmen.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517105912615/3tosca_Bruce_Bennett%5B1%5D.jpg.jpg)
<figcaption>Keri Alkema (Tosca) in *Tosca*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

Tenor [Riccardo Massi](/talking-with-singers-riccardo-massi/) as self-assured painter turned political dissident Cavaradossi sang the role with genuine emotion and thoughtful artistry. His "E lucevan le stelle" – joined by warm, solemn solos from clarinetist Michael Forte – was one of the show's most stirring moments, and his chemistry with soprano [Keri Alkema](/talking-with-singers-keri-alkema/)'s title role was earnest and nuanced. Balancing brazenness with vulnerability, Massi's Cavaradossi reminded us that while *Tosca* is an opera about artists and evil and love, it is also an opera about activism – about standing up to oppose a corrupt and oppressive system, even at enormous risk.

Alkema's Tosca was captivating, with a skillful command of color and nuanced dramatic range. "I have given my songs to the stars, that the heavens might shine more beautifully," she sang during her showstopping "Vissi d'arte," and Alkema could have meant the words just as sincerely as her character. Tosca is often billed as a "jealous lover," but Alkema's interpretation was savvy and self-aware, the diva's patent jealousy playing out with wit rather than melodrama.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517105937625/4tosca_Bruce_Bennett%5B1%5D.jpg.jpg)
<figcaption>Michael Chioldi (Scarpia) in *Tosca*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

Opposite baritone [Michael Chioldi](/scene/people/michael-chioldi/)'s stentorian yet aptly detestable Scarpia – who else's curtain call could summon wholehearted boos concurrent with a standing ovation? – Alkema balanced Tosca's fear and disgust at Scarpia's indecent proposal with currents of rage and immense strength. Stabbing the advancing aggressor with a stolen knife, her cry of "This is the kiss of Tosca!" may well have carried the hashtag #Resist.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517105971227/5tosca_Bruce_Bennett%5B1%5D.jpg.jpg)
<figcaption>Keri Alkema (Tosca) and Michael Chioldi (Scarpia) in *Tosca*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

"This despotic maniac [Scarpia] is not a fantastical monster; he is a realistic embodiment of the depth to which a power-obsessed, misogynistic authority figure can lower himself," conductor David Stern wrote in his program notes. "No one can argue that today we cannot recognize Scarpia's traits in our contemporary society [...] It is perhaps for this most obvious reason that we still look at Tosca as a comment on the human condition, and not a mere relic of the past."

Stern's commentary is an important one, and one that inspires necessary analysis. "Mia!" Scarpia cries in Act II, "Mine! Yes, I will have you!" He pauses, and offers a smile. "But I won't force you." In a world where consent is so often coerced – Tosca's world, and ours – it's impossible not to draw comparisons to stories of #MeToo, #TimesUp, and a slew of fallen titans. It's easy to imagine Scarpia as a man who might have a [button hidden beneath his desk](https://www.theatlantic.com/entertainment/archive/2017/11/about-that-secret-button-in-matt-lauers-office/547106/) to lock his office door.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1517106004952/8tosca_Bruce_Bennett%5B1%5D.jpg.jpg)
<figcaption>Riccardo Massi (Cavaradossi) and Keri Alkema (Tosca) in *Tosca*, Palm Beach Opera, 2018. Photo: Bruce Bennett.</figcaption>
</figure>

Many opera-goers can likely count on one hand the number of large-scale productions they've seen led by a woman stage director, and those gathered in the Kravis Center for the Performing Arts on Friday night can now add Palm Beach Opera's *Tosca* to that list. Maybe one day we'll see a Floria Tosca who somehow evades arrest for the murder of her rapist, and instead of committing suicide, forges a new life dedicated to resisting the systems that have traumatized and oppressed her. ([Florence's defiant *Carmen*](http://www.telegraph.co.uk/news/2018/01/02/italy-gives-world-famous-opera-carmen-defiant-new-ending-stand/) has certainly set a powerful precedent for reimagining operatic women's inevitable fates.) But for now, a lone soldier removing his hat – Fenlon Lamb's subtle yet not-so-silent tribute to another of opera's fallen women – proves that Floria Tosca's story, and the stories of women past and present who have stood up and raised their voices, are far from over.

>Palm Beach Opera's [Tosca](https://pbopera.org/event/tosca/) continues through January 28. For full details and ticket information, [click here.](https://pbopera.org/event/tosca/)
