+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-01-17T22:15:00+00:00"
lastmod = "2017-01-18T12:49:00+00:00"
preamble = "Stephen Bell is Canadian tenor, and the founder of the Toronto-based web design studio [Coffeeshop Creative](http://www.coffeeshopcreative.ca/). He spends his days helping his clients build their professional websites, and his musical background has a strong niche appeal within the operatic industry. In the evenings, you can catch him onstage at the Four Season Centre, singing with the stellar [Canadian Opera Company](/scene/companies/canadian-opera-company/) Chorus.\n\nWe spoke with Bell about what he offers through Coffeeshop Creative, and how the benefits of being a singer with a second career outweigh any stigma or taboo."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484736345953/2017-01-18---Stephen-Bell.jpg.jpg"
publishDate = "2017-01-18T12:15:00+00:00"
related_articles = ["articles/in-defense-of-the-day-job-.md","articles/singers-heres-what-you-need-to-know-about-your-website.md"]
related_companies = ["scene/companies/canadian-opera-company.md"]
short_description = "&quot;Today more than ever, it is crucial to have as many skills as possible. How can you finance that call-back tour of auditions in NYC if you aren&#039;t working? Want to go and take a 2-week intensive program abroad? Yep, you need cash. That &quot;day job&quot; or second career can allow you have the opportunity of pursuing a career in the arts. In web design, I have found another passion to present my skills as an artist, and I love it!&quot;"
slug = "stephen-bell-singer-by-night-coffeeshop-creative-by-day"
title = "Stephen Bell: singer by night, Coffeeshop Creative by day"
+++

## How has your career as a singer informed what you do with Coffeeshop Creative?

My career as a singer has given me many opportunities of singing with opera companies, and classical music organizations both nationally and internationally. In my musical travels, I have come to develop a deep respect for Canadian talent and work ethic. Singers are entrepreneurs. We all set goals, maintain expectations, deliver results, and hope to maintain lasting relationships with our engagers or clients. This work ethic has carried me not only in performing, but in the creation of the Toronto-based web design start-up, Coffeeshop Creative. 

I work as a developer and lead design with my company in the afternoons, and in the evenings I also sing throughout the year with the [Canadian Opera Company](/scene/companies/canadian-opera-company/) Chorus. I love coffee, and developed the idea of meeting clients in their favourite cafes to create and develop their unique web presence. We want to remove the idea of going to an "office". Cafes creates a unique and relaxing environment for the creative process.

I never went to school for business, admin, or any related entrepreneurial studies field. Instead I graduated with a Bachelors and Masters in Music. Asides from certificate and diploma studies in web design & development, I am self-taught both in both graphic design/development and, crazy to think, business admin.  Its my motivation and work ethic as a singer, that has propelled Coffeeshop Creative from an idea to a registered business in Ontario. 

## In your own experience, what is the industry's perception of a singer with a "day job" or second career?

Ah yes, the dreaded [day-job](/in-defense-of-the-day-job/) or [second career](/chris-mayell-the-opera-career/)! I find this negative stigma of having a secondary source of revenue generation, ridiculous. Yes, you need to focus on your craft of singing and put your “all" into your artistic career, however it is so important to have a secondary source of funding. 

Today more than ever, it is crucial to have as many skills as possible. How can you finance that call-back tour of auditions in NYC if you aren't working? Want to go and take a 2-week intensive program abroad? Yep, you need cash. That "day job" or second career can allow you have the opportunity of pursuing a career in the arts. In web design, I have found another passion to present my skills as an artist, and I love it!  Not only does it allow me to generate income when I am not currently on a singing contract, but it also adds to a unique secondary portfolio of skills. My advice is to find a career you are passionate about, see if it aligns with your time schedule, and performance commitments, and go for it. There is nothing wrong with being a "Jack or Jill of all trades."

## Does a singer really need a website?

Yes, 100%. Today companies and directors have limited time to cast, or search for talent, and an increasingly large field to select from. Why not separate yourself from the group and give yourself a custom website presenting your portfolio as an artist. Everyone in graphic design and development does, so why shouldn't singers? 

All websites for singers should be:

<ul class="nospace">

<li> Easy to navigate - single page scroll/multi paged theme with clean and clear navigation
<li> Mobile-friendly. I can't say this enough: 85% of all websites are now viewed on a mobile device. Make sure your site is mobile-friendly and cross-tested to work on all platforms.
<li> Custom designed. Do yourself a favour: get a custom site which is developed by a designer/developer. The basic online site builders are one dimensional, are all very similar looking, and don't give many options. 
</ul>

Your site needs give a clean and direct path for an engager to contact you. Have it link to a blog you run, or social media group you use to promote your singing. Let it be the landing spot for an engager to contact you for the role you have worked so hard to prepare!

## What advice would you give to young artists who need extra income, but also the flexibility to take auditions and gigs?

There is nothing wrong with finding a secondary passion, especially if additional income is needed. My advice would be to look into the possibility of training in a second career. Freelance professions offer amazing flexibility, are incredibly rewarding, and are often mobile. In my case, I take my office with me wherever I go. Look for a career which works for you, not vice versa. Questions you need to ask yourself might be: What other jobs/careers am I passionate about? Do these align with my performance schedule and can I effectively balance both?

As singers we are multi-talented and multi-taskers. If you have talent or an eye for graphic design, look into colleges or institutions which offer certificates in digital media skills. Do you like business management? Look into a placement course at a local collage in the afternoons. Do you have a mathematical, Stravinsky-like brain? This can be invaluable in learning front-end, or back-end web development coding. Jobs in tech are hot, in demand, and are always worth learning! You might find yourself happier knowing you have that fall back income to allow your dreams of preforming to take flight. Sorry to be the realist here, but dreams cost money, so why not help support dreams with a second vocation?

Above all, don't give it a 76% level of effort - your success in this, is all up to you. I never thought I would be running a business, but here I am, and I am working every day at it. Be dedicated to yourself, and really commit. As a little wise, green Jedi once said, "do or do not, there is no try."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1484736402796/2017-01-18---Coffeeshop.jpg.jpg)
</figure>
