+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-11-26T13:30:00-05:00"
lastmod = "2018-11-28T11:35:00-05:00"
preamble = "Opera Mariposa is ready to unveil its new production of Mozart's [*Così fan tutte*](http://operamariposa.com/schedule), **November 30 to December 8** at Marpole United Church. The Vancouver-based, female-led opera company is bringing Mozart's staple into the 21st century, no small feat for Da Ponte's layered story of deception and dating. \n\nWe spoke with stage director Robin Hahn about her tropical vision for a present-day *Così*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543344259097/sqCosiFanTutte_cast_2_photobyStephanieKo_print.jpg.jpg"
primary_image_credit = "One of two casts of Opera Mariposa's Così fan tutte. Photo: Stephanie Ko."
publishDate = "2018-11-27T08:58:00-05:00"
related_articles = ["articles/cosi-fan-tutte-misogynist-unreasonable.md","articles/chauvinism-cynicism-great-singing-cos-fan-tutte.md"]
related_companies = ["scene/companies/opera-mariposa.md"]
short_description = "&quot;Our production includes a little LGBTQ+ content, as well as a nod to polyamory. Given the way the original sought to challenge the status quo, we felt this is very much in the spirit of the opera. I think the result is still a hilarious, satirical look at relationship stereotypes, and one that all audiences can enjoy!&quot;"
slug = "stay-warm-with-opera-mariposas-tropical-cos-fan-tutte"
title = "Stay warm with Opera Mariposa&#039;s tropical Così fan tutte"
+++

### What is potentially problematic about Mozart's *Così fan tutte*?

Mozart's *Così fan tutte* is a classic of the repertoire, and contains some of the composer's most beautiful music. Nevertheless, the opera is not without its challenges either. Many of the specific tropes and plot devices are products of the time in which they were written, and as with many other period pieces, there are elements that have the potential to seem outdated – or worse, sexist or racist - if not presented in a thoughtful manner.

For me, the goal for Opera Mariposa's production was to allow the opera's spirit to shine through for today's audiences. I don't believe that *Così* is by necessity racist or sexist; in fact, it was very cutting-edge for its time, even feminist in its way. The opera premiered in 1790, in an era where many avenues for creative expression were largely inaccessible for women. Yet operas like *Così* not only starred central female characters, but unabashedly explored their inner lives and centralized their decisions. In *Così* we find a clear message that women in story shouldn't be placed on pedestals or worshipped as abstract ideals. Instead, the opera treats the women as real people with emotions, quirks and flaws - just like the men. 

To me, the most potentially problematic elements of a traditional staging are also the most unnecessary. These days, we can acknowledge that Ferrando and Guglielmo's dressing up "as Albanians" is culturally insensitive; we can also take issue with the sexually aggressive way that their pursuit of Fiordiligi and Dorabella is sometimes staged. Yet both these elements are presented as jokes, and neither is necessary to make the story work. The boys can dress up as pretty much anything, and it's just as hilarious. The girls don't need to be touched against their will or have their personal space invaded in order to make it clear that the boys are courting them.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543256866236/CosiFanTutte_cast_1_photobyKathrynNickford_print.jpg.jpg)
<figcaption>One of two casts of Opera Mariposa's *Così fan tutte*. Photo: Kathryn Nickford.</figcaption>
</figure>

### How will you bring *Così* into the modern age, and still use the source material by Mozart and Da Ponte?

*Così*'s original spirit was forward-thinking and funny, and as I said, we've tried to make our production reflect that. We've updated the opera's setting to the present day, at a private beach resort somewhere warm and tropical. Fiordiligi and Dorabella's getaway includes a tiki bar at the water's edge, lots of colourful cocktails and many a selfie, while the conductor bobs in the ocean directing all the music. In keeping with the setting, Ferrando and Guglielmo disguise themselves as lost tourists. Little touches like that help make the jokes land for contemporary audiences, without changing a word of the libretto or a note of the music.

We're also bringing the opera into the modern age by being unafraid to challenge the worldviews of some of our audience members. In the 19th century, *Così* was seldom performed because its subject matter was considered too scandalous for Victorian sensibilities. Our production includes a little LGBTQ+ content, as well as a nod to polyamory. Given the way the original sought to challenge the status quo, we felt this is very much in the spirit of the opera. I think the result is still a hilarious, satirical look at relationship stereotypes, and one that all audiences can enjoy!

### What does a woman stage director bring to an opera like *Così* that is unique?

More often than not, the reality remains that there are more male operatic directors than female. To me, this opera is at its heart a story about women, so for a modern production it makes sense for women to be at the helm. For everyone at Mariposa (which is a female-run company), it was a priority to make sure the female characters were sympathetic, dynamic and powerful. We wanted the audience to relate to them and see the story through their eyes, rather than viewing them through the judgmental lens of some of the male characters.

To that end, we have added some stage action to help clarify that when the cynical Don Alfonso holds forth on his mistrust of women, he isn't relaying the message of the opera as a whole. Rather, Don Alfonso is speaking from his own personal experience, and his jaded worldview stems from previous hurt. In our production, we actually shift the focus from Don Alfonso and towards Despina the maid, who in our production is a put-upon resort staff member. She speaks directly to the audience, and it's just as much her story to tell as Don Alfonso's.

In the end, I think it's really important that women get to tell our own stories, whether that's Despina, or myself as a director, or Mariposa as a whole. By getting the chance to take charge of our own narrative, women onstage have more room to develop their characters and connect to all the audience members – whatever their gender – in a different way.

### What do you hope audiences will take away from your production of *Così*?

First and foremost, I hope they think it's hilarious! But on top of that, I hope they're able to see this classic opera in a new light. Mariposa is a company created by and for young and emerging artists, and we want to lay to rest the idea that opera is stuffy or outdated. Opera is a living art form, and it can and should reflect the times in which it is performed.

I believe that just as audiences change over the course of a few hundred years, so too must we rethink our approach to the source material. With masterworks such as *Così*, the shifts are very simple, in the end. The opera has excitement, romance, hilarious hijinks and subversive, satirical cultural commentary all built in. Our job as artists is simply to present that to audiences in the best way possible for them to connect to it – to bring them into the story, and to show them a wonderful time while they're there!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543256888312/Cosi_poster_lettersize.jpg.jpg)
</figure>

>Opera Mariposa's production of *Così fan tutte* runs from November 30 to December 8 at Marpole United Church, Vancouver. For details and ticket information, [click here.](http://operamariposa.com/schedule)
