+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = 2020-12-08T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "[_Stardust_](https://heliosopera.com/projects/stardust/) has two more performances, December 11 and 13."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1607196695/media/2020/12/sqSD_1JohndelosSantosKeithBrowning_egyxdw.jpg"
primary_image_credit = "Image: Keith Browning/John de los Santos."
related_articles = []
related_companies = ["scene/companies/helios-opera.md"]
related_people = ["scene/people/felix-jarrar.md", "scene/people/victoria-davis.md"]
short_description = "It is a journey that does evolve over the course of the three songs, and textually speaking it is such an interesting journey I honestly wish there were more songs devoted to it."
slug = "stardust-a-strong-highlight-of-poc-talent"
title = "Stardust a strong highlight of POC talent"
youtube_url = ""

+++
In the wake of Black Lives Matter protests that have sprung up in the wake of George Floyd's death, many spheres of our social lives have had to ask themselves the ways in which they can elevate black voices in what they do. The opera world is no exception, and in particular I have been privy to a bunch of emails from Boston-area opera companies designed to address these issues. Some in the Boston area were already trending towards addressing this with things like [MassOpera](/scene/companies/massopera/)'s workshop for Dan Shore's [_Freedom Ride_](/operatic-journeys-massopera-presents-freedom-ride/), but as always there is still more work to be done, particularly to boost such voices on the creative side in addition to the singing side.

> It is such an interesting journey I honestly wish there were more songs devoted to it.

Cue [Helios Opera](/scene/companies/helios-opera/)’s Modular Opera Project, which in September produced a gut-wrenching filmed performance of Poulenc’s _La voix humaine_. To address this front, they pulled together an all-POC creative team, with music from Brooklyn-based composer [Felix Jarrar](/scene/people/felix-jarrar/) and text from London-based writer B.L. Foxley, to create a world-premiere project to be premiered by black soprano Victoria Davis. Part of the goal was to produce something that elevated these voices, and on this front Helios Opera has certainly succeeded.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1607196711/media/2020/12/SD2crJohndelosSantosKeithBrowning_nipkle.jpg){{% /md %}}

<figcaption>Image: Keith Browning/John de los Santos.</figcaption>

</figure>

The result is [_Stardust_](https://heliosopera.com/projects/stardust/), a song cycle consisting of three songs that explore a journey of self-liberation. As per the brief, it does contain some racial undertones (particularly in the first half, which makes an oblique reference to both lynchings and to the dual nature of how black people are viewed in American and British society), but as it evolves a narrative of self-actuation emerges. It is a journey that does evolve over the course of the three songs, and textually speaking it is such an interesting journey I honestly wish there were more songs devoted to it.

> Jarrar is quite a young composer, and in this work he shows quite a bit of promise.

I also felt that, musically, it took a little bit to get going. The first song, _What Am I?_, had some of the most intense text of the cycle, but I felt it was the least musically interesting of the three songs. Certainly there were good moments, but it felt a little weak as an introduction. Once we get to the sinister second song, however, the music does become substantially more interesting, particularly in the way it broadens out majestically in the last song, Mother Nature. Jarrar is quite a young composer, and in this work he shows quite a bit of promise, particularly as relates to his English prosody and his use of the vocal range: of most particular note is the way Mother Earth lingers joyously at the top of the soprano's range as it reaches its climax, a note that ends the whole cycle on a rather joyful and surprisingly hopeful note, considering how dark and intense the text was until that point.

> I found it quite invigorating, and it was certainly a night at the opera I enjoyed as a whole package.

Realizing a project like this would definitely incur a different approach from _La voix humaine_, and on this front the video direction from John de los Santos and Keith Browning absolutely proved to go in exactly that direction. The video direction opted for an Andy Warhol aesthetic that was all muted primary colors, bright lights, and multiple shots of Victoria Davis' face all cut into a pastiche (and even featuring a double lip sync at one point), and it was an aesthetic that served the songs well. It also tied the text of the three songs into the Greek myth surrounding the fates, with the soprano picking up a spindle of thread at the end of _Who Am I?_, watching the threads unspool in The Devil, and then finally cutting them herself at the end of Mother Earth. The symbolism here was not the usual Fates symbolism that people tend to see (the creators were opting more for an arc where the soprano takes control of her own fate), and once the link was explained I felt it was a very appropriate one for the arc of the piece. And of course, all of it was beautifully sung and acted by Victoria Davis, who navigated the score's prosody with an incredible command of the material and a wonderfully full voice, and communicating quite a lot with facial expressions (important since so much of the video was close-ups of her face.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1607196731/media/2020/12/SD3crJohndelosSantosKeithBrowning_lwm67p.jpg){{% /md %}}

<figcaption>Image: Keith Browning/John de los Santos.</figcaption>

</figure>

Perhaps some things could have been improved upon: I felt that this time around the piano audio had some weak mixing this time around, and as mentioned before I think the cycle could perhaps benefit from some tightening up of the first song and perhaps adding some more content. But overall, _Stardust_ is the mark of a particularly smart approach to following something up: there was no way they would realistically match their _Voix humaine_ by doing the same way, so they opted to pivot in a completely different direction, and in so doing highlight their commitment to uplifting underrepresented voices. I found it quite invigorating, and it was certainly a night at the opera I enjoyed as a whole package.

<figure data-type="image">{{% md %}}{{% /md %}}

<figcaption></figcaption>

</figure>