+++
author = ["authors/oliver-munar.md"]
categories = "Interview"
date = "2018-11-16T10:28:00-05:00"
lastmod = "2018-11-16T10:34:00-05:00"
preamble = "For its first mainstage production of 2018-19, [Calgary Opera](/scene/people/calgary-opera/) has joined forces with Alberta Ballet to produce the classic tale of William Shakespeare's \"star-cross'd lovers\". Charles Gounod's [*Roméo et Juliette*](https://www.calgaryopera.com/18-19/romeo-and-juliette), conducted by Gordon Gerrard, is directed by Jean Grand-Maître, the Artistic Director of Alberta Ballet.\n\nSchmopera contributor Oliver Munar, who is singing in the coproduction, met with director Grand-Maître for a preview."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1546222477/media/2018/12/sqRomeoetJuliette-AnneMarieMacIntosh-AdamLuther-Trudie-Lee-Photography.jpg"
primary_image_credit = "Adam Luther (Romeo) and Anne-Marie MacIntosh (Juliet) in Calgary Opera's production of Roméo et Juliette. Photo: Trudie Lee."
publishDate = "2018-11-16T10:33:00-05:00"
related_articles = ["articles/falstaff-he-saidshe-said.md", "articles/in-review-the-rape-of-lucretia.md"]
related_companies = ["scene/companies/calgary-opera.md"]
related_people = ["scene/people/adam-luther.md", "scene/people/annemarie-macintosh.md"]
short_description = "&quot;I&#039;m glad that Charles Gounod is a French composer because I can understand the opera in my own language. In many ways, Gounod&#039;s score is so far away from the Prokofiev score. Prokofiev&#039;s music is imminently danceable, the chords and harmonizations are rich and original. But Prokofiev&#039;s score is very dark while Gounod infuses a lot of colour, humour and drama.&quot;"
slug = "star-crossd-lovers-cross-artistic-lines-in-new-co-production"
title = "&quot;Star-cross&#039;d lovers&quot; cross artistic lines in new co-production"

+++
### How did this collaboration come about?

**Jean Grand-Maître**: Bob McPhee, the former head of Calgary Opera, invited me to stage this production. We collaborated over the years on different projects and galas and special events and Bob would mention to me that he'd love to invite me to come over and stage an opera. I thought maybe he was just joking and being nice about it but finally one day he was very serious and asked if I would like to stage *Romeo and Juliet*. I said, "Wow, you were serious all along!" and I agreed. I had staged *Romeo and Juliet* for the Quebec City Opera earlier, and I think he felt safe that I was familiar with the story, having staged two different ballets and a musical setting of it.

#### In addition to the production for Quebec City Opera, you've set the music of Joni Mitchell to ballet, and you directed productions of Mozart's *Requiem* featuring ballet dancers. What lessons did you take from those experiences that have applied to this production?

**JGM**: It's been very enriching for me to work with so many different performers -- dancers, actors, singers, acrobats, you name it. Each artistic discipline teaches you so much, you learn how hard people work. As I create my ballets, I like to integrate them and fuse different artforms together so I can discover different ways of thinking and creating.

It was a real refreshing journey for me to create and stage this production. When you're choreographing a ballet you know where dancers breathe, where the drama is going to be, where they can tense and where they can relax. With singers, you have to understand how they breathe and live through a moment or a narrative. Breath is emotion. You have to be able to find the place where the singers are so comfortable, and and they feel that what I'm staging is very organic, with their breath and the music itself.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542382319369/Jean_Grand_Maiitre_DIRECTOR.jpg.jpg)
<figcaption>Jean Grand-Maître, Artistic Director of Alberta Ballet and stage director for Calgary Opera's production of *Roméo et Juliette*.</figcaption>
</figure>

### It sounds like there's a lot that is similar in your approach to the singers for this production as there would be for a ballet production.

**JGM**: Yes, absolutely. For a singer on stage who's doing character development, it's no different than a dancer: you have to inhabit your body. It's not enough to go out there and position your feet and sing to an audience. And how do you inhabit your body in a truthful way that's not contrived, in a process that's believable? I've worked my whole life trying to create productions where the performers - dancers, singers, actors or whoever - can accomplish that.

### Prokofiev's interpretation of *Romeo and Juliet* is well known for ballet lovers. How does Prokofiev’s interpretation compare to Gounod's version?

**JGM**: I'm glad that Charles Gounod is a French composer because I can understand the opera in my own language. In many ways, Gounod's score is so far away from the Prokofiev score. Prokofiev's music is imminently danceable, the chords and harmonizations are rich and original. But Prokofiev's score is very dark while Gounod infuses a lot of colour, humour and drama. Gounod goes directions that Prokofiev does not, because in Gounod you have singing characters, and with a singing character comes a whole world unto itself.

#### What other opportunities do you see as possible co-productions between ballet and opera companies? And going forward, to what extent do you see such collaborations being necessary for the success of both?

**JGM**: I love German opera. It could be interesting that you do a German opera with both the ballet and the opera where some tableaus are danced while others are sung. The works of Richard Strauss and Kurt Weill come to mind. Even the idea of Mozart's *The Magic Flute*, that we create a production where you go and see everything as an opera, and then you see the same production as a ballet.

It's always interesting to see how we can mix audiences, not just the art. Fusion has been going on for a long time but it doesn't mean we are going to burn the masterpieces of the past: you have to respect those masterpieces.

### With such an iconic, well-known story as *Romeo and Juliet*, what do you hope audiences take away from this unique collaborative production?

**JGM**: This story seems even more poignant now than any other time I've staged it in the last 25 years. What Shakespeare basically is talking about is the "we" and "they", and intolerance and fear of what is not "us". In these difficult times, I hope people can leave the theatre remembering how precious a life is, how precious compassion is, and that they can both feel and cherish their own humanity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1542382386085/RomeoetJuliette_Anne-Marie_MacIntosh_Adam_Luther_Photo_by_Trudie_Lee_Photography_balcony.jpg.jpg)
<figcaption>Adam Luther (Romeo) and Anne-Marie MacIntosh (Juliet) in Calgary Opera's production of *Roméo et Juliette*. Photo: Trudie Lee.</figcaption>
</figure>

>Gounod's *Roméo et Juliette* runs November 17, 21 & 23 at the Southern Alberta Jubilee Auditorium. The production stars tenor Adam Luther and soprano Anne-Marie MacIntosh in their role debuts as Romeo and Juliet. For more information, visit [calgaryopera.com](https://www.calgaryopera.com/18-19/romeo-and-juliette).