+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-06-26T18:05:00-06:00"
lastmod = "2015-06-27T10:40:00-06:00"
preamble = "Répétiteurs, rehearsal pianists, the ones who *repeat* sections of music over and over; they're a special breed of pianist, with an insanely focused set of skills. Being a répétiteur is one of those jobs that can feel thankless, where people only notice your playing when you mess up. It's about checking your pianist ego at the door, and facilitating a rehearsal for others: singers, conductors, and directors. It takes a thick skin, and a knowledge of the score that rivals that of the top-billed creative staff. Here are four major parts of doing a tough job like a pro."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435386626891/PIano.jpg.jpg"
publishDate = "2015-06-27T08:30:00-06:00"
related_articles = ["articles/in-defence-of-pianists.md","articles/the-pianists-tech-week-plight.md","articles/how-to-lead-your-pianist.md","articles/potential-orchestra-mutiny-and-conductor-envy.md","articles/pianists-3-tips-for-sounding-like-an-orchestra.md","articles/coaches-voice-teachers-and-the-grey-area-in-between.md","articles/the-opera-pianists-list-o-priorities.md","articles/5-important-roles-who-dont-get-an-aria.md","articles/4-ways-to-give-notes-still-be-liked.md","articles/new-opera-repetiteur.md"]
short_description = "Répétiteurs, rehearsal pianists, the ones who repeat sections of music over and over; they&#039;re a special breed of pianist, with an insanely focused set of skills. Being a répétiteur is one of those jobs that can feel thankless, where people only notice your playing when you mess up. It&#039;s about checking your pianist ego at the door, and facilitating a rehearsal for others: singers, conductors, and directors."
slug = "star-repetiteur-there-is-such-a-thing"
title = "How to be a star répétiteur (yes, there is such a thing)"
+++

### Rhythm

This is absolutely Priority Number One, no questions asked. Pianists will always pay attention to rhythm; they've been trained well to do so. Pianists who have little experience playing with conductors or chamber ensembles actually have *lots* to learn about being accountable for true rhythmic accuracy; when you're playing an orchestral reduction, the task can be another experience altogether.

Playing all the notes of an orchestral reduction is a fruitless endeavour, largely becayse trying to do so affects a your ability to keep tempo. If you've mastered the repeated note technique in order to play *The Barber of Seville*, bravo to you. It's only valuable, though, if all those little notes don't slow you down. It's important for a répétiteur to see the forest for the trees, and remember that the music in front of them wasn't written for the piano. That means a conductor's tempo will be idiomatic to the violins or the flutes or whatever instrument is really playing these passages; it may be too fast for even the best pianist, but no one cares. Your job is to make it work; instead of repeated notes that only come out 50% of the time, settle for an easier figure like broken octaves. It won't be exactly what's written, but frankly, neither is the piano's equal-temperament.

Conversely, remember that almost *every other instrument* in the orchestra is a sustaining one. Strings use bows, winds use air; pianos are the exception in their immediacy of sound, and so it's easy for a pianist to be slightly ahead of the beat or start to rush. It sounds silly, but the solution is imagination. Imagine those few milliseconds it takes for the bow hair to grab the violin string, or for an oboist's air flow to start vibrating the reed. Composers write their music knowing the technical idioms of each instrument, and the répétiteur must imitate this slight delay in sound. It makes for a better representation of the orchestra, and it's more indicative of what the conductor and singers will hear.

### Bass notes trump treble

Some orchestral reductions are just tricky to play. *Der Rosenkavalier*, the quick bits in *La bohème*, even some of those lightning-fast Mozart finales, they're all difficult and un-pianistic for various reasons. Just as the répétiteur will pare down rhythmic challenges in order to keep a steady tempo, the same has to be done with harmony. If there's a section that's crazy fast, or harmonically bizarre, the best use of your practice time is spent finding the large-scale chord progression (think Schenkerian analysis). You may have spent lots of time practicing the flute lines in the *Rosenkav* overture, but those bass notes are worth much more. Again, you'll stay in tempo, but you'll also be delivering clear and relevant information to the singers. They may never hear that flute passage from the stage, but they'll know when they're harmonically grounded.

This is especially valuable when you're sight-reading, or you have to cram an opera score into your head and fingers in a short amount of time. Prioritizing the bass should be your go-to trick for when the tempo is too quick to play everything, but the singers still need support. It's also a great way to avoid tiring your hands during a repetitive staging rehearsal.

### Anticipate rehearsal starting points

This isn't about playing the piano; it's about being a great assistant. Staging rehearsals are lots of stopping and starting, and they're also about great time-management. It usually goes:

1. Talking through the scene
2. Trying it with music
3. Stopping for director notes
4. Picking up the music again at a reasonable place

Répétiteurs are charged with paying close attention during rehearsal; if they don't, the extra time it takes to find the starting measure negates all hope of an efficient rehearsal. Plus, you've done a bad job of the "facilitate rehearsal" job description. I'm not saying répétiteurs need to be telepathic; either the director or conductor will probably call out a bar or rehearsal number, but it's important for the pianist to keep these checkpoints in mind and anticipate when they'll be used again. 

I play a silly game with myself during staging rehearsals, trying to guess where we'll start from. Letter E? Measure 73? I give myself imaginary gold stars whenever I guess correctly. Répétiteurs who get really good at this game are beloved by conductors and directors everywhere; you could be one of them!

### Give singers their notes with context

When the music picks back up in a staging rehearsal, most singers need to be reminded of their starting pitch. I have irrational frustration at the pianist who gives a singer's pitch as a singularity, one lone, out-of-context note that means nothing. Répétiteurs, be kind to the singers who are multi-tasking like fiends. If they're starting *a cappella*, offer them the note in four octaves; it's much easier to hear, because acoustic science. If there's harmony underneath the singer, play the chord as written, then add their note last, and loudly. Staging rehearsals are no time for testing the singer's pitch memory. Just be helpful.

> Pianists, répétiteurs, what are your priorities in rehearsal? Let us know in the comments below!
