+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2017-03-09T18:08:00+01:00"
lastmod = "2017-03-10T11:53:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1489085514742/2017-03-10---Clock.jpg.jpg"
publishDate = "2017-03-10T11:47:00+01:00"
related_articles = ["articles/she-said-they-said-crossed-wires-in-buenos-aires.md"]
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/jonas-kaufmann.md"]
short_description = "With the few exceptions of singers who are stepping back into a production they&#039;ve already rehearsed, with the same cast and conductor, it seems as though companies are willing to offer their audiences a lesser production in favour of having a famous name onstage. And maybe it&#039;s a profitable trade-off. It just feels...not right."
slug = "star-opera-singers-timeefficient-or-just-late-to-rehearsal"
title = "Star opera singers: time-efficient, or just late to rehearsal?"
+++

Though it's decidedly not great timing to pull out of a new production at [the Metropolitan Opera](/scene/companies/the-metropolitan-opera/) mere weeks after it's announced, star tenor [Jonas Kaufmann](/scene/people/jonas-kaufmann/) is one of the fortunate few among opera singers who can afford to do so.

Michael Cooper's [*New York Times* article](https://mobile.nytimes.com/2017/03/08/arts/music/jonas-kaufmann-a-tenor-in-demand-now-in-short-supply.html?smid=tw-share&_r=0&referer=https://t.co/J34mDUDOnm), among other sources, reports that Kaufmann has cleared much of his performance schedule in favour of being able to spend more time with his family (he has three kids). It's a good reason, no doubt. Kaufmann intends to limit his work outside of Europe to no more than two-week chunks of time; productions like the Met's new *Tosca*, from which the tenor withdrew, would call for more commitment than that.

Not every opera singer manages to make choices like Kaufmann's; he worked hard to earn his superstar status, and one of the perks is the chance to find a more even balance between his job and his family.

In Cooper's article, there's one paragraph that stands out:
 
"Rehearsal time can be a stumbling block for booking some stars. Many singers like long rehearsal periods, and directors can never get enough. But for opera's biggest names, long rehearsal periods can take them away from their families and use up time they could spend more profitably by performing elsewhere. At the Met, the top singer's fee is $17,000 a performance, but singers earn far less for rehearsals — only about $2,000 a week, depending on their seniority."
 
There's something wholly irritating about the practice of operatic superstars blowing into the rehearsal room just in time for *Sitzprobe*, or for a few hours of staging refresher at the end of a weeks-long rehearsal process. It's irritating not because singers aren't entitled to make more money, or spend time at home when they can swing it; it just doesn't sit well with us, that the big name singers - the kinds who earn that top fee at the Met - basically skip the real process of creating opera.

We've seen it happen: four weeks of rehearsal with the understudy soprano (or the "second cast" soprano) go smoothly, and cohesive theatre is created. On *Sitz* day, or maybe the first onstage technical rehearsal, the "star" arrives and inserts herself into what's basically an already-finished product. Or rather, they do so to the best of their abilities, given that they've been literally absent for the hours that make opera engaging, instead of demonstrative. Frankly, the results of a production where 80% of the cast were there for rehearsals, and 20% showed up weeks late (and of course, they're always the lead characters), are just not that good. It's not cohesive. It's a shame, visible to the members of the creative team who were there from day one.

With the few exceptions of singers who are stepping back into a production they've already rehearsed, with the same cast and conductor, it seems as though companies are willing to offer their audiences a lesser production in favour of having a famous name onstage. And maybe it's a profitable trade-off. It just feels...not right.

We're not making an example of Kaufmann, to be clear. His two-week limit on extra-European gigs has already meant foregoing productions that demand more time than he can give (the Met has employed fellow fab tenor [Vittorio Grigolo](/scene/people/vittorio-grigolo/) for their new *Tosca*).

But it's a reality that big-name singers can, and do, aim for efficient use of time with their busy schedules; and many companies accommodate them. So the question is: have they earned the right to skip the rehearsal process? Are their big names worth the creative costs? Are we just being sour task-masters?
