+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-11T11:23:00-06:00"
lastmod = "2016-06-19T15:06:00-06:00"
preamble = "American soprano [Sydney Mancasola](/scene/people/sydney-mancasola/) is one of opera's most refreshing rising stars. Already under her belt are enviable roles like Cleopatra in Handel's *Giulio Cesare*, the title role in Massenet's *Manon*, and the heroines in *Les contes d'Hoffmann*; and when it comes to her singing career, she's a strong advocate of following her own instincts. \n\nAs we continue our Spotlight Series, it was a total pleasure to hear Mancasola's passionate, honest thoughts on following one's own path, on singing the truth, and the music that is \"as normal and essential to me as air, water, and food.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465665712089/2016-06-10---Sydney---Hoebermann.jpg.jpg"
primary_image_credit = "Photo by Kristin Hoebermann."
publishDate = "2016-06-18T02:14:00-06:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/talking-with-singers-gregory-kunde.md","articles/spotlight-on-beth-hagerman.md","articles/spotlight-on-stephanie-tritchew.md","articles/spotlight-on-samantha-pickett.md","articles/spotlight-on-shauna-yarnell.md","articles/spotlight-on-naomi-eberhard.md","articles/spotlight-on-shelley-jackson.md"]
related_people = ["scene/people/sydney-mancasola.md"]
short_description = "&quot;It&#039;s probably a bit of dangerous advice, but selfishly, I&#039;d like to see young singers push the limits a little more. Sing the aria you love that no one thinks you should sing, tell your director that you don&#039;t buy the staging they are giving you, give up the big YAP to sing the role of your dreams at a small company. Make the choice that will fulfill you spiritually.&quot;"
slug = "spotlight-on-sydney-mancasola"
title = "Spotlight on: Sydney Mancasola"
+++

## Why do you sing, and why are you doing it professionally?

First of all, I think this is a really awesome question. Like most careers, I think many of us fall into them without asking this question of ourselves very often, and I think for singers especially this can be a constantly evolving discussion. I also think it's super important for young singers just getting started to ask this question of themselves.

I came to singing through my love and deep attachment to classical music. I began playing the violin at age two, so classical music was something that I developed along with so many other essential life skills. I always say it was my first language, and I can't remember my life before it. Classical music is as normal and essential to me as air, water, and food. I've never not had it, so I actually don't know how to live without it. 

At age thirteen, my beloved violin teacher, who had been trained at the Moscow Conservatory and somehow ended up settling in my small rural northern Californian hometown, took his own life. This was a massively pivotal moment for many reasons. First of all I think it was like a 2x4 smacking me on the head telling me to seize every moment of my life, and never take anything for granted, that this life was all we have. Secondly, it was the catalyst for my switch from violin to voice. I couldn't find another violin teacher in my area I wanted to study with, and I had always been a moth to the stage, so I switched my attention to theater, and eventually found my way into opera. The fusion of the two passions was like a light switch for me. It just made sense. 

In a broader sense, I sing because I don't know how to be self expressed without it. I'm not the most self expressed person in other ways in my life. I've always been a bit of an introvert, and I tend to lock up my emotions. Singing gives me an outlet, and permission to feel things. It sounds a bit selfish, but I think it's what everyone needs in order to give back, the thing that sets them on fire. It's how we can best contribute to the greater good. 

## What does "good singing" mean to you? What does it feel like when you achieve it?

I used to think that good singing meant free singing, but now I know that's not enough. One of my conductors used to say "constant intention relieves the throat", (I think it might have been a Ponselle quote). For me, that's the difference between good and great singing actually, when it's full of truth. When I'm watching a singer, and it's not about them or their technique, but rather that their channel is wide open, and the music is flowing through them via their individual attachment to the specific moment in that character's existence. That's when opera has the power to transport. 

## What do young singers need to do more of? What should they do less of?

I feel like I'm the worst person ever to give advice to young singers because I never followed the rules. I've never been someone who can toe the line, and there is no way I would have lasted one year in this business if I had done what was expected of me. It's probably a bit of dangerous advice, but selfishly, I'd like to see young singers push the limits a little more. Sing the aria you love that no one thinks you should sing, tell your director that you don't buy the staging they are giving you, give up the big YAP to sing the role of your dreams at a small company. Make the choice that will fulfill you spiritually. That's not to say you should ever be disrespectful or a bad colleague. That's the last thing this business needs. I just think it's very dangerous when young singers start to feel like they have to be pleasers. It will homogenize opera if everyone does what they are supposed to do. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465665778982/2016-06-10---SDM_Red_Dress_Performance_Kristin_Hoebermann.jpg.jpg)
<figcaption>Photo by Kristin Hoebermann.</figcaption>
</figure>

## Do you have any "bucket list" roles you’d like to sing (realistically or otherwise)?

CARMEN. And in the real world, off the top of my head: Lucia, Juliet, Lulu, Violetta.

I have to say though, some of the roles I've already sung are so juicy that I'd be happy just to continue singing them. This season I got to sing Cleopatra, all the heroines in *Hoffmann*, and Manon. I mean…what else could a girl want, honestly?

## How do you explain your job to non-music folks?

Only singers truly understand the complexity of emotions that we experience when a stranger asks "so what do you do for a living?" I'm not sure if this is because most of us are still surprised ourselves at how our lives have turned out, or because we've been conditioned into a state of dread for the slew of absurd questions that usually follow. 

In all seriousness though, I feel like it's important to be ambassadors for opera in these scenarios. Though not in the way I've usually seen it done. We're not dealing drugs here. We don't have to apologize for having careers that are outside the box, but we also don't need to be opera pushers. I usually explain to people that opera is an acquired taste, that it's not for everyone, but that for me personally, it's blown up my world and given back to me exponentially, the more I've invested in it. Even with my classical music background, sitting through my first opera was a little tough. It takes a while to decode the language of the voice, and I think that's a good message to get out there. 
