+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-19T13:04:00-06:00"
lastmod = "2016-06-21T02:58:00-06:00"
preamble = "From cycling across the east coast of Canada with [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) to taking the more formal stages of [Calgary Opera](/scene/companies/calgary-opera/) and [Opera Theater of Saint Louis](/scene/companies/opera-theatre-of-st-louis/), rising mezzo-soprano [Stephanie Tritchew](/scene/people/stephanie-tritchew/) is a versatile, smart young artist. She's currently mid-run of the world premiere of [*Shalimar the Clown*](https://www.opera-stl.org/season-and-events/productions/shalimar-the-clown), based on the novel by Salman Rushdie (and [she got to meet him](https://twitter.com/StephT_mezzo/status/743310437064728576), to boot!), and next season she'll sing in [Edmonton Opera](/scene/companies/edmonton-opera/)'s production of *Elektra*.\n\nStephanie gave us a totally honest and endearing interview, about the exhaustive mind game that can come with singing, and the freedom she finds from becoming a different person onstage."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466370212045/2016-06-20---Stephanie-Tritchew.jpg.jpg"
publishDate = "2016-06-19T19:24:00-06:00"
related_articles = ["articles/spotlight-on-sydney-mancasola.md","articles/spotlight-on-amanda-majeski.md","articles/spotlight-on-beth-hagerman.md","articles/spotlight-on-samantha-pickett.md","articles/spotlight-on-whitney-mather.md","articles/spotlight-on-shauna-yarnell.md","articles/spotlight-on-geoffrey-penar.md","articles/spotlight-on-naomi-eberhard.md","articles/spotlight-on-vanessa-oudereimerink.md","articles/the-anxious-singer-10-tips-to-help-with-anxiety.md","articles/spotlight-on-chelsea-rus.md","articles/spotlight-on-rihab-chaieb.md","articles/spotlight-on-christina-haldane.md","articles/spotlight-on-lyndsay-promane.md","articles/spotlight-on-alice-privett.md","articles/talking-with-singers-charlotte-mundy.md"]
related_companies = ["scene/companies/opera-theatre-of-st-louis.md","scene/companies/calgary-opera.md"]
related_people = ["scene/people/stephanie-tritchew.md"]
short_description = "&quot;Why am I doing it professionally? That&#039;s easy: because I&#039;m lucky enough to have that opportunity. If I wasn&#039;t doing it professionally, I&#039;d be doing it for fun. I think if anyone could do their absolute favourite thing on the planet and get paid for doing it, they would every time.&quot;"
slug = "spotlight-on-stephanie-tritchew"
title = "Spotlight on: Stephanie Tritchew"
+++

## Why do you sing, and why are you doing it professionally?

I sing for about 100 reasons, but I guess the biggest one is because singing is so helpful to me. As a sort of shy person, I have trouble communicating with people I don't know well in an honest way; I'm constantly keeping myself in check and looking to others for social cues. Right now, I'm at a program in the States. I've been here for over 7 weeks now and I have just started to initiate conversations with people that go beyond "Hi, how are you? I like your shirt."

I digress.

I sing because it helps me communicate. Because I can put on a costume and wear a wig and with the magic of the theatre I'm not Steph Tritchew anymore. And the more honest you are in performance, the more you're able to communicate to your colleagues on stage and the audience. You can communicate real emotion through music and you can make someone (or yourself) feel emotions that you might not allow yourself to feel, otherwise. I was having a hard time earlier this year and sat in a practice room and sang through a song cycle, and by sang, I mean wept. Music is awesome because it can help you process your feelings in a very visceral way like that.

Anyways, I also sing because performing pushes you out of your comfort zone in the best way. After 3 weeks in the States, I could barely sit down and say hello to a group of people at lunch but I had absolutely no problem putting on a cape and wig and completely invading their personal space on stage — because on stage I was a witch in Macbeth and not a shy singer from a different country.

And why am I doing it professionally? That's easy: because I'm lucky enough to have that opportunity. If I wasn't doing it professionally, I'd be doing it for fun. I think if anyone could do their absolute favourite thing on the planet and get paid for doing it, they would every time.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466372716727/2016-06-29---Tritchew-Silent-Night-CalOP.jpg.jpg)
<figcaption>Tritchew in Calgary Opera's *Silent Night*.</figcaption>
</figure>

## What does "good singing" mean to you? What does it feel like when you achieve it?

I'll let you know when I’ve experienced it. Next question, please…

Am I right, though?!

To me, "good singing" is when your mind and body just lock in and work together. It’s when your brain is quiet and thinking about character, state of being, and intention and NOT "oh my gosh why do I have so much phlegm right now" and "I wish this room was better to sing in" and "I can’t feel my support or soft palate." My teachers use words like "allow" and "trust" in my lessons and I think that’s exactly right. Science is awesome and the human body is awesome and perfect and it knows exactly what to do. 

We’ve all had those teachers that are like "Just breathe, open your mouth and sing" and we’re all like "lol, good one—excuse me while I hold my hand against my jaw and my other hand on my stomach and bend my knees and find my yawning place" but I think they're maybe right! Because we've all had those times when we're sort of drained and go into a big room and just stand there instead of making sure that we're planted and grounded, and just take a breath instead of making sure we're taking a good breath, and just let the voice be where it wants to be instead of trying to find your best resonance-crap-where-does-my-tongue-need-to-go-for-[i]-again. 

And when you experience mental quietness and actually allow your body to do what it naturally does, your voice just feels free. And when your voice is free, you can sing naturally without thinking about singing and your thoughts can be focused on text, character, intention, etc. When the stars align and your mind and body decide to be friends for that short time, that's when (I think) you've found "good singing."

Every time I've been in a lesson where my teacher says "THAT. THAT’S IT! What did that feel like? What was that sensation?", I can’t help but smile because my answer is always "It felt like absolutely nothing."

## What do young singers need to do more of? What should they do less of?”

That’s really hard to say because everyone is so different!

I think young singers in general should make sure they invest time and energy into things other than music. Don't get me wrong, it's important to be disciplined and self-motivated and curious and eager and all of the wonderful traits that helps a young student become a great musician; but when your education, hobby, extra-curricular, and career are the same thing, it's enough to drive anyone crazy. 

I think it’s particularly hard for musicians because we so often surround ourselves with musician friends and go to summer programs and we date musicians, etc, etc. And why wouldn't you? We all have this beautiful thing in common; we understand the joys and struggles of learning our craft, the opera anxiety nightmares and the emotional roller-coaster of figuring out (read: stressing about) technique. 

The problem with this is that people can become so obsessed with singing and they lose sight of other things that are so important — like family, friendships, cooking, reading, travel, etc. The happiest singers I know find meaning in things other than just singing and make memories elsewhere. So next time you're at a musician-filled party and you all gather around the computer and start to share videos of "tenor-fails", do the following:

1. Type into the search bar "20th century fox flute" and enjoy a 30 second laugh.
2. Refill your drink.
3. Turn off the computer and play an hilarious game of 'Celebrity' with your friends — I promise you it’ll be more fun than the "tenor fails." 

I think I have the same answer as almost anyone else when it comes to what young singers (or all singers) should do less of: stop comparing yourself to other singers.

Seriously. Just don't do it. You're only making yourself miserable. We all do it and no good comes of it. It doesn’t matter how old you are and how many gigs you've had or "this singer got into this program at this age." You are your own person and you have your own unique and exciting journey ahead. Love yourself for being brave enough to choose this crazy career and feel excited and empowered because you never know what's coming next. It doesn’t matter what anyone else's path has in store — you do you.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466372761900/2016-06-20-Tritchew-Die-Tote-Stadt-203.jpg.jpg)
<figcaption>Tritchew (centre) in Calgary Opera's *Die tote Stadt*.</figcaption>
</figure>

## Do you have any bucket-list roles you would like to sing (realistically or otherwise)?

So many. I feel like every role is a bucket list role. I would love to sing Rosina, Cenerentola, Cendrillon, Sesto, Ariodante. I would say my absolute "bucket-list" role that I would love to sing when my voice is ready in a few years is Sister Helen Prejean from *Dead Man Walking* by Heggie. As for a role I'm crazy about and wish I could sing but probably won’t ever have the chance: Blanche from *Dialogues des Carmélites*.

## How do you explain your job to non-music folks?

I don't think I’ve ever had to explain it, really. When people ask what I do and I tell them I'm an opera singer, I usually get, "Seriously?! That’s so cool." Sometimes people will ask specific questions about how I got into it or they'll ask me if it's hard or if there's any money in it and I always try to answer to the best of my ability!
