+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-07-13T16:27:00+02:00"
lastmod = "2017-03-07T10:51:00+01:00"
preamble = "After singing Musetta with [Opernhaus Zürich](/scene/companies/opernhaus-zurich/) in 2015, American soprano [Shelley Jackson](/scene/people/shelley-jackson/) is currently in Salzburg, to take on that **other** great role in *La bohème*, Mimì, with the Salzburg Landestheater. She'll soon head to Hampshire, UK, to sing Micaëla at the Grange Festival Opera's production of *Carmen*. As part of our Spotlight series, Jackson chats with us about the importance of language skills, about trusting her instincts, and about learning to foster \"the most complex relationship you will have.\""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1468420917140/2016-07-13---Shelley-Jackson---Hoebermann.jpg.jpg"
primary_image_credit = "Photo: Kristin Hoebermann"
publishDate = "2016-07-15T17:50:00+02:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/spotlight-on-sydney-mancasola.md","articles/spotlight-on-beth-hagerman.md","articles/spotlight-on-musa-ngqungwana.md","articles/talking-with-singers-hailey-clark.md"]
related_companies = ["scene/companies/opernhaus-zurich.md","scene/companies/the-santa-fe-opera.md"]
related_people = ["scene/people/shelley-jackson.md"]
short_description = "&quot;Trust your instincts, combined with these few people you trust. At the end, it is you getting up onstage, and you alone are responsible for working out your issues. Feed your person, love your life and live it fully, and that will be all come out onstage.&quot;"
slug = "spotlight-on-shelley-jackson"
title = "Spotlight on: Shelley Jackson"
+++

## Why do you sing, and why are you doing it professionally?

This is a terrific question - it is very very simple, but it took me some thinking to answer in a way I thought would do it justice.

I am singing because music is how I make sense of the world around me. It's been that way since I was young, and I started with classical piano. I wanted to be a pianist very badly, but never really had the right teaching, or probably the patience! I was a very introverted, serious, home schooled kid, and sitting for hours banging out Beethoven was my quiet form of rebellion. A couple years later I joined a theater troupe, and discovered a well a whole different side of myself that could turn into a different person onstage. 

All this to say - I am still very serious and introverted as an adult, and I still feel my truest self onstage making music. At the risk of sounding cheesy, making music is how I feel closest to something bigger than us, to the divine. It's a well known piece of advice that if you can do anything with your life other than music, you should do it. Maybe many people wouldn't admit it, but it is a question I still struggle with. We are terribly lucky to do something we love everyday, but it also involves a huge amount of work, sacrifice, uncertainty, and self examination. And it doesn't get any easier the further you go, only the types of work and sacrifice change. 

My grandmother used to say that she knew she wanted to marry my grandfather because of all her other dates, she kept comparing them, and none measured up to him. I periodically pose myself this question with singing and I get the same answer - nothing else compares!

## What does "good singing" mean to you? What does it feel like when you achieve it?

In a technical sense, I feel that I am singing well when my breath is causing and connected to my sound, and I can guide it to do anything I feel expressively in the moment. It's a wonderful feeling of abandon but complete control at the same time - and there's always something a bit mystical about it. We each have our own map to get there - and it's constantly morphing as you gain experience and get to know yourself better. 

As a lyric soprano, we have the amazing opportunity to sing music that comes from your very core, with love and warmth. I always try to create my sound first from inside my body, then with awareness of what is happening in the larynx and vocal apparatus. When I feel that everything is functioning in tandem, then I can really let go - although sometimes it happens the other way around! 

It took me longer than some to fall in love with my voice - with the physical sensation of making sound. In order to wake up every morning and work out its issues, you really have to love your voice - it is the most complex relationship you will have. 

I was very lucky to hear lots of wonderful singers in Zürich during the past two years, and it is quite a small theater. People say that a well produced operatic sound can alleviate chronic pain or depression, among other things, and I fully believe that! To hear those kind of vibrations from up close - it's incredibly thrilling. That's why people come to the opera. 

## What do young singers need to do more of? What should they do less of?

Languages! I know this is another well used piece of advice, but I can't emphasize enough its importance, both for singing and for communication in our nomadic lifestyle. While living in Europe, I used all of the three major languages almost every day, and it gives a great impression as a North American. 

I also believe a good handle on technique early on is very important. I don't think our system of one hour of voice lessons a week is enough. After undergrad I realized it needed some extra attention for me, so I moved to Italy and spent two years with Mirella Freni just working on my voice. Combined with my wonderful teacher in DC spending hours singing and talking, I started to find my way. Those close relationships will see you through lots of trials, and are extremely important to cultivate. 

The final point I would make, is to above all trust your instincts, combined with these few people you trust. At the end, it is you getting up onstage, and you alone are responsible for working out your issues. Feed your person, love your life and live it fully, and that will be all come out onstage. 

## Do you have any "bucket list" roles you’d like to sing (realistically or otherwise)?

I have so many! I love inhabiting characters- the ability to become someone else for a bit. I've been very fortunate to already have a crack at some of them - Violetta, Tatyana, Juliette, Susannah. 

Most of my dream roles I will have to wait a while to sing - Anna Bolena, Norma, Elisabetta from *Don Carlo*, Leonora, Tosca. I am really drawn to these strong, intense characters, as well as the vocal challenge, and something about the bel canto style seems to fit me. I would also absolutely love to sing all of the Isabella Colbran Rossini repertoire - especially Armida. I've always had easy coloratura, and I keep bringing off the beaten path Rossini seria arias to auditions in the hope that someone will take the hint!

If I could be any other voice type it would most definitely be a Verdi baritone. Verdi is my desert island opera composer and some of his most psychologically complex characters are baritones - Rigoletto or Iago for example. It doesn't get much better than "Cortigiani"!

## How do you explain your job to non-music folks?

I actually haven't had to do this in a while! Inevitably, you will get asked if you are like *insert popera singer of the moment.* In this case, I usually explain that we are different because we sing without microphones, and that we perform in complete works of theater. This usually leads to questions of how we sing without microphones, or the plots of famous operas, which I think is a much more interesting conversation than why crossover stars aren't real opera singers. 

Ultimately, we are so lucky to be able to what we do. It's a choice you have to keep making every day, but who wouldn't choose to do what they love? To spend their time pursuing their passion and hopefully making the world a bit better at the same - that's pretty easy to understand! 
