+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-10-04T18:05:00-04:00"
lastmod = "2015-10-05T08:34:00-04:00"
preamble = "Canadian soprano [Sara Schabas](/scene/people/sara-schabas/) has learned, in her still-young career, how much singing can mean to an audience. She knows that it takes more than technique to move listeners, and she knows that her work is valuable on stages of all sizes and shapes. Sara sings to give back, bringing music to patients in hospitals and care facilities through charities like [Songs By Heart](http://www.songsbyheart.org/about.html) and [Sharing Notes](http://www.sharing-notes.org/). She's also got the stuff for the big stage, taking on roles like Susanna, Lauretta, and Papagena in Canada and the United States. Sara talks about her love of French composers, and how living a diverse life makes her an engaging singer.\n\nThis interview is part of our ongoing series of features on young working artists in the opera industry. If you think you'd be a great candidate for an interview, or know someone you'd like to nominate, get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443996471606/SaraSquare.jpg.jpg"
primary_image_credit = "Photo: Kristen Miccoli"
publishDate = "2015-10-05T08:00:00-04:00"
related_articles = ["articles/spotlight-on-lida-szkwarek.md","articles/spotlight-on-emily-peragine.md","articles/spotlight-on-charlotte-knight.md","articles/spotlight-on-william-ford.md","articles/spotlight-on-keith-lam.md","articles/spotlight-on-laurelle-jade-froese.md","articles/spotlight-on-marjorie-maltais.md","articles/spotlight-on-michelle-siemens.md","articles/spotlight-on-cairan-ryan.md","articles/spotlight-on-christopher-james-ray.md","articles/heggies-holocaust-operas-see-canadian-premiere.md"]
related_companies = ["scene/companies/opera-on-the-avalon.md","scene/companies/dayton-opera.md"]
related_people = ["scene/people/sara-schabas.md"]
short_description = "Canadian soprano Sara Schabas has learned, in her still-young career, how much singing can mean to an audience. She knows that it takes more than technique to move listeners, and she knows that her work is valuable on stages of all sizes and shapes. Sara sings to give back, bringing music to patients in hospitals and care facilities through charities like Songs By Heart and Sharing Notes. "
slug = "spotlight-on-sara-schabas"
title = "Spotlight on: Sara Schabas"
+++

### 1. Why do you sing, and why are you pursuing it professionally?

Music has been my way of expressing myself since I was a small child. When I sing, I find relief emotionally, artistically and intellectually, and I love seeing how that relief can be shared with audiences and my fellow performers. 

While I was living in Chicago, I sang with two charities, one which brought free performances to patients in hospitals ([Sharing Notes](http://www.sharing-notes.org/)) and one that brought music to people living with Alzheimer’s and memory loss ([Songs By Heart](http://www.songsbyheart.org/)). When I sang with these charities, I truly felt the impact my singing can make in peoples’ lives, as people would thank me with tears rolling down their cheeks.

When I sing opera and art songs in a professional context, it’s that visceral expression of music brought to a whole other level. The richness of the music, texts, characters, plus all the incredible art and movement and costuming that goes into opera, combined with the ability to make like-minded friends in every cast, see the world and have a blast creating something so far from the everyday...I can’t think of anything I’d rather do! 

### 2. What does "good singing" mean to you? What does it feel like when you achieve it?

When I’m singing well, it generally means I’m singing with a full body engagement (heart, body, soul) that comes from a deep connection to what I’m singing. I get swept up in the music and character and all of a sudden phrases feel way less long and I start singing from my heart and forget about all the technical things I worry about in the practise room. It’s sorta magical. :) 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443996694042/Schabas.jpg.jpg)
<figcaption>Photo by Kristen Miccoli.</figcaption>
</figure>

### 3. What do young singers need to do more of? What should they do less of?

I think it’s so important for young singers to have interests and curiosities outside of singing, as well as a strong sense of why we do what we do. Our repertoire is so rich and varied that it can often take a person with a real curiosity and zest for life to bring it to life in a way that does justice to the composer and librettist and can fully engage the audience. Obviously having a gorgeous voice and having great technique is vital, but after all that work in the practise room is done, it’s important to get out into the world and have diverse experiences and meet all types of people. I’m a big bookworm and I find that reading about exotic places and characters can really help me connect to different pieces and roles.

I think everyone has said the same thing about what singers should do less of - comparing oneself to other singers. I think the best way to do this is to have a strong sense of your own unique artistic voice and understanding that everyone takes their own path. A clarinetist said something which resonated with me the other day as people discussed the difficulties of pursuing a career in music. He said, “Well, make sure you enjoy it. It’s way too hard a field if you’re not enjoying it!”

### 4. Do you have a "bucket-list" role that you'd like to sing? Why?

I would love to sing the role of Mélisande in *Pelléas et Mélisande* one day. I have adored Debussy and the sensibility of French music ever since I first started taking voice lessons and my teacher gave me "Au bord de l’eau" by Gabriel Fauré to learn. Debussy’s music is so colourful and otherworldly… I’d love to take on that mysterious character and bathe myself in all those rich images and harmonies. :)

### 5. How do you explain your job to non-music folks?

I tell people I’m an opera singer (cue: shock and disbelief), meaning that I largely sing Western art (ie. classical) music. I tell them that aside from the wonderful times I’m on stage in beautiful costumes with lighting, sets and orchestra, I spend a lot of time auditioning (Greyhound buses and all!), applying for different programs, working on my languages, exercising, singing in churches, putting on performances in schools for little kids, learning roles and songs and of course, practising. Oh, and that I sing high notes all day. That’s my basic answer.
