+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-19T15:38:00-06:00"
lastmod = "2016-06-21T10:15:00-06:00"
preamble = "Soprano [Samantha Pickett](/scene/people/samantha-pickett/) has a dramatic voice, a crackling energy about her work, and a wise attitude about the larger-than-life world of opera. We first met Samantha at The Banff Centre in 2015, where she sang the role of Anna in James Rolfe and Anna Chatterton's *Crush*, and she recently joined the very busy chorus for [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/)'s *AtG's Messiah* at Toronto's Harbourfront Centre Theatre. This fall, she'll join the [Canadian Opera Company](/scene/companies/canadian-opera-company/)'s Ensemble Studio for the 2016/17 season, and she's also the founder of [The Emerging Project](http://www.theemergingproject.com/), a \"a source of contemplation, inspiration & information for the up & coming international opera community.\"\n\nSamantha chats about finding the zen in singing, and tenor envy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466372509758/2016-06-20---PickettHeadshot.jpg.jpg"
primary_image_credit = "Photo by Cornelia Climek"
publishDate = "2016-06-21T02:57:00-06:00"
related_articles = ["articles/spotlight-on-stephanie-tritchew.md","articles/spotlight-on-sydney-mancasola.md","articles/talking-with-singers-jamie-barton.md","articles/dont-you-deserve-a-little-spotlight.md","articles/talking-with-singers-samantha-pickett.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/canadian-opera-company-ensemble-studio.md"]
related_people = ["scene/people/samantha-pickett.md"]
short_description = "&quot;The actual concept of opera is quite simple: Remember all of those angst-laden journal entries, love letters and hyper-realistic hormone-induced dreams you would have as a teenager? Imagine if those came to life, accompanied by the most glorious soundtrack you can fathom. That&#039;s opera.&quot;"
slug = "spotlight-on-samantha-pickett"
title = "Spotlight on: Samantha Pickett"
+++

## Why do you sing, and why are you doing it professionally?

I was a particularly loud, attention-seeking and imaginative child. My parents simply put me in music and dance lessons to channel these character traits in a more, shall we say, productive manner. When I think back to my childhood, my memories are filled with recitals and performances of all types, thus my journey to the professional stage has been a natural progression. To put it simply, I sing because I must. Singing allows me to express my own understanding of the world and its many complex inhabitants. I hope to bring the beauty of operatic narrative to as many people as I possibly can!

## What does "good singing" mean to you? What does it feel like when you achieve it

I believe good singing is the by-product of physical, mental, technical and musical preparation, an intimate understanding of your breath, and an unbridled commitment to the present moment. As an audience member, good singing is bewitching; when I hear a voice that is struggling, I often am distracted by my own diagnosing and speculating. As a singer, good singing is invigorating, and kind of zen. You start to lose track of the analytical voice in your head, because you are so generously committed to the present moment.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466372590725/2016-06-20---PickettCentreStage.jpg.jpg)
<figcaption>Pickett at the Canadian Opera Company's *Centre Stage*, 2015. Photo by Michael Cooper.</figcaption>
</figure>

## What do young singers need to do more of? What should they do less of?

Young singers need to do as much sight reading, ear training and instrumental lessons of some variety as soon as they possibly can! Learning and practicing piano is most beneficial, but learning how other instruments work will give you boundless appreciation for your voice, and make you an infinitely more intelligent musician. You become a more dynamic and desirable colleague and employee the better you know how to prepare a score, and its saves you money in coaching. It's tedious, but worth it!

Young singers need to spend much less energy on their psychic abilities. By that I mean we should spend less time worrying about what we are going to sound like, what our eventual repertoire or *fach* will be, and what we think the audition panelists want to hear. We have so little control over who will be interested in our voices and for what reasons, so do yourself a favor and don't add to the list of 'things beyond your control.' 

## Do you have any "bucket list" roles you’d like to sing (realistically or otherwise)?

Ellen Orford in *Peter Grimes*, Lady Macbeth in Verdi's *Macbeth*, Isolde in *Tristan und Isolde*, Judith in *Bluebeard's Castle*, Samuel Barber's Vanessa. I would love to sing Manon and Violetta, but I don't think those roles are in the cards for me. Of the other voice types, I have serious tenor envy. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466372642669/2016-06-20---PickettSchicchi.jpg.jpg)
<figcaption>Pickett as La Ciesca in Opera McGill's *Gianni Schicchi*, 2015. Photo: Tam Lan Truong.</figcaption>
</figure>

## How do you explain your job to non-music folks?

The actual concept of opera is quite simple: Remember all of those angst-laden journal entries, love letters and hyper-realistic hormone-induced dreams you would have as a teenager? Imagine if those came to life, accompanied by the most glorious soundtrack you can fathom. That's opera.

Being an opera singer is a bit of a cross between a travelling salesperson and drag queen. There's lots of loud and rambunctious gesticulating, travelling, a harshly geometric/paint-by-numbers-style makeup application process, small flurries of work at a time, an onslaught of rejection and failure, and a hell of a lot of nerve and beauty (inside and out!). 
