+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-11T17:03:00-02:30"
lastmod = "2016-10-14T19:27:00-02:30"
preamble = "New Brunswick-born tenor [Owen McCausland](/scene/people/owen-mccausland/) is back at the [Canadian Opera Company](/scene/companies/canadian-opera-company/), to sing opposite [Alice Coote](/talking-with-singers-alice-coote/) and [Jane Archibald](/scene/people/jane-archibald/) in Richard Jones's production of [*Ariodante*](http://www.coc.ca/PerformancesAndTickets/1617Season/Ariodante.aspx). Amid the busy countdown to opening night on [October 16](http://www.coc.ca/PerformancesAndTickets/1617Season/Ariodante.aspx), McCausland gave a thoughtful interview about his fascination with the power of the voice, and the disciplined approach he takes to his time in the practice room."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476214361971/2016-10-12---Owen-McCausland.jpg.jpg"
primary_image_credit = "Photo by Emily Ding."
publishDate = "2016-10-13T10:09:00-02:30"
related_articles = ["articles/ariodante-or-the-hebridean-handel.md","articles/talking-with-singers-gyula-nagy.md","articles/talking-with-singers-daniel-okulitch.md","articles/talking-with-singers-saimir-pirgu.md","articles/a-week-in-the-amphitheatre.md","articles/never-black-white-abduction-at-the-coc.md"]
short_description = "&quot;Get used to listening to yourself. That recording of your last - lesson/coaching/recital/opera has important information and it will help you move forward. Video is even better. It can be hard, especially at first, but it will highlight the things you can’t hear and also help you forgive yourself for dumb mistakes.&quot;"
slug = "spotlight-on-owen-mccausland"
title = "Spotlight on: Owen McCausland"
+++

## Why do you sing, and why are you doing it professionally?

I think the capabilities of the voice and the art of singing are truly fascinating. Professional singing presents an ongoing challenge with an evolving instrument as well as constant new demands in repertoire. This unique journey has become my passion and I really enjoy the work that is done off-stage.

## What does "good singing" mean to you? What does it feel like when you achieve it?

I think that truly great singers demonstrate an understanding of their own instrument that makes what they're doing seem effortless. While this is what appears to be the result, it is actually an intricate understanding of the boundaries of their voice and the smallest amount of effort needed to produce a healthy sound in each register. 

One of the most profound things about singing is its ability to draw on a listener's empathetic emotion. It is a fundamental part of our nature to empathize with the voice - say if someone is yelling or a baby is crying - we perk up and pay attention. Great singers can capitalize on these instincts by inflecting the drama in the timbre of their tone. It adds a heightened awareness of the words that are being sung which keeps the listener fully engaged. 

I think for me, "good singing" is the result of a lot of preparation. When you know your piece or role extremely well you are able to let go of the score and really focus on communicating the text. Then there is the practice of training the work into your body so it is current and consistent. If you are healthy and in good vocal shape, there is a point where the voice warms and opens naturally and this is quite gratifying for the singer. 

## What do young singers need to do more of? What should they do less of?

More:

<ul class="nospace">

<li>Young singers need to treat their practice time as a scarce commodity. You only get 1-3 hours of time in a day where you can sing full out and really work. Often this time is hindered by whatever project/production you are involved in, which makes quality personal practice time even more rare. Its important to make it count and prepare for your own practice.  
<li>Having a solid warm-up/stretching routine (in which you fully understand each component) is paramount in the progress of your technique and also for your own relationship with your instrument. 
<li>Get used to listening to yourself. That recording of your last - lesson/coaching/recital/opera has important information and it will help you move forward. Video is even better. It can be hard, especially at first, but it will highlight the things you can’t hear and also help you forgive yourself for dumb mistakes. There's no need to obsess over it, but it is truly an invaluable tool when you are learning.

</ul>

Less:

<ul class="nospace">

<li>Comparing yourself to others. This is a waste of time/energy and would be much better focused on your own practice. 
<li>Less trash talking other singers/teachers/conductors/musicians. Everyone is guilty of this at some point, but the reality is this: you have no clue what that person is going through in their life. People have family members who are ill, financial crisis, newborns etc. Performing is stressful and life is stressful. If you haven’t had the, "what the f\*%$ am I doing with my life? why am I doing this to myself?" breakdown yet, you should probably save up some karma for when it happens. 
<li>Don't only aim to make the biggest sound or have the biggest voice. Strive for efficiency and beauty of tone. 

</ul>

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

Who knows what the future holds but some of my favourites are: Romeo, Faust, Hoffmann, Calaf, Rudolfo, Cavaradossi, Manrico, Don Carlo, Canio, Don Alvaro, Otello, Peter Grimes, Herod, and Lohengrin.

## How do you explain your job to non-music folks?

I've run into countless people who've never seen an opera. I try and give them a scope of what opera actually is and the demands of the job. Many people don’t know that opera isn't normally amplified. Some folks don’t understand the difference between "popera" and real opera performing which I do my best to clarify. Sometimes I'll give them a brief overview of vocal fachs - the types of voices involved in opera. Depending on how long they'll let me rant, I’ll sometimes talk about the athleticism and self discipline involved in singing. 

I think it is really important to tell people how opera is now more accessible and affordable then ever. It is now often much cheaper then hockey tickets or baseball tickets. There are hundreds of years of music history to explore and now with the internet, a lot of it is at your fingertips. 
