+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-29T16:59:00-06:00"
lastmod = "2016-07-02T08:59:00-06:00"
preamble = "Young dramatic soprano [Naomi Eberhard](/scene/people/naomi-eberhard/) stays busy with enviable roles like Musetta, Norma, Fiordiligi, Giorgetta (*Il tabarro*), and the title role in Verdi's *Luisa Miller*. Looking ahead to future seasons spent with more Verdi, Strauss, and Wagner, Naomi heads next week to New York as a finalist for the Elizabeth Connell Prize for Aspiring Dramatic Sopranos.\n\nShe gave us a compelling interview about the sacrifice of stability to pursue her career, and the value of experiencing life outside of singing."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1467241129462/2J7LO8w41bwT_yQfsNyUGASam0v2jq7I8Dp3eIXBghNBK3kUgYJq_kF2MGytRisbrQG4nwgNCozMnjpR5JMzG80_ktWoPw%3Dw1360-h1360"
publishDate = "2016-06-30T18:58:00-06:00"
related_articles = ["articles/spotlight-on-stephanie-tritchew.md","articles/spotlight-on-beth-hagerman.md","articles/spotlight-on-sydney-mancasola.md"]
related_people = ["scene/people/naomi-eberhard.md"]
short_description = "&quot;Good singing is an honest, unobstructed release of beauty.  Our body is our instrument.  It must be healthy and in tune constantly.  We must sing sincerely and only with a technique that we know is correct for us.  Do not sing in a way that does not feel right, just because someone tells you it is the &#039;right&#039; way to sing.&quot;"
slug = "spotlight-on-naomi-eberhard"
title = "Spotlight on: Naomi Eberhard"
+++

## Why do you sing, and why are you doing it professionally?

Everything in my life has led me to singing.  To be brief:  I love language, I love art, I love culture, I love travel, I love history, I adore opera, I love people, I love sharing, I love communicating and story telling and I become physically ill when I do not sing.  If I can make a living doing all these things professionally, it would be rather foolish of me not to attempt it.

## What does "good singing" mean to you? What does it feel like when you achieve it?

Good singing is an honest, unobstructed release of beauty.  Our body is our instrument.  It must be healthy and in tune constantly.  We must sing sincerely and only with a technique that we know is correct for us.  Do not sing in a way that does not feel right, just because someone tells you it is the "right" way to sing.  If you can’t figure out how you should sing, be patient, journal, experiment, travel, listen to yourself, find ears that you trust, find great mentors and then find the right teacher for you.  Own your technique despite disparity and disagreement.  Healthy singing, never, ever hurts and should have longevity.  I know I am singing well when I can sing a difficult role, without tiring.  When my sound is clear, unimpeded and yet full of colour and texture.  When I am able to fully connect to a character and the music without allowing my mechanism to be inhibited.  I know I am singing well when combined with all of these things, I forget about singing and purely connect.  This is the best singing to me.

## What do young singers need to do more of? What should they do less of?

Singing to me is an exposition of life skills; a culmination of knowledge and experiences that an individual life has collected and chooses to share.  This is one of the reasons we love to experience singers nearing the end of their careers, even if their technique is what society would consider "less than perfect".  The many years of study and struggle, art and acrobatics, language, culture and stretching and strengthening of the soul, moves us in a way no eighteen year old can conceivably approach.  On the other hand, the naïveté and innocence a young singer’s fresh creativity brings to a performance is invigorating and inspiring to both listener and fellow performer alike.

So my advice to young singers is this:  Go and experience life to the extreme.  Dive head first into every experience.  Document every moment in your memory bank of existence, and be prepared to pull it to the surface at a moment’s notice.  Learn with fluency a minimum of four languages, study at a basic level even more than that.  Travel the world as far as your hard-earned money will take you.  Be patient with yourself. Immerse yourself into situations that make you uncomfortable and push yourself to try things you never thought you would do.  Meet every kind of person imaginable.  People-watch even if it seems creepy, you can learn a majority of acting skills just from observing the lives of others. Hone your people skills.  

Go to museums.  Study movement, dance, art.  Learn about all of history.  Take non-singing music courses.  Take up non-singing related hobbies.  Work in customer service.  Did I say be patient with yourself? See beauty in every day life.  Develop an incredible sense of humour.  Stay humble.  Despite being on a stage in front of thousands of people, you are no more important than the faces paying money to see you, you just ended up being the lucky one and that does not make you special.  Remember where you came from.  Love completely.  When you know who you are, you will truly know your voice.  When you know your voice you can find the right teacher for you.   It doesn’t matter what school they are at, what city they are in, if they are the most recognized teacher or no one has ever heard of them, find that teacher, stay with them as long as they help you and then take their lessons with you every day.  When you are in the real world, you will need to be your own teacher.  

Lastly, when you walk on stage, harness the simplicity and veracity of your youth.  Remember the foundation of your life’s exposure, and balance it with spontaneity and unbridled, honest beauty.  Be your own unique you.  If you are brave enough to unmask your soul, you can change lives.

In response to what young singers should do less of: Please, do less of what everyone else is doing.  The world is tired of boring and predictable.

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

Salome, Elektra, Turandot, Brünnhilde, Lady Macbeth, Leonora in *La forza del destino* and Norma.   Otherwise: Any Verdi baritone role, Carmen, Susanna in *Le nozze di Figaro* and Queen of the Night (although I have most certainly tried to sing her multiple times).

## How do you explain your job to non-music folks?

I have simultaneously the most privileged and cursed profession in the world.  I get to travel the world, eat amazing food, sing in front of giant crowds, experience art and culture, speak multiple languages, sing to my heart’s content, live on the very cusp of life and be an amplifier for the greatest music ever written.  

I also get to have no job security, come into my singing prime in my 40s, no pension, no health benefits, to be away from my husband for weeks and months at a time, live in colleagues spare rooms and on their couches, completely unglamorously.  I get to live a life that is not like many other peoples.  It requires incredible tenacity and discipline and I have no large corporation to back me up.  I experience disappointment and failure on a level that most people cannot comprehend.  

It is one of the most difficult things I could ever imagine doing and yet with all my heart I cannot give it up.  It is one of the most thrilling vocations I could have asked for and despite the heavy dichotomy that this world offers, I consider myself one of the luckiest people on this planet to be able to alter even one moment of one life through the glory of music.
