+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-07T03:49:00-06:00"
lastmod = "2016-06-13T05:44:00-06:00"
preamble = "We're kicking off this summer's Spotlight Series with South African bass-baritone [Musa Ngqungwana](/scene/people/musa-ngqungwana/). This summer he makes his [Glimmerglass Festival](/scene/companies/glimmerglass-festival/) debut in Rossini's [*The Thieving Magpie*](https://glimmerglass.org/festival/2016-mainstage/thieving-magpie/) (*La gazza ladra*), before debuting at [The Dallas Opera](/scene/companies/the-dallas-opera/) in both *Eugene Onegin* and *Moby-Dick* this fall. \n\nMusa has also penned his autobiography, [*Odyssey of an African Opera Singer: From Zwide Township to the World Stage*](https://www.amazon.com/Odyssey-African-Opera-Singer-Township-ebook/dp/B00ONVQNYE?ie=UTF8&keywords=odyssey%20of%20an%20african%20opera%20singer&qid=1413933244&ref_=sr_1_1&sr=8-1), a notably unique journey from childhood to the busy performing schedule he enjoys across the globe. He gave us a beautiful interview about growing up in segregated South Africa, joining choirs to meet girls, and learning patience along with his craft."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1465293017911/2016-06-07---Musa.jpg.jpg"
primary_image_credit = "Photo: S. Richards."
publishDate = "2016-06-12T18:25:00-06:00"
related_articles = ["articles/spotlight-on-amanda-majeski.md","articles/talking-with-singers-othalie-graham.md","articles/spotlight-on-geoffrey-penar.md","articles/spotlight-on-shelley-jackson.md","articles/sidney-outlaw-stairs-success.md"]
related_companies = ["scene/companies/glimmerglass-festival.md","scene/companies/the-dallas-opera.md"]
related_people = ["scene/people/musa-ngqungwana.md"]
short_description = "&quot;Upon reflection, my response is rooted in my convictions, experience, appreciation and understanding that I have been granted with the gift of singing from the day I was born. However, when I was growing up, I didn’t know that I could sing. Nor did I know, upon discovering I could phonate, how good or bad I was at it. I think it’s fair to say I didn’t care that much or pay attention to such details at the time.&quot;"
slug = "spotlight-on-musa-ngqungwana"
title = "Spotlight on: Musa Ngqungwana"
+++

## Why do you sing, and why are you doing it professionally?

Upon reflection, my response is rooted in my convictions, experience, appreciation and understanding that I have been granted with the gift of singing from the day I was born. However, when I was growing up, I didn’t know that I could sing. Nor did I know, upon discovering I could phonate, how good or bad I was at it. I think it’s fair to say I didn’t care that much or pay attention to such details at the time. 

I was a young boy, living in the ghetto streets of Port Elizabeth, South Africa, often causing mischief. One fateful day, soon after starting 5th grade, they let us sing in an assembly, and the music teacher walked around us as we were singing. He heard my voice and whispered in my ear, "See you at choir practice after school." That was the first time I became aware that I could sing. I ignored him and never went to the choir practice, a rookie move that landed me in hot water and I paid the price of detention. Nonetheless, I was motivated to join the choir when I saw that a girl I was enamored with was in the choir. My advances to date her failed miserably, but I remained in the choir because frankly in the choir there were other girls I could also date.

I soon learned to appreciate music and the harmonic predispositions of the choir format. When I was 16, I saw a video of a 1978 production of Mozart’s *The Magic Flute*, which was produced at Glyndebourne. The role of Die Sprecher was played by Sir Willard White, a Jamaican-born British bass-baritone. I was mesmerized at this art form with the lights, the orchestra, and the style of singing. The language, costumes, and sets took my imaginative horizons to a new place. That a black man was also part of this production was a mystery to me. Growing up in segregated South Africa where blacks weren’t allowed to partake in a white-dominated theater and classical genre, I never knew it were possible that outside of my country such things existed. 

I was immediately smitten. From that day on, I decided I wanted to do what Sir White did. It came from a place of excitement until it developed into a lifestyle. I sing professionally now because I realize that as much as I chose this career, it has also chosen me. I like the overall experience, with people in their best dresses and suits, with cellphones off, house lights off, and the spotlight on myself and my fellow actors. I like the journey of taking on a role, breaking it into bars of music, harmony, and its analysis, and learning about the composers and librettists. It’s exhilarating and exciting at the same time. I’m in it because I love it and I wouldn’t change it for anything in the world. 

The wonder of that first production I saw on VHS sparked my curiosity and I’ve been on that journey since, discovering more worlds and horizons.

## What does "good singing" mean to you? What does it feel like when you achieve it? 

I had quit singing briefly in high school in 1998. I remember I sang first tenor at the time. We were preparing for a school choir Eisteddfod which was sponsored by the Departments of Education and Arts and Culture. With South Africa having formerly been a commonwealth of Britain, the missionary presence had greatly influenced the resurgence of choral music and choir movements. 

Today over 90% of choirs in South Africa are black. We were preparing “From the Censor Curling Rise” from Handel’s *Solomon*. It’s a very high piece and a great piece to do for a choral competition. At the time, I didn’t know my voice was changing, and I soon noticed I was struggling to sing the high notes and lacking formal music training, I was lucky I realized that something was not right. 

I felt some pharyngeal singing as I attempted to reach for the high C’s, and I was getting vocally fried and tired, so I quit choir. That naturally defeated my pride, because there was a stigma associated with someone who cracked the high notes. At the time, none of us knew about vocal production. I was sensible to not stick it out try to prove a point. The rest of the year, I was on vocal rest, and the following year, I came back starting to sing baritone, which felt better. 

It’s a long-winded answer which seeks to highlight the fact that good singing has to come naturally. 

There isn’t much difference between the technique of singing to that of speaking. When we speak, we do it effortlessly, thus singing must also follow suit in that direction. I do well with a teacher or a vocal coach who follows this line of thinking. If someone is trying to micromanage my singing and wants me to do some weird technique, I know right then and there, it’s not going to work. 

I’m a work in progress and still learning my voice. Most of the learning now happens on-stage, where everything you’ve learned is put to the test. My understanding of good technique is that it should help keep breath flowing and singing natural. Like speech, if you lose your voice, you know you’ve been shouting and doing it all wrong; singing, therefore, must follow the same premise. The underlying premise is you don’t go with what you hear, because we can’t listen to ourselves, therefore knowing your body is crucial, and knowing the right feeling when you’re singing correctly.

## What do young singers need to do more of? What should they do less of? 

The old school singers, especially in the 40s, 50s and 60s understood that good singing was not an overnight enterprise. Granted, they had time to spend three years sometimes just working on scales and then from there could progress to doing Italian songs, “Arie Antiche,” or both German and French art songs and then slowly move to Vivaldi, Handel, and Mozart until they were grown enough vocally to handle big repertoire. Much like this training progression from last century, I’m of the view that young singers need to learn proper technique first and then slowly build up. 

Now, we have singing competitions and the novelty of winning that comes with them. I see many folks choose some repertoire even though it is too early for their voices. Some singers today are in a rush to get to the stage and become big names, but then can burn out after five years, because if the proper technique wasn’t in place previously then singing advanced repertoire could be at the singer’s detriment. Slow and steady wins the race. 

I say, studying for a minimum of ten years is a good idea, and having a focus on healthy singing is key. Complete both undergrad and grad schools and if you still feel you’re not quite ready, do a good studio program where you’ll get to harness the art of singing from small roles and build from there. If you get to the big roles faster than you can master them, the faster you will burn out.

## Do you have any "bucket list" roles you’d like to sing (realistically or otherwise)?

Yes, my bucket list is actually full of big roles, some of which are in the near future while others are in the distant future. For instance, the big league roles such as Wotan, Falstaff, King Philippe, Scarpia and Michele in *Il Tabarro*, those are in the distant future, perhaps after I turn 45 years old, but even then, I’d have to check where my voice is at, whether I’ll still be a bass-baritone or if my voice will have shifted. I’ve got years to figure it out. 

In the near future, I would like to sing Mephistopheles in *Faust* and his alter ego in Boito’s *Mefistofele*, Escamillo in *Carmen*, Amonasro in *Aida*, any Mozart bass-baritone role, and most Donizetti, Rossini and Bellini roles for my voice-type. 

## How do you explain your job to non-music folks?

It’s always a tough call, and frankly I’ve grown less patient in my explanations recently! My family are the biggest culprits. They are intelligent people, but completely clueless to things outside of their fields of study. I always tell people what I do is:

“I’m a singing actor, and my art form combines drama and music on-stage, marrying them together to create opera. Operas come in different languages, with Italian being the first, as opera’s birth place, as well as French, German and English operas, and even works in other languages such as Russian and Czech. Stories range from mythology to realism and as each century changed because of socio-political movements, opera and its style of writing evolved.”

People next often ask me about kids and personalities on television shows, and if what I do is like that. I say emphatically “No, no, no! Opera happens on stage, without microphones…”
