+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-25T15:39:00-04:00"
lastmod = "2017-07-28T22:26:00-04:00"
preamble = "[Michael Uloth](/scene/people/michael-uloth/) admits it right off the bat: \"I've never been satisfied doing just one thing.\" The Toronto-based bass also [designs websites](http://www.michaeluloth.com/web-design/), teaches English, and helps people with their [personal finances](http://www.michaeluloth.com/tax-quote/). As an opera singer, Uloth is a graduate of the young artist programmes at the [Canadian Opera Company](/scene/companies/canadian-opera-company/) and [Seattle Opera](/scene/companies/seattle-opera/), and he's graced the stages of Glimmerglass Opera, Saskatoon Opera, and Opéra national de Lyon. Earlier this summer, Uloth joined [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/) at The Banff Centre for Joel Ivany's new production of Vivier's *Kopernikus*.\n\nPlenty of singers vouch for the importance of variety and time spent outside the world of opera, yet not everyone succeeds at practicing what they preach. Uloth gave us a fab interview about \"accidentally\" falling into singing, gaining perspective from an operatic hiatus, and figuring out the best way of being a great colleague."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501022618450/2017-07-25---Michael-Uloth.jpg.jpg"
publishDate = "2017-07-28T22:25:00-04:00"
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/seattle-opera.md","scene/companies/the-banff-centre.md","scene/companies/glimmerglass-festival.md"]
related_people = ["scene/people/michael-uloth.md"]
short_description = "&quot;Sooner or later, other jobs feel like work, but singing never does. My desire to become a better singer makes every chance to sing feel fun. Singing also reminds me to be playful and creative, which has always been a helpful balance to my overly cerebral and organized approach to life — something I missed while I was away.&quot;"
slug = "spotlight-on-michael-uloth"
title = "Spotlight on: Michael Uloth"
+++

## Why do you sing, and why are you doing it professionally?

I fell into singing accidentally while I was at Laurier studying English. With no knowledge of opera, I signed up for a music degree at the same time (to keep things interesting), but when I heard my friends belting out giant high notes, I was hooked. It was amazing to me that normal people could be trained to transform shouting and screaming into such a powerful sound and I wanted to see if I could learn to do it, too.

Eight years of school later, I enjoyed several years of professional singing before taking some time to explore the accounting and English-teaching worlds. I learned a lot during my hiatus from music, but the most important thing I discovered is that no career feels as meaningful or rewarding to me as singing. 

Sooner or later, other jobs feel like work, but singing never does. My desire to become a better singer makes every chance to sing feel fun. Singing also reminds me to be playful and creative, which has always been a helpful balance to my overly cerebral and organized approach to life — something I missed while I was away.

## What does "good singing" mean to you? What does it feel like when you achieve it?

This is a surprisingly difficult question! I enjoy a wide range of performances: sometimes I'm amazed by the technical control of a singer softly floating a very high note; sometimes I'm equally moved by the raw emotion of a singer roaring and snarling for all they’re worth. In general, I'm a sucker for loud, powerful singing — it's just so impressive! Good singing can take many forms, though.

For me, learning to sing was a slow process. In my first few years at university, my main goal was to make the darkest, richest sound I could. I had a sore throat after every lesson, performance or practice session and I assumed everyone else did, too. It took me years to discover the bright, resonant side of singing that makes singing easier and more natural. Now, there are a few sensations that let me know I'm singing well: the most obvious one is that I feel like I have a floating ball of snarly resonance in the middle of my face that I can move around however I want.

## What do young singers need to do more of? What should they do less of?

I remember a coach taking me aside during my first year in the COC Ensemble and telling me I needed to relax a bit in rehearsals. I was working hard and didn't understand the advice at all back then, but I get it now. I was so concerned about doing the right thing that I asked questions in advance about every acting and singing decision that popped into my head. 

So, my advice would be to not worry about being perfect! Just sing pretty and try things out and trust that the director and conductor will let you know if something needs to change. Asking lots of questions may feel like the right thing to do as an eager professional, but the people you're asking have a lot on their minds and sometimes the best thing you can do for them is to just answer your own questions so they can focus on what they're doing. 

As a young singer, I also think that being a supportive colleague should be one of your top priorities. It's far better to help your colleague do a great job by telling her she sounds great than by pointing out her mistakes. Don't "help" that way! Oh my gosh. The conductor will catch it, and if they don't, don't worry about it. Making sure the show is perfect is a huge mistake because you're stepping into the conductor’s role (which you shouldn't) and you're creating a negative atmosphere between colleagues (which you really shouldn't). It's a totally understandable instinct as a well-intentioned young singer trying to do a good job, but school's over and music is a team sport, so keep all your feedback positive. 

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

Realistically, I'd love to sing Enrico VIII in *Anna Bolena* again at some point. I had the chance to sing it in concert a few years ago and fell love with the mixture of elegance and snarl Donizetti wrote into the character. A staged version would be a lot of fun. 

More unrealistically, Filippo II in *Don Carlo* is a dream role for most basses and I'm no exception! It's a demanding role usually sung by basses later in their career (although Siepi was 27 for his incredible Met debut in the role), so I'm leaving it alone and keeping my fingers crossed. Filippo's beautiful aria and the amazing bass duet that follows it are easily my favourite 20 minutes in opera.

## What have you learned about your career as a singer, solely through professional experience?

I've learned that singing, for me, is worth the uncertainty that contract work brings. It's tricky to do well and takes a lot of time and energy to succeed at (like they say about poker, it's "a hard way to make an easy living"), but compared to jobs that require hard labour or draining long hours, singing feels like a chance to work on something I'd want to try for free anyway. I feel energized walking into a singing job in a way I don't feel when the work is purely for money. I've learned to appreciate how lucky I am to feel this way and to have the chance to be paid to do something I love.

I've also learned that singers, along with the music and production teams that work along with them, are my favourite colleagues. The people I've met in other industries are super, but there's something about singers and other musicians that I find extra fun to be around. Maybe it's their passion for what they do. Maybe it's because they were my first professional colleagues, so now they just feel like home. Whatever the reason, it's great to be back.
