+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-01-08T10:40:00-05:00"
lastmod = "2016-01-09T12:09:00-05:00"
preamble = "Canadian-American baritone Michael Nyby keeps a busy schedule singing on both sides of the border. He's an incredibly versatile artist, who sings everything from Falke (*Die Fledermaus*) to *Carmina Burana* to Count Almaviva (*Le nozze di Figaro*) to the role of William Dale in the world premiere production of *Silent Night* with Minnesota Opera. For Michael, 2016 begins with Schaunard, Escamillo, and the world premiere of *Isis and Osiris*, presented by VOICEBOX: Opera In Concert. \n\nHe found time to chat with us, about why singing is so difficult, and why it's completely worth the work."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452267401528/2016-01-08---Michael-Nyby.jpg.jpg"
publishDate = "2016-01-09T12:09:00-05:00"
related_articles = ["articles/spotlight-on-keith-lam.md","articles/spotlight-on-marjorie-maltais.md","articles/talking-with-singers-nicole-cabell.md"]
related_companies = ["scene/companies/edmonton-opera.md"]
related_people = ["scene/people/michael-nyby.md"]
short_description = "&quot;The singer must be a master of their own unique and peculiar instrument, an adept musician with an intricate understanding of rhythm, pitch, function, gesture, etc., functionally proficient in a handful of languages, and a capable dramatic actor. To top it off, the singer must be all of these things at once.&quot;"
slug = "spotlight-on-michael-nyby"
title = "Spotlight on: Michael Nyby"
+++

## Why do you sing, and why are you pursuing it professionally?

I sing because it feels good. I suppose that’s the same reason most people sing. Every musician will wax poetic about the indescribable joy that comes from making great music, but when the music is a product of your body alone, it’s an entirely different level of experience. Singing is the ultimate outlet of human emotion. Why there are so many songs about love, death, betrayal, and vengeance? If the passion is too strong for normal verbal communication, it must be sung! For example, take the first sung line of Beethoven’s 9th: “O Freunde, nicht diese Töne.” Speak it. Not bad. Has a nice meter to it. 

Now let’s sing it. Ready? 1…2…3… “O FREEEEEEUUUUUU-EU-EU-EU-EEEUUU-NDE! Nicht DIIIIIEEEEEESE TÖ-NE!” Felt good, right? Pretty cathartic, wasn’t it? 

Now let’s play it on a piano. *doot-DOOT-doot-doot-doot-DOOT-doot* Sorry pianists, but it’s just not the same. There’s a visceral power that comes from using your own body as the instrument, as if the music is literally coming from every fibre of your being. 

As for why I sing professionally, well, that’s a tough one. I’m sure I’ve asked myself that question many times and never came up with a suitable answer. After all, it is a rather silly thing to do as a career. Ultimately it comes down to two things: 1) I’m relatively good at it, and 2) it exists as a somewhat viable career option. Remember how good it felt belting out Beethoven in the last paragraph? If you had the opportunity to earn your keep doing that for the rest of your life, why wouldn’t you do it? 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452267483579/2016-01-08---NybyCarmina.jpg.jpg)<figcaption>Baritone Michael Nyby singing Orff's *Carmina Burana* with the Thunder Bay Symphony Orchestra.</figcaption>
</figure>

## What does "good singing" mean to you? What does it feel like when you achieve it?

Good singing is compelling musical communication. If a singer can effectively relate the text and music as well as the dramatic intent inherent in both the text and music, I’m happy. Sounds simple enough, but doing all these things together requires a number of vastly different proficiencies.

The singer must be a master of their own unique and peculiar instrument, an adept musician with an intricate understanding of rhythm, pitch, function, gesture, etc., functionally proficient in a handful of languages, and a capable dramatic actor. To top it off, the singer must be all of these things at once.  Formal training ostensibly covers our musical and vocal responsibilities, but the dramatic ability and idiosyncrasies of singing in various languages are often learned on the job. The absolute greatest singers consistently cover all four of these areas with apparent ease through the entirety of a performance. 

On my best nights, I am singing freely enough that I don’t have to worry about the vocalism and music and can concentrate on the action I’m creating and the drama created around me. Only then can I really become my character and truly be in the moment. That’s what good singing feels like to me.

## What do young singers need to do more of? What should they do less of?

I still consider myself a young singer so I can tell you exactly what I need to do more of…practice! I should be practicing right now, in fact. Do you have any idea how much music I need to learn? 

In all seriousness though, I think musical preparation isn’t given the importance it deserves. There’s no excuse for showing up to the first rehearsal without your music learned and at least mostly memorized, and yet in almost every single contract at least one or two cast members are underprepared. It’s unprofessional and disrespectful. Sure, if you’re in that exclusive top-tier of highly-respected singers in your market, you can get away with a little bit of this kind of thing, mostly because you’ve spent a lifetime proving that you’re going to do a great job with it in the end. But if you’re in the early stages of your career, off-book, first day, no question. Exceptions are earned.

As for the second part of the question, singers need to stop making excuses. “I wasn’t with the right teacher”, “I didn’t have the time to prepare enough for that audition”, or “They’re just casting the people they already know” are some of the most common ones. 

Too many young singers blame failure and rejection on external sources. I know I’ve made these excuses in the past, but eventually one must realize that failure and rejection are just part of the business. If you’re good enough, eventually you’ll work. If you’re not getting any jobs, work harder to become a better singer. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1452267533858/2016-01-08---NybyMerryWidow.jpg.jpg)<figcaption>Nyby as Danilo in Edmonton Opera's *The Merry Widow*.</figcaption>
</figure>

## Do you have any “bucket list” roles you’d like to sing (realistically or otherwise)?

Absolutely! In my opinion, the greatest character to ever grace the operatic stage is King Philip in Verdi’s *Don Carlo*. He’s a complex and sympathetic character and yet still the villain—a sort of Darth Vader for the 16th century. Unfortunately, Verdi wrote that role for a basso profundo so I’m afraid that one will be unattainable for a mere lyric baritone like me. More realistically, Guillaume Tell. I had the opportunity to cover that one a few years ago and the whole opera blew my mind. If you haven’t gotten to know *Guillaume Tell*, do yourself a huge favour and go listen to *Guillaume Tell*. In ten years or so I’d love to sing Macbeth, and maybe a Falstaff in twenty. I am a card-carrying member of the “Falstaff is the greatest opera ever” club. It’s only cliché because it’s true. Every single note of that score is absolutely perfect. 

## How do you explain your job to non-music folks?

“It’s a dirty job, but someone’s gotta do it.”
