+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-03-05T10:47:00+00:00"
lastmod = "2016-03-05T20:21:00+00:00"
preamble = "Canadian soprano [Lara Ciekiewicz](/scene/people/lara-ciekiewicz/) has some of opera's most enviable roles under her belt, including the Countess in *Le nozze di Figaro* (most recently at [Manitoba Opera](/scene/companies/manitoba-opera/)), Liù in *Turandot* (Manitoba Opera), Musetta in *La bohème* ([l'Opéra de Montréal](/scene/companies/lopera-de-montreal/)), Fiordiligi in *Così fan tutte* ([Merola Opera Program](/scene/companies/merola-opera-program/)) and Nellie in *South Pacific* ([Pacific Opera Victoria](/scene/companies/pacific-opera-victoria/)). We met Lara several summers ago at the beloved Banff Centre, and she's an incredibly driven and exciting artist who loves the work as much as the performance. \n\nShe chats with us about choosing her career as a singer, life as a \"professional storyteller\", and Scarpia-envy."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457176642509/Lara---Square.jpg.jpg"
primary_image_credit = "Photo by Rebecca Schroeder."
publishDate = "2016-03-05T11:20:00+00:00"
related_articles = ["articles/spotlight-on-danielle-macmillan.md","articles/spotlight-on-charlotte-knight.md","articles/spotlight-on-lida-szkwarek.md","articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-othalie-graham.md","articles/ciekiewicz-triumphant-in-calgary-operas-onegin.md"]
related_people = ["scene/people/lara-ciekiewicz.md"]
short_description = "&quot;Before every performance, I will take a few minutes to walk the stage and look out into the empty hall. I look out at all the seats waiting to be filled and wonder who will be sitting there. When you are in the middle of a performance, it can be easy to look into the darkness and see it as this single black hole. However, if there are 2200 seats in the hall, that makes 2200 people, each with their own story - waiting to laugh, cry, cheer the heroes, and curse the villain! It is my job to sing for each of those people and to connect to them through the music.&quot;"
slug = "spotlight-on-lara-ciekiewicz"
title = "Spotlight on: Lara Ciekiewicz"
+++

## Why do you sing, and why are you doing it professionally?

I love music.  All kinds of music.  It seems to be able to find all the little nooks and crannies in your heart that we keep hidden most days and fill them with whatever is needed.  Music was the thing that let this shy, little kid connect to more people that she thought possible.  So why do I sing?  I sing to tell stories, to connect to people, to find my best and most complete self, to plug into a greater whole, and because I love it.  I suppose I am doing it professionally as I can’t imagine myself doing anything else.  

In truth, there was a time I was determined to be a chiropractor.  That may have been the case had it not been for a fateful visit to one of my older brothers.  We were hanging out one night and, as older siblings do, he was grilling me about my plans after graduating high school.  I enthusiastically stated I wanted to be a chiropractor, giving him all the good reasons why.  He listened attentively and then looked at me seriously.  "That’s great, Lara." he said, "I have just one question for you: if you could do anything in the world and money wasn’t a concern, what would it be?"  I didn’t even bat an eye before blurting out, "I’d be a singer."  "Then why aren’t you doing that?" he replied.  Pretty awesome brother, huh?  (For the record, my other brother is awesome, too!)  

It would be those two questions that set me out on a path that got me to where I am today.  It’s a path filled with hard work, challenges, and at least as many failures as successes.  That said, it is rewarding and joyful work and I am privileged to do it.  Privileged beyond words.

## What does "good singing" mean to you? What does it feel like when you achieve it?

Good singing is the perfect marriage of technical mastery, artistry, heart, and soul.  Ok, that’s not just good singing, that’s GREAT singing.  It’s the kind of singing I aspire to and continue to work towards every day.  When you achieve it, you are free to fly.  I know when I get close to it, that’s exactly what it feels like - flying.  It’s when you have the knowledge, skills, and technical tools that allow you to respond, unfettered, to the emotional content and artistic demands of the story and score.  It’s the kind of singing that can reach out and truly move you, at once a little raw and refined.

## What do young singers need to do more of? What should they do less of?

I don’t know about "do more or do less of" - if you’re on the journey, you already have a lot of people who know you and want the best for you telling you this.  I can, however, tell you a few things that have become abundantly clear to me along the way:

- Words matter and not just ones you get to sing.  I am a big believer in the power of language to shape thought and consequently, action.  You know, the old saying, "If you think you can or can’t - you’re right."  How you speak to others, how you speak to yourself, how you speak about what you do.  I do my best to think of things in positive terms.  Don’t want to tense up?  How about focussing on release and freedom rather than "not tensing up"?  Obviously, this is only a part of it.  It is, however, something to consider. 

- Practice does not make perfect - practice makes permanent.  Practice mindfully.  Be aware of what you are training into your body (and brain) and how.

- Be prepared.  Be punctual.  Be nice.

- Do not give unsolicited advice.

- Handwritten notes and cards are awesome.  They don’t have to be novels and I don’t know a soul who doesn’t like receiving one.

- Enjoy the process.  Every. Bit. Of. It.  It’s more fun than way.

- Failure is part of the process.  See previous.  This is hard.  This, however, can also be great in the grand scheme of things.  If you are given the gift of a safe place to fail - use it. 

- A great conductor once told me the only defence I have as a singer is knowing what is in the score.  A score is to be interpreted, of course, but knowing and exploring all of the information contained on the page will always stand you in good stead.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1457176629151/Ciekiewicz_Lara.Casual-HeadshotReszied.jpg.jpg)
<figcaption>Photo by Pierre-Étienne Bergeron.</figcaption></figure>

## Do you have any "bucket list" roles you’d like to sing (realistically or otherwise)?

Ummmmm...who doesn’t want to sing Scarpia?!  Possibly. The. Best. Entrance. In. An. Opera. Ever. #tedeum 

I don’t have an official bucket list of roles.  If I can do my best work, with great people, with integrity and heart, grow artistically, tell stories, and build community through that, this is what really matters.  Also, Violetta, Susannah, Anna Bolena, Kathy Selden, Manon, Marguerite, Nedda, and all the Mozart...because bucket list or not, who wouldn’t want to sing these?!  Ha!  

## How do you explain your job to non-music folks?

Simply put, I am a professional storyteller through music.  That’s a pretty good point of connection for most everyone.  In addition, when I’m not telling stories on stage, I am lucky to have become involved in advocacy and outreach for my hometown company - Manitoba Opera.  This has really allowed me to craft my performing philosophy, which also speaks to your question.  This philosophy has helped me connect what I do as an artist to the broader community, musicians and non-musicians alike.  It looks something like this:

I like to think that the Arts are the campfire at the centre of the circle that joins us all together, no matter where we come from, what we seek or where life will take us.  Before every performance, I will take a few minutes to walk the stage and look out into the empty hall.  I look out at all the seats waiting to be filled and wonder who will be sitting there.  When you are in the middle of a performance, it can be easy to look into the darkness and see it as this single black hole. However, if there are 2200 seats in the hall, that makes 2200 people, each with their own story - waiting to laugh, cry, cheer the heroes, and curse the villain!  It is my job to sing for each of those people and to connect to them through the music.  

To help connect myself to the audience, I like to bring the campfire into the theatre, so to speak.  I imagine that there is a campfire burning at the centre-front of the stage.  On one side of the fire is the audience and on the other, the performers.  Except is isn’t "us against them".  Rather, we are all connected in a circle around that campfire, sharing our songs and stories together.  Easy peasy.  It’s not some scary thing called opera that you need to know lots about to enjoy.  It’s simply a story, told to its utmost with thrilling music, high emotion, and visceral energy.  Next time you are at the opera, I challenge you to think about it this way and see how you feel.  

For me, connecting myself to the audience through the campfire image allows me to tap into the audience’s energy.  When we all come to that circle around the campfire, we become the ultimate community.  And just like a campfire singalong, the energy you receive from the other people in the circle is what makes it so special.  I can’t tell you how amazing it is to feel that energy from my point in the circle.  I always hope that my energy makes its way around the circle to the audience, in return.  When we all click - that’s when the magic happens.  The energy from the hall becomes a part of the music, part of what seeps into our hearts.  In that way, each performance truly becomes a sharing - an exchange - bringing us all closer together for a brief time.  How cool is that?!
