+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-01T20:10:00-06:00"
lastmod = "2017-06-10T08:44:00-06:00"
preamble = "Rising soprano [Hannah De Priest](/scene/people/hannah-de-priest/) is carving out a specialty in Early Music, her résumé already filled with roles like Belinda (*Dido and Aeneas*), Ïole (*Hercules*), and Oberto (*Alcina*). This month, De Priest is nurturing her love for Early Music at the 2017 [Boston Early Music Festival](http://www.bemf.org/pages/fest/festOpera.htm), where she'll sing in André Campra's 1699 [*Le carnaval de Venise*](http://www.bemf.org/pages/fest/opera_centerpiece.htm). \n\nIn our latest Spotlight feature, De Priest chats about the definition of good singing, the \"dynamic music-making\" among Early Music circles, and the \"insurmountable monster\" that is jealousy within the operatic industry (and among sopranos)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496369076875/2017-06-01---Hanna-De-Priest---square.jpg.jpg"
publishDate = "2017-06-10T08:44:00-06:00"
related_articles = ["articles/spotlight-on-rihab-chaieb.md","articles/spotlight-on-christina-haldane.md","articles/spotlight-on-beth-hagerman.md"]
related_people = ["scene/people/hannah-de-priest.md"]
short_description = "&quot;I think what does all of us — especially those of us just breaking onto the scene — a disservice is making jealousy into this mystical, insurmountable monster. Hey, it&#039;s not because you&#039;re a soprano, it&#039;s because you&#039;re human. Everyone experiences that self-defeating twinge and everyone has to sort out how to deal with it so it doesn&#039;t morph into something all-consuming.&quot;"
slug = "spotlight-on-hannah-de-priest"
title = "Spotlight on: Hannah De Priest"
+++

## Why do you sing, and why are you doing it professionally?

Like many of us who wind up in the arts, I was a real ham from the start. From a young age I spent essentially all my free time memorizing and reciting lengthy movie scenes and choreographing elaborate "celtic" dances for the entertainment of my parents' and sisters' friends (cringe). But beyond the certifiable rush of performing, it's the intellectual stimulation of technique-work, a deep and ever-growing love of opera and early music, and the thrill of meeting and working with all different kinds of people that motivates me to pursue this as a career. 

I honestly can't think of another path that demands such versatility of thought and engagement except maybe criminal litigation, but realistically, how many wigs could a defense attorney hope to wear?

## What does "good singing" mean to you? What does it feel like when you achieve it?

I love that Schmopera asks this question to such a wide range of singers. Full disclosure: I've just finished my M.Mus and know there's a lot of exciting work ahead before I've fully developed the kind of flexible, efficient technique that we’re all after, whatever our voice type or specialty. 

Indeed, my notion of good singing has shifted seismically over just the past six months and undoubtedly will continue to evolve over the coming years! But right now, I feel good singing in my face above all: if my ears and nose and everything in between are buzzing, that's the sweet spot. I try to consciously go off sensation rather than sound — I tend to cock my head to one side and go quite stiff when I think too hard about what my singing sounds like. For such a long time, I was told my voice was small and light, and while I'll absolutely never be a Brünnhilde, hey, it turns out it's not so small when it's really emanating (as a fab coach recently suggested) from my hip bones.

## What do young singers need to do more of? What should they do less of?

One of the best pieces of advice I've gotten so far is that young musicians need a "musical home" — an environment where they feel empowered and have a real stake in the creative decisions. It's a model that dominates in early music, where if you want to do something that isn’t happening anywhere else, you make it happen yourself. I think it's a major reason why some of the most inventive, dynamic music-making today is happening in the "early music world." 

So much of a young singer's life consists of heading out on draining (emotionally and financially) auditions and while all that feedback and tough criticism is crucial, none of us would be in this game if we didn't think we had something to contribute right now. For me, planning little recitals and participating in lower-profile—but-hugely-rewarding chamber gigs where I'm singing but also folding programs and setting up the chairs and sorting rehearsal venues have made for some of the most gratifying and instructive musical experiences of the past few years. 

Whether it's starting a group of your own or even just a regular gig where you feel totally simpatico with the leadership, having that safe place to keep coming back to can make it easier to hop into situations where you won’t necessarily have the same autonomy.

I think what does all of us — especially those of us just breaking onto the scene — a disservice is making jealousy into this mystical, insurmountable monster. Hey, it's not because you're a soprano, it's because you're human. Everyone experiences that self-defeating twinge and everyone has to sort out how to deal with it so it doesn't morph into something all-consuming. 

Singing is a competitive field for sure, but it doesn't mean we have to treat each other with suspicion. For me, channeling that twinge into productive work in the practice room is a much more realistic coping mechanism than trying to just eradicate it from my brain. We all know jealousy (especially when in combination with cynicism) can be a real toxic brew, but it's not something we're powerless to stop. Take it and turn it into something that will make you a stronger singer and person. 

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

In the realistic category, I feel a special kinship with all the boldfaced, saucy maids in the repertoire, so I'd absolutely love to do a Despina. That's definitely top of the list right now. Susanna is another dream, though I’m some years away from that one. In the baroque realm, I'd love to take a crack at Cleopatra. Handel wrote so many complex roles for women, (way more than he did for men…!) and she is my favorite of his queens. In the category of would-kill-to-sing-but-will-never-in-a-million-years-sing: Carmen, Scarpia, Salome, Peter Grimes… and a good fifty other mezzo roles (I have serious mezzo-envy.)

## What have you learned about your career as a singer, solely through professional experience?

In my experience it's been the seemingly little things, like responding quickly to emails and an easy smile on the first day of rehearsal, that can lead not only to more work and fruitful professional connections, but to genuine friendships. The primary goal of any project is to collaborate productively with colleagues and that takes generosity and a committed team-player mentality. That just can't happen if you're being made — or making others — to feel distressed or uneasy; "diva" is just a fancy word for "difficult employee." 

Being an effective singer takes a profound amount of empathy. We all work hard to understand the characters we embody onstage and we tend to approach them with fondness and compassion, but it can't stop there: it's crucial to approach each other with that same empathy. 

Bottom line: being nice doesn’t make you a sucker.

## What do you look forward to most about your time with BEMF this summer?

I'm looking forward to a zillion aspects of performing in the Boston Early Music Festival as a Young Artist in the North American premiere of André Campra's *Le Carnaval de Venise*. It's a flashy, spectacle-driven show with just about everything you can imagine thrown in: a full troupe of dancers, a tragic love triangle, gondoliers, fortune tellers… even an opera-within-the-opera: the fourth act is a full telling of the Orpheus myth in Italian! 

It will be my first time performing as part of the ensemble with a professional company, and the chorus has a ton to do in French baroque opera. Best of all, BEMF has assembled a stellar cast for this project — I feel really lucky to have the chance to see some of my favourite singers preparing and performing this work, including Amanda Forsythe and Karina Gauvin. I also can't wait to see the lush production details. (We had our full measurements taken at the audition - many of the costumes are all being built from scratch!) 
