+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-06-25T18:06:00-06:00"
lastmod = "2016-06-29T07:57:00-06:00"
preamble = "American baritone [Geoffrey Penar](/scene/people/geoffrey-penar/) first caught our attention in the world premiere of Darren Russo's [*Storybook*](/in-review-modern-family-opera/), presented by [Opera 5](/scene/people/opera-5/) in early 2015. Recently, he returned to Opera 5 to sing Frank in their spring production of [*Die Fledermaus*](/die-fledermaus-die-fleder-fabulous/). A graduate of McGill University, Penar already has a long history on the stage, both in opera and music theatre. He has a wonderfully calm attitude about his career, and his pursuit of a professional life onstage comes from a real love of the process as well as the spotlight. He chats with us about truly understanding texts in any language, and the importance of eye contact."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1466899615160/2016-06-25---Geoffrey-Penar.jpg.jpg"
primary_image_credit = "Photo by Brent Calis."
publishDate = "2016-06-29T07:48:00-06:00"
related_articles = ["articles/spotlight-on-stephanie-tritchew.md","articles/spotlight-on-musa-ngqungwana.md","articles/and-i-know-things-now.md"]
related_companies = ["scene/companies/opera-5.md","scene/companies/opera-mcgill.md"]
related_people = ["scene/people/geoffrey-penar.md"]
short_description = "&quot;I think when it feels bad for me, I&#039;m not thinking about the action of the scene, I&#039;m just worried about the next phrase. I remember a coaching with Patrick Hansen (head of Opera McGill). He told me, &quot;Geoff, just act it! Stop thinking so much. Just make sense of the words and act it.&quot; And it fixed so many of the technical problems I was having instantly.&quot;"
slug = "spotlight-on-geoffrey-penar"
title = "Spotlight on: Geoffrey Penar"
+++

## Why do you sing, and why are you doing it professionally?

I actually began my involvement with singing through dancing in musical theater and ballets when I was very young. I was not a strong singer at all, certainly not at first. But I've been performing ever since I can really remember in some way or another. 

I realized maybe at the age of 10 or 11 that I would need to work on my voice if I wanted to get more roles in the musical theater productions going on in Burlington, Vermont, where I grew up. So because my voice had so much breath mixture, as many children's voices do, my mother held a candle in front of my face as I sang and if the flame moved I knew I needed to sing with more resonance. Cool little trick! There was a huge casting call for a *Peter Pan*, and when I got into that show, I never really looked back. 

When my voice changed, I started singing classically in addition to musical theater and I found that I had a propensity for the more classical sound. It was only a matter of time before I decided that I would go to college and study voice exclusively. (Although as many opera singers are well aware, we still have to dance quite a bit!) I never really questioned whether I wanted to be in theater or opera in some capacity, I suppose, and I was lucky that I was so sure of what I wanted to do.
 
I'm singing professionally because I love to be in rehearsals and improve with each show I do. Trying to learn from others around me and playing with new ideas every day. I love how funny people can be, strong personalities. I love to try to make people laugh when I perform and each time I do a show add something new to keep it fresh, that's what's especially enjoyable to me. Although travelling can be quite hard, you meet people briefly and you don’t truly know if you'll work with them again, you have such fun in the process of putting up a show and those people are always a part of such fond memories that you can continually call up.
 
## What does "good singing" mean to you? What does it feel like when you achieve it?

For me personally, after going through 7 years of technical training, good singing can be achieved when I get into a role I'm singing, physically getting into it, forgetting about technique and using the energy of a character to drive the energy of the voice. When I sing my best, I'm thinking about the words I'm saying, not so much the notes themselves. It feels like just performing when it feels good. 

I think when it feels bad for me, I'm not thinking about the action of the scene, I'm just worried about the next phrase. I remember a coaching with Patrick Hansen (head of Opera McGill). He told me, "Geoff, just act it! Stop thinking so much. Just make sense of the words and act it." And it fixed so many of the technical problems I was having instantly.
 
## What do young singers need to do more of? What should they do less of?

In the same vein of the previous answer, I think text declamation is very important and this can be hard given we must make sense of languages that might not be our first language. Knowing every word is important, which might make for a lot of book work, but it has been getting easier for me the more I perform and become comfortable with a language's idiom. Certainly I still have much, much to learn myself but what I try to do is to find key words, two or three in each phrase. For Italian, it's usually the adjectives. For German, it's usually a bit easier because it's nouns and verbs like in English. But just thinking about those words can simplify the struggle to be understood.
 
In a different vein, one thing I could mention is how eye contact can really strengthen a performance from an individual. Having too many focuses with one's eyes can confuse an audience and I find that even when you're not singing you can really strengthen a scene by making sure you're clearly looking at the person who should be the focus of the scene. People tend to focus on a performer's eyes more than anything else. When you sing an art song, trying to limit the amount of places you look can really help people focus on your voice.
 
## Do you have any "bucket list" roles you’d like to sing (realistically or otherwise)?

I've never sung Marcello, from *La Bohème*, so that’s a dream role for me. I'd love to sing Figaro from *Le nozze*. (I’ve sung the Count and Bartolo, funnily enough.) I'd love to do more *bel canto* repertoire because I've really been focusing on Mozart and Britten the past few years. So Figaro from *Barber* and Belcore from *Elixir*.  An unrealistic one would be Don José from *Carmen*. An amazing character and my favorite aria, I think in all of opera rep. But alas, I am not a tenor. I listen to Jonas Kaufmann singing that aria almost every day.
 
## How do you explain your job to non-music folks?

At the border between the US and Canada, every border patrol officer asks me when I tell them I’m a professional opera singer, "Yes, but how do you make your money?" I think with so much pop music out there, a non-music person might forget that there are all kinds of musicians that, while they are perhaps in an industry with less cash flow, they find a way to pave their way. So that's what I tell people. I travel, I rehearse, I perform, and I go back and learn my music for the next gig. I teach a bit on the side.

But, what's cool is that sometimes you see people say, "Wow, what an interesting life you must have!" And there’s no doubt about that for anyone in this business. There are really never any dull moments. It can be hard at times, it can be tricky with all the many logistics involved with traveling, and yet when all is said and done and the show is over and you're proud of your performance and the work you put in, there’s nothing more rewarding.
