+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-07-26T13:40:00-04:00"
lastmod = "2017-07-27T08:38:00-04:00"
preamble = "Spanish-American tenor [Eric Barry](/scene/people/eric-barry/) has an enviable collection of staple roles, including Alfredo in *La traviata*, Rodolfo in *La bohème*, and the Duke of Mantua in *Rigoletto*. He just finished a run of *Lucia di Lammermoor* at Opera Colorado, where *Opera News* raved about his \"large, beefy tenor\" in the role of Edgardo. Currently, Barry is in Boston, singing Nemorino in [Boston Midsummer Opera](http://www.bostonmidsummeropera.org/wordpress/)'s *L'elisir d'amore*; this September, he sings Macduff with [Opera San Antonio](https://operasa.org/events/verdis-macbeth), sharing the stage with Greer Grimsley in the title role.\n\nIt was cathartic to chat with Barry about the opera industry, in all its unjust reality, and about his dedication to making \"a joyful noise\".\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501091595000/2017-07-26---Eric-Barry-square.jpg.jpg"
primary_image_credit = "Photo: Matthew Fried"
publishDate = "2017-07-26T22:21:00-04:00"
related_articles = ["articles/talking-with-singers-matthew-polenzani.md","articles/talking-with-singers-brian-jagde.md"]
related_people = ["scene/people/eric-barry.md"]
short_description = "&quot;Thinking of the collective hours everyone in the room has spent honing their craft is mind-blowing, and in this brief instant it all comes together to create a magical moment in time that can never be recreated. Whoa.&quot;"
slug = "spotlight-on-eric-barry"
title = "Spotlight on: Eric Barry"
+++

## Why do you sing, and why are you doing it professionally?

I sing because I feel like I've been given a unique gift that I enjoy utilizing, that moves people in a way that nothing else can. The career isn't an easy one - there are many sacrifices to be made and it's incredibly hard work to keep our instrument in its best form, but the high I get from creating a beautiful moment on stage with a hall full of colleagues is unbelievable. Thinking of the collective hours everyone in the room has spent honing their craft is mind-blowing, and in this brief instant it all comes together to create a magical moment in time that can never be recreated. Whoa.

I do it professionally because it's one of the most interesting jobs in the world, and getting paid to do something that I love so much is one of life's greatest luxuries.

## What does "good singing" mean to you? What does it feel like when you achieve it?

Beautiful singing is being able to emote and communicate a palette of emotions simply with the voice, in the most attractive and inviting way possible. Honest singing is when the singer truly feels the emotion, and makes the audience feel it too. Good singing is the combination of beautiful, honest singing. 

There are many, many times when a singer might sound beautiful, but if I'm not also convinced that the emotion is real, then the entire experience is lost on me. Many singers, especially younger ones, imitate sounds and colors they hear someone else using on a recording; but if they don't feel that emotion and are moved to create those colors and effects themselves, I'm not buying it for a second. When an artist makes all the beautiful sounds and I can tell the colors are evoked from a real emotion or experience, THAT is good singing!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1501112491701/Eric_Barry_as_Rodolfo_in_La_boh%25C3%25A8me._Amarillo_Opera-639x960.jpg.jpg)
<figcaption>Eric Barry as Rodolfo in *La bohème*, Amarillo Opera. Photo courtesy of James Black Management.</figcaption>
</figure>

## What do young singers need to do more of? What should they do less of?

I think young singers need a better understanding of how a business operates because being an opera singer is being a business owner! I think most music performance grads enter the audition circuit knowing a lot about musical styles, technique, performance practice, etc., and just need to get their feet wet on stage to start honing those skills. However, very few of them have any idea what it means to run an efficient business: paying off outstanding debts, marketing effectively, negotiating, communicating in a timely fashion, budgeting finances, and so on. 

For years I've been consulting artists in this area and continue to be dumbfounded that this kind of information isn't a staple in the degree curriculum in almost any university. The mismanagement of these skills is a tremendous reason for the eventual downfall of so many young artists, and perfecting these skills will help keep them in the game longer, especially in today's market where there is less work and more singers!

What should young singers do less? Negatively criticize their own singing. It's great to be constructive and analytical with the end goal of getting better, but what we do is already an Olympian feat and the entire business will judge us (for better or worse) whether it's in an audition or performance, so we might as well make a joyful noise and enjoy the luxury of doing what we do for a living.

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

My realistic bucket list role is Faust, and there's a good chance one will be coming up in future seasons, so stay tuned! I'd also love to sing Peter Grimes and Lenny in *Of Mice and Men*. Anybody out there interested in producing either of these operas?? I know a guy!

Unrealistically, I'd love to sing Siegfried. That music is so freaking yummy! Also, I'm dying to be in a production of *Don Carlo*. Maaaaybe it'll happen one day, but that day is a long way off!

## What have you learned about your career as a singer, solely through professional experience?

I feel like I've learned a number of things from being a singer for which nothing else could have prepared me, like trusting my technique when singing in bigger houses (especially one with unfavorable acoustics.) A natural tendency is to want to push the sound out because acoustically the sensation is so much different from the studio in which I practiced. Fortunately, that kind of trust comes with experience and I have overcome that hurdle. 

I've also learned that it's not always the best singer who gets the role. I'm always surprised to watch an opera at a larger house, only to leave and feel like it could have been cast better with only my closest friends (not even all the other wonderful colleagues I've met in this business!). How can the singing be so out of tune, or the acting so boring? Often I'll listen to live streams of shows and am appalled at the sound coming from the best houses in the world. I know, there's a lot at play here, and many people reading may not appreciate the observation, but still, I've come to realize that some of the most incredible talent in the world never gets the opportunity to be heard by the masses. This is probably my biggest frustration with the business, but it's a reality we have to deal with.

Lastly, I'd say that for most opera singers the career is a short, bright flash in one's life. There aren't many of us who will make an entire career out of only performing until we completely retire, so while we're living this dream, really make the most of it. Take a brief moment to hear the wooden floor crack the first time you step on stage at Carnegie. Feel the velvet curtain between your fingers for a few seconds before making your debut at that big house. Look into the eyes of your idol and register the fact that you studied their singing for so many years and now you're sharing the stage with them! These are the types of things I've tried to do and those memories and sensations will never leave me.

>For more with Eric Barry, visit his [website](https://eric-barry.com), & follow him on [Twitter](https://twitter.com/EBTenor), [Facebook](https://www.facebook.com/ebtenor), and [Instagram.](https://www.instagram.com/ebtenor/)
