+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-06-10T21:32:00-04:00"
lastmod = "2015-06-15T15:19:00-04:00"
preamble = "This interview is part of our ongoing series of features on young working artists in the opera industry. If you think you'd be a great candidate for an interview, or know someone you'd like to nominate, get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433986313277/EmilySquare.jpg.jpg"
publishDate = "2015-06-15T15:19:00-04:00"
related_articles = ["articles/spotlight-on-peter-bass.md","articles/spotlight-on-michelle-siemens.md","articles/spotlight-on-julia-dawson.md","articles/spotlight-on-charlotte-knight.md","articles/spotlight-on-christopher-james-ray.md","articles/spotlight-on-maikai-nash.md","articles/spotlight-on-kelsey-vicary.md","articles/spotlight-on-lida-szkwarek.md","articles/spotlight-on-danielle-macmillan.md","articles/spotlight-on-marjorie-maltais.md","articles/spotlight-on-william-ford.md","articles/spotlight-on-kimberleyann-bartczak.md","articles/spotlight-on-laurelle-jade-froese.md","articles/spotlight-on-jeremy-hirsch.md","articles/spotlight-on-maeve-palmer.md","articles/spotlight-on-keith-lam.md","articles/spotlight-on-sara-schabas.md","articles/in-defense-of-the-day-job-.md"]
related_companies = ["scene/companies/oberlin-college-and-conservatory.md"]
related_people = ["scene/people/emily-peragine.md"]
short_description = "I met Montana-born soprano Emily Peragine during her undergraduate degree at Oberlin College Conservatory, and she struck me immediately as a rare breed. Emily is a real lover of singing, and a refreshingly thoughtful artist. You can see more of what I mean by reading her beautiful blog. For a while now, I&#039;ve been looking forward to the chance to introduce Emily to my readers, and she doesn&#039;t disappoint with this interview."
slug = "spotlight-on-emily-peragine"
title = "Spotlight on: Emily Peragine"
+++

I met Montana-born soprano [Emily Peragine](/scene/people/emily-peragine/) during her undergraduate degree at [Oberlin College Conservatory](/scene/companies/oberlin-college-and-conservatory/), and she struck me immediately as a rare breed. Emily is a real lover of singing, and a refreshingly thoughtful artist. You can see more of what I mean by reading her beautiful [blog](https://montanasoprano.wordpress.com/). For a while now, I've been looking forward to the chance to introduce Emily to my readers, and she doesn't disappoint with this interview. She chats about *Der Rosenkavalier* and exposing career myths.

***

### 1. Why do you sing, and why are you pursuing it professionally?

To start, I believe that part of me is clinically insane. Anyone that attempts to pursue this career professionally knows that “financial stability” isn’t necessarily part of the hand we are drawn. We are constantly critiqued, told what is wrong with us, what is wrong with our “voices”, everything that is going against us, who has more connections, the percentage of people that “make it”, how many “fail” in the attempt… basically every single thing that proves that this was a very bad idea and that maybe I should have gone the safe route and entered pharmacy school. 

That being said, I don’t believe this career is something you choose. In a lot of ways I feel that it chose me instead. I was born with some form of natural talent to carry a tune. I don’t know why, I don’t know how, that’s just how it happened. As I got older, I realized that I could sing louder, that I could sing more difficult material, that I had a range, that I really (not just kind of) REALLY liked being on stage. That the energy I felt performing brought so much excitement and joy that I couldn’t see myself doing anything else. 

Singing is an extension of myself. It gives me the strength to say things I would never say in real life, to express things I can’t express in writing. Through singing I can travel through time, I can live on another plane of existence. It is my playground, and where I am the most comfortable with myself as a person. I don’t have a damn backup plan, this is it. This is my plan. 

### 2. What does "good singing" mean to you? What does it feel like when you achieve it?

For me, good singing means I’m not thinking about singing. If I am thinking about technique, breath, raising the soft palate and other obnoxious singery things that make me want to explode...chances are I’m not singing well. Singing with technique in mind means you’re singing in a box. 

It is rare, but when I truly feel like I’m singing well, it feels like I’m outside of myself. It feels easy, nothing is forced, I’m not “trying” to do anything. It’s just happening organically and I’m going along for the ride. 

### 3. What do young singers need to do more of? What should they do less of?

Oh GOD I love this question. I feel like young singers really need to distance themselves from the glistening golden paved road of “how to be an opera singer.” From my perspective, this is what that road looks like:

First, go get your bachelors, do expensive summer programs (If you come from a wealthy family you’re in luck, if not, tough crap.) Graduate, get into another highly esteemed institution known as grad school. If you’re lucky you don’t have to pay for it, most of us will. Then go do more expensive programs. (Again, if you’re lucky you’ll get into the ones you don’t have to pay for.) Get into a young artist program, win the Met competition, join the roster at IMG, congratulations you’re now an international sensation.

I’m sorry, it is the biggest bunch of Bull****. THIS IS NOT THE ONLY WAY TO GET A CAREER. If it wasn’t painfully obvious, I did NOT go to grad school. I went to a public high school in Montana, and was very, VERY lucky to be accepted into Oberlin and granted the opportunity to study there. I have a huge support system of good people, mentors, teachers, family, and people that care about me and my well being, not just as a singer, but as a person. I graduated and did the most important thing for myself ever. I worked, saved money, traveled by myself, and took some time off to figure out my life and what I WANTED. That kind of an education is priceless, and it’s something I’m still learning and working on every day. Young singers need to quit comparing themselves to people who are currently in the limelight. They need to work on being versatile, being marketable, knowing that in this day and age it’s not just about singing pretty, it’s about being emotionally invested, being an advocate for yourself, and creating your own opportunities. 

### 4. Do you have a "bucket-list" role that you'd like to sing? Why?

I have many bucket list roles, but I would be beside myself If I got to sing the role of Sophie in *Der Rosenkavalier*. So much so that If I’m lucky enough to have kids some day, and a daughter that I’m literally going to name her Sophie. 

*Der Rosenkavalier* is one of my favorite operas. The music just slays me. The first piece I ever heard from it wasn’t the famous trio, but the duet that comes directly after, “Ist Ein Traum.” I had listened to the recording with Anne Sofie Von Otter and Barbara Bonney. There was something so unbelievably gorgeous about it that I started crying at the end of it. The musical interludes/dissonances sparkle in it. When I heard it I immediately thought of Cinderella. Albeit, Cinderella caught in a bizarre love triangle/ I remember as the recording finished I thought to myself, “Dear God, I need to sing this, I need to do this role.” As a character, she is not very developed. We don’t know much about her besides the fact that she is very innocent and very wealthy. This opens up a lot of room for the imagination. I feel that I could give her a voice, I think there is a lot more to her that hasn’t been explored. I would love to have that opportunity. 

### 5. How do you explain your job to non-music folks?

I say that my job is to entertain and serve people. 

I am still trying to figure this out, but as performers we are two different versions of ourselves. There is “me” the person, and “me” the performer. They are mutually exclusive, at least they’re supposed to be. Again, still trying to figure out this one, and hopefully I’ll get there with practice. 

As a performer, my job is to transport others and make them feel things, feel something. To give them an experience that can maybe make the reality of our everyday lives disappear for a millisecond. If I can do this, I am successful and doing my job. 

Ultimately I am here to serve, and I do it through the music, and the characters I sing through. 
