+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-28T19:25:00-06:00"
lastmod = "2017-06-29T23:59:00-06:00"
preamble = "With last month's run of *Don Carlo*, Australian mezzo-soprano [Emily Edmonds](/scene/people/emily-edmonds/) finished her second season with the [Royal Opera House](/scene/companies/royal-opera-house/), where she is a Jette Parker Young Artist. This fall, she heads to Auckland for New Zealand Opera's *Katya Kabanova* (Varvara), before checking off one of her bucket list roles with the Komponist in [Opera Holland Park](/scene/companies/opera-holland-park/) and [Scottish Opera](/scene/companies/scottish-opera/)'s co-production of *Ariadne auf Naxos*.\n\nIn our newest Spotlight interview, Edmonds spoke thoughtfully with us about her love of the rehearsal room, and the importance of being brave."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498699288734/2017-06-28---Emily-Edmonds-Portrait-1.jpg.jpg"
publishDate = "2017-06-29T23:40:00-06:00"
related_articles = ["articles/spotlight-on-rihab-chaieb.md","articles/spotlight-on-jennifer-davis.md","articles/spotlight-on-alice-privett.md","articles/in-review-the-jpya-summer-performance-.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/scottish-opera.md","scene/companies/opera-holland-park.md"]
related_people = ["scene/people/emily-edmonds.md"]
short_description = "&quot;I value making, creating, and empathy - I believe our work as singers is a rich environment for these pursuits. If we are courageous enough to allow ourselves to be heard, and really seen, I think we can create things that speak to an audience. Perhaps through seeing and hearing us, they can be encouraged to see and hear others.&quot;"
slug = "spotlight-on-emily-edmonds"
title = "Spotlight on: Emily Edmonds"
+++

## Why do you sing, and why are you doing it professionally?

I was always immensely moved by music itself; music connects us beyond words, and singing connects bodies. However, this is only a small part of the reality of being a professional singer - I chose to be a professional singer for more than the beauty of music; I chose to be a professional singer for the daily reality of the work.

As a young singer and actor, I fell in love with the rehearsal room. The deep, interrogative, ambitious work that happens there. The great privilege of being part of that huge team, who are all daring to see what can be discovered, created.

I value making, creating, and empathy - I believe our work as singers is a rich environment for these pursuits. If we are courageous enough to allow ourselves to be heard, and really seen, I think we can create things that speak to an audience. Perhaps through seeing and hearing us, they can be encouraged to see and hear others.

Singing inhabits a different physical space than speech, or music alone, ever can. Singing connects bodies: we are connected to the audience through breath, through a visceral understanding of what it means to be human. If we can inhabit that space of heightened physicality without border or boundary, it allows us to speak with on some other level about the human experience; to connect from core to core.

If singing can offer these things, even just for a minute or two, it seems to me a worthy pursuit.

## What does "good singing" mean to you? What does it feel like when you achieve it?

Good singing is the ability to be open, present, vulnerable. To be brave and daring, both in rehearsal room and on stage. Technique, body freedom, connection to breath all facilitate this freedom. But for meaningful work to happen, it needs to be more than beautiful, more than technically accomplished. It needs to be vulnerable; nothing preventing the core of you connecting to the core of the listener.

This is an immense and lifelong pursuit, and perhaps too lofty a goal. However, in the moments of bliss - where all the working and daring and failing and trying pay off - I am reminded that it's the only possible thing I could ever consider chasing.

The moments of bliss are: the moment of empathy; the moment when somewhere in the space between stage and audience, the work becomes more than the sum of its parts; the moment when you are so vulnerably present within your own skin, and the story that you and your colleagues are telling, that the stage becomes something magically more than a stage. I think that is good singing.

It's hard. And scary. But worth it. I don't get it right every day. I don't get it right every second day. But when the point becomes not to be perfect, but instead to front up and give as much of your open self as possible on any given day - then that becomes something else. That becomes something worth doing, worth making, and something that will endure. It becomes humans in a room doing their best to be courageous, to give of their innermost selves. And that, surely, has to be the point.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498801944169/2017-06-28---Emily-Edmonds-Portrait-2.jpg.jpg)
<figcaption>Emily Edmonds, mezzo-soprano.</figcaption>
</figure>

## What do young singers need to do more of? What should they do less of?

Work hard - preparation, technique, languages, stagecraft, body freedom are all key. But more importantly - know why you’re doing this. Know what you value.

Know what you value, as a human being and an artist, and let your life and your work stand for that. Self-awareness allows empathy and vulnerability. Have the courage to know yourself, and what you're about. Sit down, write out what you value. Then make the changes and choices that allow your life and career to reflect these things that are integrally and uniquely important to you.

Be internally referent, not externally referent; measure your success according to those true values of yours - not according to what others believe indicates success.

Stop the B-grade movies - don't waste your creative energy on writing terrible movie scripts in your mind about what your audition panel/conductor/director/barista might think of you. You can't know what they think, and further to that, you can’t control what they think. Do yourself a really big favour, and stop with the B-grade movies. Catch them, see them for what they are, and then throw them out the nearest window.

Have courage. To turn up and be seen as you are, in that moment. Whether it be in audition, rehearsal room, or in conversation, know that what you are today is enough. You will always be growing, developing, improving. But don't let that stop you from giving all that you have today.

## Do you have any "bucket list" roles you'd like to sing (realistically or otherwise)?

Cherubino in *Le Nozze di Figaro*, because it's the very first opera I ever saw; every time I see that opera, it brings me all the quiet and full joy of the very best visits to old friends.

Octavian in *Der Rosenkavalier*, because I am always inarticulably moved by the "bigness" of the work, both musically and thematically. This is a human story, played out on a sweeping scale. There are moments of such pure bliss in this work.

Komponist in *Ariadne auf Naxos*, because I admire his voice, what he stands for, and that he stands for it with such conviction.

Coming from a theatre background, I have always been moved by the music of words just as I am moved by music itself. Because of that, I can't steer my heart away from wanting to act Shakespeare's women - any of them, all of them - and speaking, living, that text on a stage.

## What have you learned about your career as a singer, solely through professional experience?

I have learnt things I never knew about being part of a team, a "tribe". I have learnt about how wide and fierce the tribe stretches around you when you are in need of support.

How when we see courage on and off stage, we believe a little more in humanity. How standing up for yourself can give others the hope they need to stand up for themselves, too.

I have learnt that people are always doing their best. They might struggle, and rage, and wrestle - but they are always doing their best. There is always a positive mutual aim to be found.

I have learnt that other people are scared, too; when you feel nervous, when you feel afraid that you're not enough, know that others have been - and potentially are right now - in that space with you. You are not alone. When you feel scared, know that it's okay - choose not to act out of your fear, act out of your courage.

I have learnt that I am going to be pursuing these ideals, these values, for my whole life - artistic and otherwise. They are scary, enormous, and lofty. I won’t achieve these every day; sometimes I will fail spectacularly. But I would certainly rather be down on that stage trying fiercely, than just dreaming of all the things I could make and create and dare to become.
