+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-06-22T12:23:00-06:00"
lastmod = "2017-06-22T21:25:00-06:00"
preamble = "Based in Brooklyn, NY, Canadian soprano [Danielle Buonaiuto](/scene/people/danielle-buonaiuto/) is one of those tirelessly versatile freelance artists of the 21st century. She sings in choral, chamber, and solo settings, and she is currently Executive Director of [Musica Viva NY](http://musicaviva.org/).\n\nBuonaiuto's artistic work comes out of a continuous search for projects which are collaborative, meaningful, and which lie outside of her comfort zone. In our latest Spotlight interview, she chats about what it means for classical music to be \"accessible\", and her striving for the \"full effect\" onstage."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498187030234/2017-06-22---Danielle-Buonaiuto.jpg.jpg"
primary_image_credit = "Photo: Karjaka Studios."
publishDate = "2017-06-22T21:14:00-06:00"
related_articles = ["articles/talking-with-singers-sasha-cooke.md","articles/tenor-mezzo-transition.md","articles/spotlight-on-anush-hovhannisyan.md","articles/spotlight-on-danika-loren.md","articles/talking-with-singers-charlotte-mundy.md"]
related_people = ["scene/people/danielle-buonaiuto.md"]
short_description = "&quot;A successful performance is happening when I can make some eye contact, elicit laughter or other commentary, feel energy coming back from the audience - in short, when everyone in the room is engaged in the moment with me. After such a concert, I&#039;ll often have audience members want to connect with me directly to talk with me about the experience.&quot;"
slug = "spotlight-on-danielle-buonaiuto"
title = "Spotlight on: Danielle Buonaiuto"
+++

## Why do you pursue the arts, and why are you doing it professionally?
	
I've always been a disciple of the humanities. My childhood was spent reading voraciously and indiscriminately; my adolescence in dance classes, community theatre, and drama training at my arts high school; and it was a foregone conclusion that my Bachelors degree would be of the BA variety (in fact, it was a B.Mus). Going to school for music opened my eyes as to the interdisciplinary, comparative nature of any pursuit of the arts. It is as if everything I have ever done in my life out of interest or edification has led me here - every book I've read, language I've learned, dance step I've mastered, painting I’ve studied, poem I've memorized, essay I've written interact with each other in the complex cultural history that I’m contributing to in my professional life. So, in a way, I come by it very honestly. 

A career in the arts was never in question given my interests and values - the arts are a perfect vehicle to cultivate community and foster inclusive spaces, process and gloss current events and big, abstract ideas, and elevate issues and voices that need visibility. 

In my administrative life, I work with organizations that have these aims at their hearts. I'm currently the Executive Director of [Musica Viva NY](http://musicaviva.org/), which has a long history of adventurous programming and an affiliation with All Souls Unitarian Church on the Upper East Side, which was a driving force in activism during the AIDS crisis in the 80's and 90's in New York. In my personal artistic projects, I'm currently exploring narratives with deep emotional import through my [landscape project](http://www.daniellebuonaiuto.com/o-sea-starved-hungry-sea.html), and I'm moving into new projects that will explore feminist and queer narratives. Performance art happens to be my vehicle, but I believe just as strongly in visual media, the literary arts, and other media that achieve these goals, and actively support them as an audience member and donor. 

A life as an artist is a vocation: it is sometimes - no, often - difficult to draw the line between who you are at work, and who you are. This can have its emotional challenges - especially if things aren't going so well. I'm someone who needs her work to be deeply meaningful, and I like that I can live my values through my work. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498187060589/2017-06-22---IMG_0258.jpg.jpg)<figcaption>Danielle Buonaiuto (left) and Lisa Perry, REXDuo. Photo: Tim Steenland.</figcaption>
</figure>

## What are your priorities when you step on stage? What does it feel like when you are successful in performance?
 
I am really interested in the "full effect" - visual and theatrical aspects of a concert are very important to me, even if it's not a theatre piece. This is because I want to create an environment which cues the audience to be open to the concepts, ideas, and emotions we’re about to explore. This goes for everything from a Brahms *Requiem* to the most intimate of art song recitals, as well as the new music I'm often presenting. 

"Accessibility" is a word that has a pejorative connotation; I'd like to posit that access is something with which we all need to be preoccupied. I want people who don't usually find themselves at a classical music concert to feel that this is for them. Whether those barriers to access have to do with education, socioeconomic situation, race, age, geography, language, ability, or anything else, I want my presence, my programming, and my curation to create a feeling of inclusion and availability. I'm not always in control behind the scenes, but work hard in my administrative life to get those people in the concert hall. 

A successful performance is happening when I can make some eye contact, elicit laughter or other commentary, feel energy coming back from the audience - in short, when everyone in the room is engaged in the moment with me. After such a concert, I'll often have audience members want to connect with me directly to talk with me about the experience. 
 
## What do young artists need to do more of? 
 
I think getting a chance to self-produce a few events is a great trial-by-fire for young artists, especially those who are eager and energetic with a lot to offer, who are finding it hard to get performance opportunities. We end up spending a lot of energy, time, and money trying to get other people let us make some art, and if we have good ideas and a solid artistic product, it is sometimes better - financially, not to mention artistically and psychologically - to just do it ourselves. In any case, self-presenting will teach you a lot about the market and your place in it. I've learned everything I know about administration on my feet. 

Another thing that young artists can think about is their contributions to the field beyond their own particular artistic practice. You can't expect support from the artistic community if you don't show up for that community. Examine your habits: whose concerts and shows are you attending? Are you making any donations, however small? Are you talking to other artists and asking insightful questions about their artistic projects? Are you listening to music by composers you know, and reading poetry by local writers, just in case you might want to commission them? Do you have a list of people you can recommend when you aren’t able to take a gig? There is, in fact, room for everyone in this field, and the days of every person for themselves are over - more active involvement in the field as a whole is what's needed for a healthy ecosystem.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498187068000/2017-06-22---Buonaiuto_Headshot_hires.jpg.jpg)<figcaption>Photo: Macbeth Studios.</figcaption>
</figure>

## Do you have any "bucket list" items for your artistic career? 

I'm so glad you asked. I dream of running a communal artistic facility - like a colony or retreat- for performing artists. It would consist of a number of small private dwellings and a large, communal multipurpose building, with a concert space, rehearsal spaces, library, common room, mess kitchen, and garden. The facility would be home to an arts series, educational programming, and short-term artistic retreats, and be staffed by artists who spend a season in residence. 

I'm having a lot of conversations lately with artists who feel the same way as me about resource sharing, in art and life, and I think this is one way for us to be stronger together. 

More prosaically, I'd really love to say by the end of my career that I'd made significant contributions to the literature, the educational system, and the financial health of the field. I’d like to be the reason some major works for voice exist, and I think I've got a book in me somewhere. I'm also interested as an administrator in improving the long-term financial prospects of individual artists, through involvement with personal finance workshops, as well as foundations and granting organizations. 
 
## What have you learned about your career as an artist, solely through professional experience?

I've learned just how intertwined our fates are as artists - within music and beyond - and how much we need to rely on the network and on each other's support in order to be successful. My career has been so much about collaboration and interaction, both in the way things get organized and planned, and also in performance - I never have a performance experience that feels like a solo. 

I've learned to communicate about my aims and about what I'm working on, because sharing information is the way things progress- there has been no such thing as keeping a good idea to myself. I've learned how much my success is due to the support of mentors and colleagues, and to being ready when a good dose of luck comes my way. 

Most of all, I've learned how rewarding I feel it is to go out and mount the show I want to put on, and that this spirit of grassroots entrepreneurship is keeping the field alive and evolving in a deeply energizing way. That's something I always want to be a part of.

>Do you know an artist deserving of a little Spotlight? Let us know! Get in touch at [hello@schmopera.com.](mailto:hello@schmopera.com)
