+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-06-24T17:48:00-06:00"
lastmod = "2015-06-25T14:53:00-06:00"
preamble = "This interview is part of our ongoing series of features on young working artists in the opera industry. If you think you'd be a great candidate for an interview, or know someone you'd like to nominate, get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1435189784340/so716bw.jpg.jpg"
publishDate = "2015-06-25T14:41:00-06:00"
related_articles = ["articles/spotlight-on-michelle-siemens.md","articles/spotlight-on-peter-bass.md","articles/spotlight-on-emily-peragine.md","articles/spotlight-on-julia-dawson.md","articles/spotlight-on-charlotte-knight.md","articles/spotlight-on-maikai-nash.md","articles/spotlight-on-kelsey-vicary.md","articles/spotlight-on-lida-szkwarek.md","articles/spotlight-on-danielle-macmillan.md","articles/spotlight-on-marjorie-maltais.md","articles/spotlight-on-william-ford.md","articles/spotlight-on-kimberleyann-bartczak.md","articles/spotlight-on-laurelle-jade-froese.md","articles/spotlight-on-jeremy-hirsch.md","articles/spotlight-on-maeve-palmer.md","articles/talking-with-directors-operas-marvel.md","articles/spotlight-on-cairan-ryan.md","articles/spotlight-on-sara-schabas.md","articles/spotlight-on-jeremy-bowes.md","articles/spotlight-on-amanda-majeski.md","articles/at-the-podium-jordan-de-souza.md","articles/spotlight-on-christopher-allen.md","articles/talking-with-conductors-lidiya-yankovskaya.md"]
related_companies = ["scene/companies/opera-on-the-avalon.md","scene/companies/sarasota-opera.md"]
related_people = ["scene/people/christopher-james-ray.md"]
short_description = "Christopher James Ray is a rising conductor based out of Houston, TX. In recent seasons, Christopher has been busy at Florida State Opera and Sarasota Opera, and he&#039;ll make his debut at Opera on the James in 2015/16. Christopher is a student and protégé of American composer Carlisle Floyd, having assisted him on Of Mice and Men in 2012, and recording an album of Floyd&#039;s songs with mezzo-soprano Susanne Mentzer."
slug = "spotlight-on-christopher-james-ray"
title = "Spotlight on: Christopher James Ray"
+++

[Christopher James Ray](/scene/people/christopher-james-ray/) is a rising conductor based out of Houston, TX. In recent seasons, Christopher has been busy at Florida State Opera and Sarasota Opera, and he'll make his debut at Opera on the James in 2015/16. Christopher is a student and protégé of American composer Carlisle Floyd, having assisted him on *Of Mice and Men* in 2012, and recording an [album](http://www.amazon.com/C-Floyd-Letter-Susanne-Mentzer/dp/B00G4U7UNK) of Floyd's songs with mezzo-soprano Susanne Mentzer. I asked Christopher about being a singer-friendly conductor, and investing in contemporary works.

### 1. How does the role of the conductor differ between opera and symphonic work?

Many of the basics are the same, of course, but for opera the conductor must communicate (at least) one additional piece of information: what is happening on stage. They must let the players know not only the dramatic impetus of a scene, but also technical matters, i.e., the singer is taking time here, we are waiting for the curtain to come down/up, cadenza ends.......NOW.

### 2. What makes a conductor “singer-friendly?"

My idea of ‘singer-friendly’ really comes from the breath: taking time in the accompaniment/orchestra to facilitate the singers’ breath and allow them to sing comfortably. However, this is an important principle in non-vocal music as well; music, in general, needs time to breathe. 

Other traits of a ‘singer-friendly’ conductor that are more in the job description of a prompter, but very important in an industry where very few houses now employ prompters: cuing entrances when needed, sensing when the singer is unsure of an entrance/text/staging and providing assistance.

### 3. What kind of communication skills does a conductor need to work in opera?

Many of the rehearsal/performance communication skills seem obvious, but an often overlooked communication skill is the ability to RECEIVE information; it is as important for the conductor as the ability to send information. Perhaps a slight tempo adjustment would make a figure more idiomatic for the violins, the conductor must receive that information and then send it out to the rest of the orchestra. This also ties in to the connection between pit and stage mentioned earlier.

Apart from the duties of rehearsal and performance, a conductor is usually the face of their artistic organization as well. They need the skills to hold press interviews, speak at board meetings, and socialize at pre/post performance events and fundraisers. The list never ends.

### 4. What does opera need more of? What does it need less of?

Opera needs more attention to detail. When I think of the last 10 operas I’ve seen at various companies, the thing that sets the good apart from the bad is the attention to detail; from typographical errors and blown light bulbs to wrong notes and poor projection alignment. The companies that take care of the small things have usually done the proper planning to do the big things successfully as well.

Opera needs a less corporate mindset with regard to programming. Of course financial prudence is of utmost importance in the arts, but there is a sense that each production on a company’s season must pay for itself. That mindset leaves a tight or non-existent budget for new or lesser-known works. We can’t expect to develop the public’s taste for a variety of operatic styles if we do lavish productions of standard repertoire and meager productions for the less commercially successful works.

### 5. Do you have a "bucket list" opera that you'd love to conduct? Why?

Any of the operas of my teacher and mentor Carlisle Floyd. I have had opportunity to work on a number of Floyd productions, but have not yet conducted one of my own. *Of Mice and Men* is at the absolute top of the list.
