+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2017-05-29T07:17:00-06:00"
lastmod = "2017-06-06T21:41:00-06:00"
preamble = "British-Canadian soprano [Christina Haldane](/scene/people/christina-haldane/) has built her career on both sides of the Atlantic, and she seems like an endless source of inspired energy. Rossini, Handel, Donizetti, and lesser-known versions of Cleopatra fill her schedule, and her understudy work brought her to Salzburg and London for the premiere performances of Thomas Adès' *The Exterminating Angel*.\n\nHaldane chats about her childhood spent in self-produced \"one-woman productions\", facing the realities of vocal limitations, and how to free oneself of \"student-itis\"."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496064216596/2017-05-29---Christina-Haldane-Headshot.jpg.jpg"
primary_image_credit = "Photo: Kristin Hoebermann."
publishDate = "2017-06-06T21:41:00-06:00"
related_articles = ["articles/spotlight-on-stephanie-tritchew.md","articles/spotlight-on-rihab-chaieb.md","articles/spotlight-on-adam-fisher.md","articles/spotlight-on-hannah-de-priest.md"]
related_companies = ["scene/companies/royal-opera-house.md"]
related_people = ["scene/people/christina-haldane.md"]
short_description = "&quot;I feel one of the biggest challenges for us all not to compare our own successes with others. Have faith in your abilities and learn to keep re-defining your image of what &#039;success&#039; looks like to you. Check in with what the &#039;old&#039; you in a rocking chair would say about the choices you make now, any regrets? &quot;"
slug = "spotlight-on-christina-haldane"
title = "Spotlight on: Christina Haldane"
+++

## Why do you sing, and why are you doing it professionally?

I sing because it brings me great joy: it's a unique way to communicate and keeps me creatively curious. From a very young age I was drawn to communicating with drama, and subjected my family to endless one-woman productions in our living room! Initially I had childhood aspirations of being an actress and loved participating in theatrical productions. When I was in the last few years of high school in Victoria, BC, I first experienced the marriage of drama and music, by performing in my school's musical productions. I was hooked. 

For me, it is this desire to communicate through music, immerse myself in the character and text, plus live in that crystallized moment of human connection that arises from being on stage. My voice had presented me with the best medium for my love of performing and communicating, so I decided to pursue formal classical training and go from there.

WHY singing is my professions is because I can't picture myself doing anything else. This is not to say that I haven't had doubts along the way, I would attest that most musicians question their choice to perform professionally at times. About four years ago I had mused on changing professions completely, however a very short-lived vocal health episode convinced me otherwise. The fleeting thought that I actually couldn't sing ended up providing me with the greatest gift: the confirmation that I simply couldn't do anything else BUT sing. 

Oh, and I love the dresses and costumes of course! The frocks are of the outmost importance, the best to date being an 8 meter long dress I wore while suspended from the ceiling to sing "v'adoro pupille"... I wish I could have kept it, as it would be fun love to wear it out for my weekly grocery run in Roncy.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496064839440/2017-05-29---Cleopatra-11.jpg.jpg)<figcaption>Christina Haldane (left) as Cleopatra in *Giulio Cesare in Egitto*, Finnish National Opera, 2012.</figcaption>
</figure>

## What does "good singing" mean to you? What does it feel like when you achieve it?

The fascinating thing about "good singing" is that whilst most singers agree on what works, many feel the processes of good singing differently in their bodies. No two bodies or voices are the same, how great is that? It's a lifelong exploration! Singing is very much a physical activity, however I aim to free myself of as much un-needed muscular tension as I can. For me, memorizing the music and text early on in the process is essential, by singing softly down the octave and speaking the text out loud. Only when that initial work is done do I begin singing the music into my body, with practice at full voice. 

This way I don't bring any of the unnecessary muscular tensions associated with the intellectual side of learning repertoire into my voice. I'm then ready to combine the emotion of the piece and the architecture of the music in a more harmonious way. When everything lines up, and I’m in the flow of singing well, it feels like everything and nothing at the same time: like flying almost! It's so liberating.

## What do young singers need to do more of? What should they do less of?

It's a challenging work environment at the moment, and I speak with many singers, both young and not so young, who are worried about their career options, which is completely understandable. It's so important as colleagues to keep this dialogue going, and platforms like Schmopera are a really great way of keeping the information flowing! I can only speak from personal experience, and I certainly don't have all the answers, however I'm always happy to discuss anything with young singers. Just [get in touch!](mailto:info@christinahaldane.com)

In terms of advice, I'd say to focus on the joy and curiosity that the singing world provides: explore your repertoire, work hard, get immersed in your local music scene, enjoy the process of your own artistic development and delve into collaborating with your colleagues. Find your niche, what is it that you have to say as an artist? We are learning throughout our whole careers, so don't get overwhelmed with your technical goals, which are a long term process. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496064789940/2017-05-29---Hadane---Marie---regiment-1.jpg.jpg)
<figcaption>Christina Haldane as Marie in *La fille du régiment*, 2010.</figcaption>
</figure>

So, when you are on a performance day, accept what you have to offer in the present moment and close the door to the practice studio, that's for the following days, months, years! Don't suffer from "student-itis": in the training environment we get plenty of guidance, so be your own teacher and only keep what works best for you. 

I feel one of the biggest challenges for us all not to compare our own successes with others. Have faith in your abilities and learn to keep re-defining your image of what "success" looks like to you. Check in with what the "old" you in a rocking chair would say about the choices you make now, any regrets? 

Above all GO FOR IT, and keep going for it for as long as it pleases you.

## In your experience working in Canada and in the UK, what differences do you notice about working in the local opera industries?

My operatic career has been mainly based in the UK, as I trained at the Guildhall School of Music in London and began working professionally from there. Recently I moved back to Toronto for a better work life balance and I feel I get the best of both worlds, I get to live in Canada and work in the UK! I'm relatively unknown to the companies in Canada and I've started the process of reaching out, as there is an exciting opera scene here to be explored. 

One thing I have noticed, is that in the UK there are more opportunities for singers starting out with smaller companies, in terms of performing extended runs of substantial roles. In the UK one of my first roles out of Guildhall was the title in Donizetti's *Fille du Régiment*, with a touring company that went all over England and Wales, full orchestra, about 30 dates in total. I learned so much from that experience and it showed future producers that I had the stamina to perform major repertoire on a regular basis. 

In Toronto I see a lot of artists turning to self production which contributes vibrantly to the arts scene. However, it would be great to see more options open to singers starting out, in order to bridge that gap between training and singing at the level that's right for national level Canadian companies.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1496064803111/2017-05-29---Haldane---Cleopatra-19.jpg.jpg)
<figcaption>Christina Haldane (left) as Cleopatra in *Giulio Cesare in Egitto*, Finnish National Opera, 2012.</figcaption>
</figure>

## What have you learned about your career as a singer, solely through professional experience?

A career in singing is the result of many factors. On the one side we have talent, resilience, personality type, dedication and lifestyle choices. Then there are external factors that we have less control over, such as casting preferences and simply pure luck. All we can do is prepare and perform to the best of our current abilities, while remaining adaptable and kind to our colleagues.

When stressful situations present themselves at work, I don't bring my emotions into the rehearsal room: in my mind, the beauty of the drama is best kept for the stage and I wish to be the solution and not the problem. I firmly believe that opportunities arise when talent, preparation and fate meet.

So, I don't focus too much anymore on the things I can't control and simply find joy and gratitude in what I do, as ultimately it is not about me, but about the music and communicating with others.
