+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-09-22T19:21:00-04:00"
lastmod = "2015-09-23T20:19:00-04:00"
preamble = "This interview is part of our ongoing series of features on young working artists in the opera industry. If you think you'd be a great candidate for an interview, or know someone you'd like to nominate, get in touch at [hello@schmopera.com](mailto:hello@schmopera.com)."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1442964184191/HeadshotCairanRyanHighDefSquare.jpg.jpg"
publishDate = "2015-09-24T08:00:00-04:00"
related_articles = ["articles/spotlight-on-laurelle-jade-froese.md","articles/spotlight-on-marjorie-maltais.md","articles/spotlight-on-william-ford.md","articles/spotlight-on-kimberleyann-bartczak.md","articles/spotlight-on-julia-dawson.md","articles/spotlight-on-maikai-nash.md","articles/spotlight-on-peter-bass.md","articles/spotlight-on-christopher-james-ray.md","articles/spotlight-on-danielle-macmillan.md","articles/spotlight-on-sara-schabas.md","articles/spotlight-on-jeremy-bowes.md","articles/spotlight-on-james-westman.md","articles/spotlight-on-abigail-levis.md"]
related_companies = ["scene/companies/highlands-opera-studio.md","scene/companies/against-the-grain-theatre.md","scene/companies/lopra-de-montral.md"]
related_people = ["scene/people/cairan-ryan.md"]
short_description = "&quot;I sing because it is a holistic musical experience. It&#039;s the only thing I can think of that comes close to complete participation of your brain, body, and what some people may call a soul. At its peak, it unites all three into a living, breathing instrument, that&#039;s always completely unique and arrestingly different. I sing to always find that unity.&quot;"
slug = "spotlight-on-cairan-ryan"
title = "Spotlight on: Cairan Ryan"
+++

### 1. Why do you sing, and why are you pursuing it professionally?

I sing because it is a holistic musical experience. It's the only thing I can think of that comes close to complete participation of your brain, body, and what some people may call a soul. At its peak, it unites all three into a living, breathing instrument, that's always completely unique and arrestingly different. I sing to always find that unity. I'm also not very good at anything else (apart from arguing) and I think I'd probably live in a box on the side of the road, yelling madly about the systematic oppression of the working classes, if I couldn't continue singing for a living. 

### 2. What does "good singing" mean to you? What does it feel like when you achieve it?

It's a bit like a drug, honestly:  You get certain moments, be it in a performance, coaching, rehearsal, or audition, where it all clicks and "lines up." Everything seems healthy, totally synced, glorious and addicting. Good singing to me is finding your own version of a healthy "technique," that can be imparted to you through many sources, often more than one teacher. 

To me, it all boils down to the most efficient way you, the individual artist, can impart your voice on the public, without your head exploding or you having to do jumping jacks to make your voice work. Then, it's more of an ongoing process of getting enough experience, making your own (measured) opinions on the various and never-ending aspects of classical musical style throughout the centuries, then putting that in a blender, shooting it into the sun, and walking on stage with a clear idea of what is about to happen. 

Breathing's also a good one. When you get bogged down with worrying about what sort of unearthly gymnastics your tongue might be doing in your mouth, that Schwa vowel isn't quite sounding right, or you just plain hate the conductor, remember to swallow and breathe (Thanks, [Michael McMahon](/scene/people/michael-mcmahon/). Mahler became way less scary after that advice.) 

It's a never-ending process, and we continue to aspire to good singing until the day we shuffle off this mortal coil, to the big practice room in the sky. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1442964321815/AlittletooCozyAlfonsoBanff2015.jpg.jpg)
<figcaption>Cairan Ryan as Donald Alfonso in Against the Grain Theatre's *A Little Too Cozy*, 2015. Photo: Don Lee/The Banff Centre.</figcaption>
</figure>

### 3. What do young singers need to do more of? What should they do less of?

I'm still considered a "young singer," and I fall into this trap as often as the wee bairns who are just starting large auditions tours, fresh out of conservatories or finding their own way: stop caring so much what people might want to hear you sing or what roles, styles you possibly could be shoehorned into. 

Make yourself a unique individual, a unique artist that people will eventually (or very quickly) want to hear, engage, and re-engage. Singing is about communication, and the inherent beauty that lies within that form of communication. Don't give your audition panels much of a choice: sing whatever you sing as best as possible on that day. Many of us will embark/are currently embarking on long, arduous, and soul-sucking audition tours that test the very limits of your sanity and dedication for this artform. 

In the end, it's all up to you to find that "perfect 5" arias fit you best. You want to sing all Italian? Sing all Italian, if it best represents your voice, personality and acting ability. You're 22 and you only sing Wagner? GREAT. Do that. My point is, be yourself, and don't shy away from it, no matter what heaped advice you get. Some of this advice is going to be very sound, and you can take heed of it immediately, or like me, be stubborn about it and get around to finally understanding it years later. 

However, some advice will be ludicrous, and your brain will scoff at it instantly. In this case, tuck that away for a good laugh after the audition when you're having a coffee at the Starbucks across the street and trying to awkwardly flirt with the barista. Long story short: be yourself, in your music, your work, and your life. 

### 4. Do you have a "bucket-list" role that you'd like to sing? Why?

I just performed Il Conte Almaviva in *Le nozze di Figaro* at [Highlands Opera Studio](/scene/companies/highlands-opera-studio/) and it was, up to that point, on my bucket list of roles. Mozart and Da Ponte were just bloody genii, and the amount of nuance, utter dedication and self-hatred that that role requires is frankly astounding. It was exhausting, and immensely rewarding. 

The other roles on my bucket list are Figaro in *Barbiere*, which I'm learning at the moment, and Scarpia, which I will never sing in my entire life (I just want to sing the *Te Deum* over and over and over and over again.) I also would love to sing Wozzeck at some point, because I'm apparently a masochist (and filled with delusions of grandeur). I look yearningly through some of the fuller-lyric-to-Verdi baritone roles, like Germont, Conte di Luna, and Rodrigo, and I just sigh and hope I'm reincarnated as a Verdi baritone. 

One of my dreams is to sing Papageno at the Royal Opera House in that [famous 2003 production](https://www.youtube.com/watch?v=jVQroWMjUzE), and attempt to do the "Keenlyside front-flip" during "pa-pa-pa" better than Keenlyside actually did it (It was pretty amazing.) I realise this is a very specific bucket list, and not for everyone. 

### 5. How do you explain your job to non-music folks?

I get paid to sing in a smorgasbord of languages, styles, volumes, and costumes at you and make you feel feelings. It's not going to buy me a yacht, or get me courtside season tickets to the Raptors, but at a steady level, it provides you with an infinitely rewarding, sometimes maddening, and NEVER boring life. Don't go into it for the money, go into it for the madness, the music you get to sing, the places you'll go, and do it for the life you might be able to impart to people that come after you. 

>You can hear Cairan in Montréal on November 29th, with *Viva Voce: Christmas Cantatas* at McGill University, and just maybe in Toronto this spring (details to come!). Next season Cairan makes his Netherlands Radio Philharmonic Orchestra debut in Strauss' *Intermezzo*.
